/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconRenderer
extends com.intellij.openapi.editor.markup.GutterIconRenderer
implements DumbAware {
    private final PsiElement myElement;
    private final VirtualFile myFile;
    private final ResourceResolver myResourceResolver;

    public GutterIconRenderer(ResourceResolver resourceResolver, @NotNull PsiElement element, @NotNull VirtualFile file) {
        if (element == null) {
            GutterIconRenderer.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GutterIconRenderer.$$$reportNull$$$0(1);
        }
        this.myResourceResolver = resourceResolver;
        this.myElement = element;
        this.myFile = file;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GutterIconCache.getInstance().getIcon(this.myFile.getPath(), (RenderResources)this.myResourceResolver);
        if (icon != null) {
            Icon icon2 = icon;
            if (icon2 == null) {
                GutterIconRenderer.$$$reportNull$$$0(2);
            }
            return icon2;
        }
        Icon icon3 = AllIcons.General.Error;
        if (icon3 == null) {
            GutterIconRenderer.$$$reportNull$$$0(3);
        }
        return icon3;
    }

    public AnAction getClickAction() {
        return new GutterIconClickAction(this.myFile, this.myResourceResolver);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GutterIconRenderer that = (GutterIconRenderer)((Object)o);
        if (!this.myElement.equals(that.myElement)) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        int result2 = this.myElement.hashCode();
        result2 = 31 * result2 + this.myFile.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GutterIconClickAction
    extends AnAction {
        private static final int PREVIEW_MAX_WIDTH = JBUIScale.scale((int)128);
        private static final int PREVIEW_MAX_HEIGHT = JBUIScale.scale((int)128);
        private static final String PREVIEW_TEXT = "Click Image to Open Resource";
        private final VirtualFile myFile;
        private final ResourceResolver myResourceResolver;

        public GutterIconClickAction(VirtualFile file, ResourceResolver resourceResolver) {
            this.myFile = file;
            this.myResourceResolver = resourceResolver;
        }

        public void actionPerformed(AnActionEvent event) {
            Project project;
            Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor2 != null && (project = editor2.getProject()) != null) {
                JBPopup preview = this.createPreview(() -> this.openImageResourceTab(project));
                if (preview == null) {
                    this.openImageResourceTab(project);
                } else {
                    preview.show(new RelativePoint((MouseEvent)event.getInputEvent()));
                }
            }
        }

        @Nullable
        private JBPopup createPreview(final Runnable onClick) {
            Icon icon = GutterIconFactory.createIcon(this.myFile.getPath(), (RenderResources)this.myResourceResolver, PREVIEW_MAX_WIDTH, PREVIEW_MAX_HEIGHT);
            if (icon == null) {
                return null;
            }
            final JBLabel label = new JBLabel(icon);
            ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)label, null);
            builder.setAdText(PREVIEW_TEXT, 0);
            final JBPopup popup2 = builder.createPopup();
            label.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    onClick.run();
                    popup2.cancel();
                    label.removeMouseListener((MouseListener)this);
                }
            });
            return popup2;
        }

        private void openImageResourceTab(@NotNull Project project) {
            if (project == null) {
                GutterIconClickAction.$$$reportNull$$$0(0);
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, this.myFile, -1);
            FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/rendering/GutterIconRenderer$GutterIconClickAction", "openImageResourceTab"));
        }
    }
}

