/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.IImageFactory;
import com.intellij.reference.SoftReference;
import java.awt.image.BufferedImage;

class CachingImageFactory
implements IImageFactory {
    private SoftReference<BufferedImage> myCachedImageReference;
    private final IImageFactory myDelegate;
    private int myCachedWidth;
    private int myCachedHeight;

    CachingImageFactory(IImageFactory delegate) {
        this.myDelegate = delegate;
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage cached;
        BufferedImage bufferedImage = cached = this.myCachedImageReference != null ? (BufferedImage)this.myCachedImageReference.get() : null;
        if (cached == null || this.myCachedWidth != width || this.myCachedHeight != height) {
            cached = this.myDelegate.getImage(width, height);
            this.myCachedWidth = width;
            this.myCachedHeight = height;
            this.myCachedImageReference = new SoftReference((Object)cached);
        }
        return cached;
    }
}

