/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddMissingAttributesFix
extends WriteCommandAction<Void> {
    @NotNull
    private final XmlFile myFile;
    @Nullable
    private final ResourceResolver myResourceResolver;

    public AddMissingAttributesFix(@NotNull Project project, @NotNull XmlFile file, @Nullable ResourceResolver resourceResolver) {
        if (project == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(1);
        }
        super(project, "Add Size Attributes", new PsiFile[]{file});
        this.myFile = file;
        this.myResourceResolver = resourceResolver;
    }

    @NotNull
    public static List<SmartPsiElementPointer<XmlTag>> findViewsMissingSizes(@NotNull XmlFile file, @Nullable ResourceResolver resolver) {
        if (file == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(2);
        }
        ArrayList missing = Lists.newArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            Collection xmlTags = PsiTreeUtil.findChildrenOfType((PsiElement)file, XmlTag.class);
            for (XmlTag tag : xmlTags) {
                if (!AddMissingAttributesFix.requiresSize(tag) || AddMissingAttributesFix.definesWidth(tag, resolver) && AddMissingAttributesFix.definesHeight(tag, resolver)) continue;
                missing.add(SmartPointerManager.createPointer((PsiElement)tag));
            }
        });
        ArrayList arrayList = missing;
        if (arrayList == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    protected void run(@NotNull Result<Void> result2) throws Throwable {
        if (result2 == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(4);
        }
        AddMissingAttributesFix.findViewsMissingSizes(this.myFile, this.myResourceResolver).stream().map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).forEach(tag -> {
            if (!AddMissingAttributesFix.definesWidth(tag, this.myResourceResolver)) {
                tag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", AddMissingAttributesFix.getDefaultWidth(tag));
            }
            if (!AddMissingAttributesFix.definesHeight(tag, this.myResourceResolver)) {
                tag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", AddMissingAttributesFix.getDefaultHeight(tag));
            }
        });
    }

    public static boolean definesHeight(@NotNull XmlTag tag, @Nullable ResourceResolver resourceResolver) {
        ResourceValue st;
        String style;
        XmlAttribute height;
        boolean definesHeight;
        if (tag == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(5);
        }
        boolean bl = definesHeight = (height = tag.getAttribute("layout_height", "http://schemas.android.com/apk/res/android")) != null;
        if (definesHeight) {
            String value2 = height.getValue();
            if (value2 == null || value2.isEmpty()) {
                return false;
            }
            return value2.equals("wrap_content") || value2.equals("fill_parent") || value2.equals("match_parent") || value2.startsWith("@") || value2.startsWith("?") || Character.isDigit(value2.charAt(0));
        }
        if (resourceResolver != null && (style = tag.getAttributeValue("style")) != null && (st = resourceResolver.findResValue(style, false)) instanceof StyleResourceValue) {
            StyleResourceValue styleValue = (StyleResourceValue)st;
            definesHeight = resourceResolver.findItemInStyle(styleValue, "layout_height", true) != null;
        }
        return definesHeight;
    }

    public static boolean definesWidth(@NotNull XmlTag tag, @Nullable ResourceResolver resourceResolver) {
        ResourceValue st;
        String style;
        XmlAttribute width;
        boolean definesWidth;
        if (tag == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(6);
        }
        boolean bl = definesWidth = (width = tag.getAttribute("layout_width", "http://schemas.android.com/apk/res/android")) != null;
        if (definesWidth) {
            String value2 = width.getValue();
            if (value2 == null || value2.isEmpty()) {
                return false;
            }
            return value2.equals("wrap_content") || value2.equals("fill_parent") || value2.equals("match_parent") || value2.startsWith("@") || value2.startsWith("?") || Character.isDigit(value2.charAt(0));
        }
        if (resourceResolver != null && (style = tag.getAttributeValue("style")) != null && (st = resourceResolver.findResValue(style, false)) instanceof StyleResourceValue) {
            StyleResourceValue styleValue = (StyleResourceValue)st;
            definesWidth = resourceResolver.findItemInStyle(styleValue, "layout_width", true) != null;
        }
        return definesWidth;
    }

    @NotNull
    private static String getDefaultWidth(@NotNull XmlTag tag) {
        String parent;
        XmlTag parentTag;
        if (tag == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(7);
        }
        if ((parentTag = AddMissingAttributesFix.getParentTag(tag)) != null && ((parent = parentTag.getName()).equals("FrameLayout") || parent.equals("TableLayout") || parent.equals("TableRow"))) {
            if ("match_parent" == null) {
                AddMissingAttributesFix.$$$reportNull$$$0(8);
            }
            return "match_parent";
        }
        if ("wrap_content" == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(9);
        }
        return "wrap_content";
    }

    @NotNull
    private static String getDefaultHeight(@NotNull XmlTag tag) {
        String parent;
        XmlTag parentTag;
        if (tag == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(10);
        }
        if ((parentTag = AddMissingAttributesFix.getParentTag(tag)) != null && (parent = parentTag.getName()).equals("FrameLayout")) {
            if ("match_parent" == null) {
                AddMissingAttributesFix.$$$reportNull$$$0(11);
            }
            return "match_parent";
        }
        if ("wrap_content" == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(12);
        }
        return "wrap_content";
    }

    @Nullable
    private static XmlTag getParentTag(@NotNull XmlTag tag) {
        PsiElement parent;
        if (tag == null) {
            AddMissingAttributesFix.$$$reportNull$$$0(13);
        }
        if ((parent = tag.getParent()) instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    private static boolean requiresSize(XmlTag tag) {
        String parentName;
        XmlTag parentTag = AddMissingAttributesFix.getParentTag(tag);
        if (parentTag != null && ("GridLayout".equals(parentName = parentTag.getName()) || SdkConstants.FQCN_GRID_LAYOUT_V7.isEquals(parentName))) {
            return false;
        }
        String tagName = tag.getName();
        if (tagName.equals("requestFocus") || tagName.equals("merge") || tagName.equals("include")) {
            return false;
        }
        return !tagName.equals("layout") && !tagName.equals("variable") && !tagName.equals("data") && !tagName.equals("import");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/AddMissingAttributesFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/AddMissingAttributesFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewsMissingSizes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultWidth";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHeight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findViewsMissingSizes";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "definesHeight";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "definesWidth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultWidth";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultHeight";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

