/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem.gradle;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.fd.InstantRunConfigurable;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.projectsystem.CapabilityStatus;
import com.android.tools.idea.projectsystem.CapabilitySupported;
import com.android.tools.idea.projectsystem.CapabilityUpgradeRequired;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"getInstantRunCapabilityStatus", "Lcom/android/tools/idea/projectsystem/CapabilityStatus;", "module", "Lcom/intellij/openapi/module/Module;", "updateProjectToInstantRunTools", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.projectSystem.gradle"})
public final class InstantRunKt {
    @NotNull
    public static final CapabilityStatus getInstantRunCapabilityStatus(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        return androidModel == null || InstantRunGradleUtils.modelSupportsInstantRun(androidModel) ? (CapabilityStatus)new CapabilitySupported() : (CapabilityStatus)new CapabilityUpgradeRequired(null, null, 3, null);
    }

    public static final boolean updateProjectToInstantRunTools(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GradleVersion pluginVersion = InstantRunGradleUtils.MINIMUM_GRADLE_PLUGIN_VERSION;
        AndroidPluginGeneration androidPluginGeneration = AndroidPluginGeneration.ORIGINAL;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidPluginGeneration, (String)"AndroidPluginGeneration.ORIGINAL");
        GradleVersion pluginMinRecommendedVersion = GradleVersion.parse((String)androidPluginGeneration.getLatestKnownVersion());
        GradleVersion gradleLatestVersion = GradleVersion.parse((String)"4.10.1");
        if (pluginMinRecommendedVersion.compareTo(pluginVersion) > 0) {
            pluginVersion = pluginMinRecommendedVersion;
        }
        AndroidPluginVersionUpdater androidPluginVersionUpdater = AndroidPluginVersionUpdater.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)androidPluginVersionUpdater, (String)"AndroidPluginVersionUpdater.getInstance(project)");
        AndroidPluginVersionUpdater updater = androidPluginVersionUpdater;
        AndroidPluginVersionUpdater.UpdateResult updateResult = updater.updatePluginVersion(pluginVersion, gradleLatestVersion);
        Intrinsics.checkExpressionValueIsNotNull((Object)updateResult, (String)"updater.updatePluginVers\u2026ion, gradleLatestVersion)");
        AndroidPluginVersionUpdater.UpdateResult result2 = updateResult;
        if (result2.isPluginVersionUpdated() && result2.versionUpdateSuccess()) {
            Revision revision;
            String buildToolsVersion2 = "23.0.2";
            AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSdkHandler, (String)"AndroidSdks.getInstance().tryToChooseSdkHandler()");
            AndroidSdkHandler sdk = androidSdkHandler;
            BuildToolInfo latestBuildTool = sdk.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(InstantRunConfigurable.class), false);
            if (latestBuildTool != null && (revision = latestBuildTool.getRevision()).compareTo(Revision.parseRevision((String)buildToolsVersion2)) > 0) {
                String string = revision.toShortString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"revision.toShortString()");
                buildToolsVersion2 = string;
            }
            GradleUtil.setBuildToolsVersion(project, buildToolsVersion2);
            GradleWrapper gradleWrapper = GradleWrapper.find(project);
            if (gradleWrapper != null) {
                gradleWrapper.updateDistributionUrlAndDisplayFailure("4.10.1");
                return true;
            }
        }
        return false;
    }
}

