/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.projectsystem;

import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystemProvider;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/projectsystem/ProjectSystemService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedProjectSystem", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectSystem", "getProjectSystem", "()Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "detectProjectSystem", "Companion", "intellij.android.projectSystem"})
public class ProjectSystemService {
    private final AtomicReference<AndroidProjectSystem> cachedProjectSystem;
    @NotNull
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public AndroidProjectSystem getProjectSystem() {
        AndroidProjectSystem cache = this.cachedProjectSystem.get();
        if (cache == null) {
            cache = this.detectProjectSystem(this.project);
            this.cachedProjectSystem.compareAndSet(null, cache);
            AndroidProjectSystem androidProjectSystem = this.cachedProjectSystem.get();
            if (androidProjectSystem == null) {
                Intrinsics.throwNpe();
            }
            cache = androidProjectSystem;
        }
        return cache;
    }

    private final AndroidProjectSystem detectProjectSystem(Project project) {
        AndroidProjectSystemProvider androidProjectSystemProvider;
        Object v1;
        AndroidProjectSystemProvider it;
        boolean bl;
        Iterable iterable;
        boolean bl2;
        Iterable iterable2;
        List extensions;
        block4: {
            List list = ProjectSystemUtil.getEP_NAME().getExtensions((AreaInstance)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"EP_NAME.getExtensions(project)");
            extensions = list;
            iterable2 = extensions;
            bl2 = false;
            iterable = iterable2;
            bl = false;
            for (Object t : iterable) {
                it = (AndroidProjectSystemProvider)t;
                boolean bl3 = false;
                if (!it.isApplicable()) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        if ((androidProjectSystemProvider = (AndroidProjectSystemProvider)v1) == null) {
            Object v3;
            block5: {
                iterable2 = extensions;
                bl2 = false;
                iterable = iterable2;
                bl = false;
                for (Object t : iterable) {
                    it = (AndroidProjectSystemProvider)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"")) continue;
                    v3 = t;
                    break block5;
                }
                v3 = null;
            }
            androidProjectSystemProvider = v3;
        }
        if (androidProjectSystemProvider == null) {
            throw (Throwable)new IllegalStateException("Default AndroidProjectSystem not found for project " + project.getName());
        }
        AndroidProjectSystemProvider provider = androidProjectSystemProvider;
        return provider.getProjectSystem();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ProjectSystemService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.cachedProjectSystem = new AtomicReference();
    }

    @JvmStatic
    @NotNull
    public static final ProjectSystemService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/projectsystem/ProjectSystemService$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/projectsystem/ProjectSystemService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.projectSystem"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProjectSystemService getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, ProjectSystemService.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (ProjectSystemService)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

