/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.perfd;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.profilers.perfd.PerfdProxyService;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ProfilerServiceProxy
extends PerfdProxyService
implements AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final String EMULATOR = "Emulator";
    private final ProfilerServiceGrpc.ProfilerServiceBlockingStub myServiceStub;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final Common.Device myProfilerDevice;
    private final Map<Client, Common.Process> myCachedProcesses;
    private final boolean myIsDeviceApiSupported;

    private static Logger getLog() {
        return Logger.getInstance(ProfilerServiceProxy.class);
    }

    public ProfilerServiceProxy(@NotNull IDevice device, @NotNull ManagedChannel channel) {
        if (device == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(0);
        }
        if (channel == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(1);
        }
        super(ProfilerServiceGrpc.getServiceDescriptor());
        this.myCachedProcesses = Collections.synchronizedMap(new HashMap());
        this.myIsDeviceApiSupported = device.getVersion().getApiLevel() >= 21;
        this.myDevice = device;
        this.myServiceStub = ProfilerServiceGrpc.newBlockingStub((Channel)channel);
        if (this.myIsDeviceApiSupported) {
            Profiler.GetDevicesResponse devices = this.myServiceStub.getDevices(Profiler.GetDevicesRequest.getDefaultInstance());
            assert (devices.getDeviceList().size() == 1);
            this.myProfilerDevice = ProfilerServiceProxy.profilerDeviceFromIDevice(device, devices.getDevice(0).toBuilder());
        } else {
            this.myProfilerDevice = ProfilerServiceProxy.profilerDeviceFromIDevice(device, Common.Device.newBuilder().setBootId(String.valueOf(device.getSerialNumber().hashCode())));
        }
        ProfilerServiceProxy.getLog().info(String.format("ProfilerDevice created: %s", this.myProfilerDevice));
        this.updateProcesses();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    @NotNull
    private static Common.Device profilerDeviceFromIDevice(@NotNull IDevice device, @NotNull Common.Device.Builder builder) {
        if (device == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(2);
        }
        if (builder == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(3);
        }
        MessageDigest digest = DigestUtil.sha256();
        digest.update(builder.getBootId().getBytes(StandardCharsets.UTF_8));
        digest.update(device.getSerialNumber().getBytes(StandardCharsets.UTF_8));
        long device_id = ByteBuffer.wrap(digest.digest()).getLong();
        Common.Device device2 = builder.setDeviceId(device_id).setSerial(device.getSerialNumber()).setModel(ProfilerServiceProxy.getDeviceModel(device)).setVersion(StringUtil.notNullize((String)device.getProperty("ro.build.version.release"))).setCodename(StringUtil.notNullize((String)device.getVersion().getCodename())).setApiLevel(device.getVersion().getApiLevel()).setFeatureLevel(device.getVersion().getFeatureLevel()).setManufacturer(ProfilerServiceProxy.getDeviceManufacturer(device)).setIsEmulator(device.isEmulator()).setState(ProfilerServiceProxy.convertState(device.getState())).build();
        if (device2 == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(4);
        }
        return device2;
    }

    @NotNull
    public static Common.Device profilerDeviceFromIDevice(@NotNull IDevice device) {
        if (device == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(5);
        }
        Common.Device device2 = ProfilerServiceProxy.profilerDeviceFromIDevice(device, Common.Device.newBuilder());
        if (device2 == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(6);
        }
        return device2;
    }

    private static Common.Device.State convertState(@NotNull IDevice.DeviceState state) {
        if (state == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(7);
        }
        switch (state) {
            case OFFLINE: {
                return Common.Device.State.OFFLINE;
            }
            case ONLINE: {
                return Common.Device.State.ONLINE;
            }
            case DISCONNECTED: {
                return Common.Device.State.DISCONNECTED;
            }
        }
        return Common.Device.State.UNSPECIFIED;
    }

    @NotNull
    public static String getDeviceModel(@NotNull IDevice device) {
        if (device == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(8);
        }
        String string = device.isEmulator() ? StringUtil.notNullize((String)device.getAvdName(), (String)"Unknown") : DevicePropertyUtil.getModel(device, "Unknown");
        if (string == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getDeviceManufacturer(@NotNull IDevice device) {
        if (device == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(10);
        }
        String string = DevicePropertyUtil.getManufacturer(device, device.isEmulator() ? EMULATOR : "");
        if (string == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public void disconnect() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    public void getDevices(Profiler.GetDevicesRequest request, StreamObserver<Profiler.GetDevicesResponse> responseObserver) {
        Profiler.GetDevicesResponse response = Profiler.GetDevicesResponse.newBuilder().addDevice(this.myProfilerDevice).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getCurrentTime(Profiler.TimeRequest request, StreamObserver<Profiler.TimeResponse> responseObserver) {
        Profiler.TimeResponse response;
        if (this.myIsDeviceApiSupported) {
            try {
                response = this.myServiceStub.getCurrentTime(request);
            }
            catch (StatusRuntimeException e) {
                responseObserver.onError((Throwable)e);
                return;
            }
        } else {
            response = Profiler.TimeResponse.getDefaultInstance();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getProcesses(Profiler.GetProcessesRequest request, StreamObserver<Profiler.GetProcessesResponse> responseObserver) {
        Profiler.GetProcessesResponse response = Profiler.GetProcessesResponse.newBuilder().addAllProcess(this.myCachedProcesses.values()).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if (device == this.myDevice && (changeMask & 2) != 0) {
            this.updateProcesses();
        }
    }

    public void clientChanged(Client client, int changeMask) {
        if ((changeMask & 1) != 0 && client.getDevice() == this.myDevice && client.getClientData().getClientDescription() != null) {
            this.updateProcesses(Collections.singletonList(client));
        }
    }

    @Override
    public ServerServiceDefinition getServiceDefinition() {
        HashMap overrides = Maps.newHashMap();
        overrides.put(ProfilerServiceGrpc.METHOD_GET_DEVICES, ServerCalls.asyncUnaryCall((request, observer) -> this.getDevices((Profiler.GetDevicesRequest)request, (StreamObserver<Profiler.GetDevicesResponse>)observer)));
        overrides.put(ProfilerServiceGrpc.METHOD_GET_PROCESSES, ServerCalls.asyncUnaryCall((request, observer) -> this.getProcesses((Profiler.GetProcessesRequest)request, (StreamObserver<Profiler.GetProcessesResponse>)observer)));
        overrides.put(ProfilerServiceGrpc.METHOD_GET_CURRENT_TIME, ServerCalls.asyncUnaryCall((request, observer) -> this.getCurrentTime((Profiler.TimeRequest)request, (StreamObserver<Profiler.TimeResponse>)observer)));
        return this.generatePassThroughDefinitions(overrides, (AbstractStub)this.myServiceStub);
    }

    private void updateProcesses() {
        if (!this.myIsDeviceApiSupported) {
            return;
        }
        Set updatedClients = Arrays.stream(this.myDevice.getClients()).filter(c -> c.getClientData().getClientDescription() != null).collect(Collectors.toSet());
        Set<Client> existingClients = this.myCachedProcesses.keySet();
        ImmutableSet removedClients = Sets.difference(existingClients, updatedClients).immutableCopy();
        ImmutableSet addedClients = Sets.difference(updatedClients, existingClients).immutableCopy();
        if (!addedClients.isEmpty()) {
            this.updateProcesses((Collection<Client>)addedClients);
        }
        for (Client client : removedClients) {
            this.myCachedProcesses.remove(client);
        }
    }

    private void updateProcesses(@NotNull Collection<Client> clients) {
        Profiler.TimeResponse times;
        if (clients == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(12);
        }
        if (!this.myIsDeviceApiSupported) {
            return;
        }
        assert (this.myDevice.isOnline());
        try {
            times = this.myServiceStub.getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(this.myProfilerDevice.getDeviceId()).build());
        }
        catch (Exception e) {
            ProfilerServiceProxy.getLog().info((Throwable)e);
            return;
        }
        for (Client client : clients) {
            String description = client.getClientData().getClientDescription();
            if (description == null) continue;
            String abi = client.getClientData().getAbi();
            String abiCpuArch = abi != null && abi.contains(")") ? abi.substring(abi.indexOf("(") + 1, abi.indexOf(")")) : Abi.getEnum((String)((String)this.myDevice.getAbis().get(0))).getCpuArch();
            this.myCachedProcesses.put(client, Common.Process.newBuilder().setName(client.getClientData().getClientDescription()).setPid(client.getClientData().getPid()).setDeviceId(this.myProfilerDevice.getDeviceId()).setState(Common.Process.State.ALIVE).setStartTimestampNs(times.getTimestampNs()).setAbiCpuArch(abiCpuArch).build());
        }
    }

    @NotNull
    Map<Client, Common.Process> getCachedProcesses() {
        Map<Client, Common.Process> map2 = this.myCachedProcesses;
        if (map2 == null) {
            ProfilerServiceProxy.$$$reportNull$$$0(13);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/perfd/ProfilerServiceProxy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clients";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/perfd/ProfilerServiceProxy";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "profilerDeviceFromIDevice";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceManufacturer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedProcesses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "profilerDeviceFromIDevice";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceManufacturer";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateProcesses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

