/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.datastore.DataStoreService;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.profilers.IntellijProfilerPreferences;
import com.android.tools.idea.profilers.perfd.PerfdProxy;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.google.common.base.Charsets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.NetUtils;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.download.AndroidProfilerDownloader;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

class StudioProfilerDeviceManager
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener,
IdeSdks.IdeSdkChangeListener,
Disposable {
    private static int LIVE_ALLOCATION_STACK_DEPTH = Integer.getInteger("profiler.alloc.stack.depth", 50);
    private static final String BOOT_COMPLETE_PROPERTY = "dev.bootcomplete";
    private static final String BOOT_COMPLETE_MESSAGE = "1";
    private static final int MAX_MESSAGE_SIZE = 0x1FFFFFFF;
    private static final int DEVICE_PORT = 12389;
    private static final String DEVICE_SOCKET_NAME = "AndroidStudioProfiler";
    private static final String AGENT_CONFIG_FILE = "agent.config";
    private static final String DEVICE_DIR = "/data/local/tmp/perfd/";
    @NotNull
    private final DataStoreService myDataStoreService;
    private boolean isAdbInitialized;
    private final Map<String, DeviceContext> mySerialToDeviceContextMap;

    private static Logger getLogger() {
        return Logger.getInstance(StudioProfilerDeviceManager.class);
    }

    public StudioProfilerDeviceManager(@NotNull DataStoreService dataStoreService) {
        if (dataStoreService == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(0);
        }
        this.mySerialToDeviceContextMap = new ConcurrentHashMap<String, DeviceContext>();
        this.myDataStoreService = dataStoreService;
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.isAdbInitialized = false;
    }

    @Override
    public void sdkPathChanged(@NotNull File newSdkPath) {
        if (newSdkPath == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(1);
        }
        this.isAdbInitialized = false;
    }

    public void initialize(@NotNull Project project) {
        if (project == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(2);
        }
        if (this.isAdbInitialized) {
            return;
        }
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb != null) {
            Futures.addCallback(AdbService.getInstance().getDebugBridge(adb), (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

                public void onSuccess(AndroidDebugBridge result2) {
                    StudioProfilerDeviceManager.this.isAdbInitialized = true;
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    StudioProfilerDeviceManager.getLogger().warn(String.format("getDebugBridge %s failed", adb.getAbsolutePath()));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/profilers/StudioProfilerDeviceManager$1", "onFailure"));
                }
            }, (Executor)EdtExecutor.INSTANCE);
        } else {
            StudioProfilerDeviceManager.getLogger().warn("No adb available");
        }
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.disconnectProxies();
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge != null) {
            for (IDevice device : bridge.getDevices()) {
                this.deviceConnected(device);
            }
        } else {
            this.disconnectProxies();
        }
    }

    public void deviceConnected(IDevice device) {
        this.mySerialToDeviceContextMap.computeIfAbsent(device.getSerialNumber(), serial -> new DeviceContext());
        if (device.isOnline()) {
            this.spawnPerfd(device);
        }
    }

    public void deviceDisconnected(IDevice device) {
        this.disconnectProxy(device);
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if ((changeMask & 1) != 0) {
            if (device.isOnline()) {
                this.spawnPerfd(device);
            } else {
                this.disconnectProxy(device);
            }
        }
    }

    @NotNull
    private Runnable getDisconnectRunnable(@NotNull String serialNumber) {
        if (serialNumber == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(3);
        }
        Runnable runnable = () -> this.mySerialToDeviceContextMap.compute(serialNumber, (unused, context) -> {
            assert (context != null);
            PerfdProxy proxy = ((DeviceContext)context).myLastKnownPerfdProxy;
            if (proxy != null) {
                proxy.disconnect();
            }
            ((DeviceContext)context).myLastKnownPerfdProxy = null;
            return context;
        });
        if (runnable == null) {
            StudioProfilerDeviceManager.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    private void disconnectProxy(IDevice device) {
        this.mySerialToDeviceContextMap.compute(device.getSerialNumber(), (serial, context) -> {
            assert (context != null);
            if (((DeviceContext)context).myLastKnowPerfdThreadfuture != null) {
                ((DeviceContext)context).myLastKnowPerfdThreadfuture.cancel(true);
                ((DeviceContext)context).myLastKnowPerfdThreadfuture = null;
            }
            ((DeviceContext)context).myExecutor.execute(this.getDisconnectRunnable((String)serial));
            return context;
        });
    }

    private void disconnectProxies() {
        this.mySerialToDeviceContextMap.forEach((serial, context) -> {
            assert (context != null);
            if (((DeviceContext)context).myLastKnowPerfdThreadfuture != null) {
                ((DeviceContext)context).myLastKnowPerfdThreadfuture.cancel(true);
                ((DeviceContext)context).myLastKnowPerfdThreadfuture = null;
            }
            ((DeviceContext)context).myExecutor.execute(this.getDisconnectRunnable((String)serial));
        });
    }

    private void spawnPerfd(IDevice device) {
        this.mySerialToDeviceContextMap.compute(device.getSerialNumber(), (serial, context) -> {
            assert (context != null && (((DeviceContext)context).myLastKnownPerfdProxy == null || ((DeviceContext)context).myLastKnownPerfdProxy.getDevice() != device));
            ((DeviceContext)context).myLastKnowPerfdThreadfuture = ((DeviceContext)context).myExecutor.submit(new PerfdThread(device, this.myDataStoreService));
            return context;
        });
    }

    private static boolean isAtLeastO(IDevice device) {
        return device.getVersion().getFeatureLevel() >= 26;
    }

    static void pushAgentConfig(IDevice device, boolean isMemoryLiveAllocationEnabledAtStartup) throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        int liveAllocationSamplingRate = ((Boolean)StudioFlags.PROFILER_SAMPLE_LIVE_ALLOCATIONS.get()).booleanValue() ? (isMemoryLiveAllocationEnabledAtStartup ? PropertiesComponent.getInstance().getInt(IntellijProfilerPreferences.getProfilerPropertyName("memory.live.allocation.mode"), MemoryProfilerStage.DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.NONE.getValue()) : MemoryProfilerStage.LiveAllocationSamplingMode.FULL.getValue();
        Agent.SocketType socketType = StudioProfilerDeviceManager.isAtLeastO(device) ? Agent.SocketType.ABSTRACT_SOCKET : Agent.SocketType.UNSPECIFIED_SOCKET;
        Agent.AgentConfig agentConfig = Agent.AgentConfig.newBuilder().setMemConfig(Agent.AgentConfig.MemoryConfig.newBuilder().setUseLiveAlloc(((Boolean)StudioFlags.PROFILER_USE_LIVE_ALLOCATIONS.get()).booleanValue()).setMaxStackDepth(LIVE_ALLOCATION_STACK_DEPTH).setTrackGlobalJniRefs(((Boolean)StudioFlags.PROFILER_TRACK_JNI_REFS.get()).booleanValue()).setSamplingRate(MemoryProfiler.AllocationSamplingRate.newBuilder().setSamplingNumInterval(liveAllocationSamplingRate).build()).build()).setSocketType(socketType).setServiceAddress("127.0.0.1:12389").setServiceSocketName("@AndroidStudioProfiler").setEnergyProfilerEnabled(((Boolean)StudioFlags.PROFILER_ENERGY_PROFILER_ENABLED.get()).booleanValue()).setCpuApiTracingEnabled(((Boolean)StudioFlags.PROFILER_CPU_API_TRACING.get()).booleanValue()).setAndroidFeatureLevel(device.getVersion().getFeatureLevel()).setCpuConfig(Agent.AgentConfig.CpuConfig.newBuilder().setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC)).build();
        File configFile = FileUtil.createTempFile((String)AGENT_CONFIG_FILE, null, (boolean)true);
        FileOutputStream oStream = new FileOutputStream(configFile);
        agentConfig.writeTo((OutputStream)oStream);
        device.executeShellCommand("rm -f /data/local/tmp/perfd/agent.config", (IShellOutputReceiver)new NullOutputReceiver());
        device.pushFile(configFile.getAbsolutePath(), "/data/local/tmp/perfd/agent.config");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStoreService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdkPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialNumber";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/StudioProfilerDeviceManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/StudioProfilerDeviceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisconnectRunnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sdkPathChanged";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDisconnectRunnable";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeviceContext {
        @NotNull
        private final ExecutorService myExecutor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        private PerfdProxy myLastKnownPerfdProxy;
        private Future<?> myLastKnowPerfdThreadfuture;

        private DeviceContext() {
        }
    }

    private static class ChmodOutputListener
    implements IShellOutputReceiver {
        private static final String BAD_MODE = "Bad mode";
        private boolean myHasErrors;

        private ChmodOutputListener() {
        }

        public void addOutput(byte[] data, int offset, int length) {
            String s = new String(data, Charsets.UTF_8);
            this.myHasErrors = s.contains(BAD_MODE);
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return false;
        }

        private boolean hasErrors() {
            return this.myHasErrors;
        }
    }

    private class PerfdThread
    implements Runnable {
        @NotNull
        private final DataStoreService myDataStore;
        @NotNull
        private final IDevice myDevice;
        private int myLocalPort;
        private volatile PerfdProxy myPerfdProxy;

        public PerfdThread(@NotNull IDevice device, DataStoreService datastore) {
            if (device == null) {
                PerfdThread.$$$reportNull$$$0(0);
            }
            if (datastore == null) {
                PerfdThread.$$$reportNull$$$0(1);
            }
            this.myDataStore = datastore;
            this.myDevice = device;
            this.myLocalPort = 0;
        }

        @Override
        public void run() {
            if (!AndroidProfilerDownloader.makeSureProfilerIsInPlace()) {
                return;
            }
            try {
                if (!this.waitForBootComplete()) {
                    throw new TimeoutException("Timed out waiting for device to be ready.");
                }
                this.copyFileToDevice("perfd", "plugins/android/resources/perfd", "../../bazel-bin/tools/base/profiler/native/perfd/android", StudioProfilerDeviceManager.DEVICE_DIR, true);
                if (StudioProfilerDeviceManager.isAtLeastO(this.myDevice)) {
                    String productionRoot = "plugins/android/resources";
                    String devRoot = "../../bazel-genfiles/tools/base/profiler/app";
                    this.copyFileToDevice("perfa.jar", productionRoot, devRoot, StudioProfilerDeviceManager.DEVICE_DIR, false);
                    this.copyFileToDevice("perfa_okhttp.dex", productionRoot, devRoot, StudioProfilerDeviceManager.DEVICE_DIR, false);
                    this.pushJvmtiAgentNativeLibraries(StudioProfilerDeviceManager.DEVICE_DIR);
                    this.pushSimpleperf(StudioProfilerDeviceManager.DEVICE_DIR);
                }
                StudioProfilerDeviceManager.pushAgentConfig(this.myDevice, true);
                this.myDevice.executeShellCommand("/data/local/tmp/perfd/perfd -config_file=/data/local/tmp/perfd/agent.config", new IShellOutputReceiver(){

                    public void addOutput(byte[] data, int offset, int length) {
                        String s = new String(data, offset, length, Charsets.UTF_8);
                        StudioProfilerDeviceManager.getLogger().info("[perfd]: " + s);
                        if (PerfdThread.this.myDevice.getVersion().getApiLevel() >= 21 && !s.startsWith("Server listening on")) {
                            return;
                        }
                        boolean[] alreadyExists = new boolean[]{false};
                        StudioProfilerDeviceManager.this.mySerialToDeviceContextMap.compute(PerfdThread.this.myDevice.getSerialNumber(), (serial, context) -> {
                            assert (context != null);
                            if (((DeviceContext)context).myLastKnownPerfdProxy != null) {
                                StudioProfilerDeviceManager.getLogger().info(String.format("PerfdProxy was already created for device: %s", PerfdThread.this.myDevice));
                                alreadyExists[0] = true;
                            }
                            return context;
                        });
                        if (alreadyExists[0]) {
                            return;
                        }
                        try {
                            PerfdThread.this.createPerfdProxy();
                            StudioProfilerDeviceManager.getLogger().info(String.format("PerfdProxy successfully created for device: %s", PerfdThread.this.myDevice));
                        }
                        catch (AdbCommandRejectedException | TimeoutException | IOException e) {
                            StudioProfilerDeviceManager.getLogger().warn(String.format("PerfdProxy failed for device: %s", PerfdThread.this.myDevice), e);
                        }
                    }

                    public void flush() {
                    }

                    public boolean isCancelled() {
                        if (Thread.interrupted()) {
                            Thread.currentThread().interrupt();
                            return true;
                        }
                        return false;
                    }
                }, 0L, null);
                StudioProfilerDeviceManager.getLogger().info("Terminating perfd thread");
            }
            catch (ShellCommandUnresponsiveException | SyncException | TimeoutException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (AdbCommandRejectedException | IOException e) {
                StudioProfilerDeviceManager.getLogger().warn("Error when trying to spawn perfd:");
                StudioProfilerDeviceManager.getLogger().warn(e);
            }
        }

        private void copyFileToDevice(String fileName, String hostReleaseDir, String hostDevDir, String deviceDir, boolean executable) throws AdbCommandRejectedException, IOException {
            File dir = this.getProfilerDir(hostReleaseDir, hostDevDir);
            File file = null;
            if (executable) {
                for (String abi : this.myDevice.getAbis()) {
                    File candidate = new File(dir, abi + "/" + fileName);
                    if (!candidate.exists()) continue;
                    file = candidate;
                    break;
                }
            } else {
                File candidate = new File(dir, fileName);
                if (candidate.exists()) {
                    file = candidate;
                }
            }
            this.pushFileToDevice(file, fileName, deviceDir, executable);
        }

        @NotNull
        private File getProfilerDir(String hostReleaseDir, String hostDevDir) {
            File dir = new File(PathManager.getHomePath(), hostReleaseDir);
            if (!dir.exists() && !(dir = new File(PathManager.getHomePath(), hostDevDir)).exists()) {
                dir = AndroidProfilerDownloader.getHostDir(hostReleaseDir);
            }
            File file = dir;
            if (file == null) {
                PerfdThread.$$$reportNull$$$0(2);
            }
            return file;
        }

        private void pushFileToDevice(File file, String fileName, String deviceDir, boolean executable) throws AdbCommandRejectedException, IOException {
            try {
                if (file == null) {
                    throw new RuntimeException(String.format("File %s could not be found for device: %s", fileName, this.myDevice));
                }
                StudioProfilerDeviceManager.getLogger().info(String.format("Pushing %s to %s...", fileName, deviceDir));
                this.myDevice.executeShellCommand("rm -f " + deviceDir + fileName, (IShellOutputReceiver)new NullOutputReceiver());
                this.myDevice.executeShellCommand("mkdir -p " + deviceDir, (IShellOutputReceiver)new NullOutputReceiver());
                this.myDevice.pushFile(file.getAbsolutePath(), deviceDir + fileName);
                if (executable) {
                    ChmodOutputListener chmodListener = new ChmodOutputListener();
                    this.myDevice.executeShellCommand("chmod +x " + deviceDir + fileName, (IShellOutputReceiver)chmodListener);
                    if (chmodListener.hasErrors()) {
                        this.myDevice.executeShellCommand("chmod 777 " + deviceDir + fileName, (IShellOutputReceiver)new NullOutputReceiver());
                    }
                }
                StudioProfilerDeviceManager.getLogger().info(String.format("Successfully pushed %s to %s.", fileName, deviceDir));
            }
            catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        }

        private void pushJvmtiAgentNativeLibraries(String devicePath) throws AdbCommandRejectedException, IOException {
            String jvmtiResourcesReleasePath = "plugins/android/resources/perfa";
            String jvmtiResourcesDevPath = "../../bazel-bin/tools/base/profiler/native/perfa/android";
            String libperfaFilename = "libperfa.so";
            String libperfaDeviceFilenameFormat = "libperfa_%s.so";
            this.pushAbiDependentBinaryFiles(devicePath, jvmtiResourcesReleasePath, jvmtiResourcesDevPath, libperfaFilename, libperfaDeviceFilenameFormat);
        }

        private void pushAbiDependentBinaryFiles(String devicePath, String hostReleaseDir, String hostDevDir, String hostFilename, String deviceFilenameFormat) throws AdbCommandRejectedException, IOException {
            File dir = this.getProfilerDir(hostReleaseDir, hostDevDir);
            HashSet<String> cpuArchSet = new HashSet<String>();
            for (String abi : this.myDevice.getAbis()) {
                String abiCpuArch;
                File candidate = new File(dir, abi + "/" + hostFilename);
                if (!candidate.exists() || cpuArchSet.contains(abiCpuArch = Abi.getEnum((String)abi).getCpuArch())) continue;
                this.pushFileToDevice(candidate, String.format(deviceFilenameFormat, abiCpuArch), devicePath, true);
                cpuArchSet.add(abiCpuArch);
            }
        }

        private void pushSimpleperf(String devicePath) throws AdbCommandRejectedException, IOException {
            String simpleperfBinariesReleasePath = "plugins/android/resources/simpleperf";
            String simpleperfBinariesDevPath = "../../prebuilts/tools/common/simpleperf";
            String simpleperfFilename = "simpleperf";
            String simpleperfDeviceFilenameFormat = "simpleperf_%s";
            this.pushAbiDependentBinaryFiles(devicePath, simpleperfBinariesReleasePath, simpleperfBinariesDevPath, simpleperfFilename, simpleperfDeviceFilenameFormat);
        }

        private void createPerfdProxy() throws TimeoutException, AdbCommandRejectedException, IOException {
            try {
                this.myLocalPort = NetUtils.findAvailableSocketPort();
                if (this.myLocalPort < 0) {
                    throw new RuntimeException("Unable to find available socket port");
                }
                if (StudioProfilerDeviceManager.isAtLeastO(this.myDevice)) {
                    this.myDevice.createForward(this.myLocalPort, StudioProfilerDeviceManager.DEVICE_SOCKET_NAME, IDevice.DeviceUnixSocketNamespace.ABSTRACT);
                } else {
                    this.myDevice.createForward(this.myLocalPort, 12389);
                }
                StudioProfilerDeviceManager.getLogger().info(String.format("Port forwarding created for port: %d", this.myLocalPort));
                ClassLoader stashedContextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(NettyChannelBuilder.class.getClassLoader());
                ManagedChannelImpl perfdChannel = NettyChannelBuilder.forAddress((String)"localhost", (int)this.myLocalPort).usePlaintext(true).maxMessageSize(0x1FFFFFFF).build();
                Thread.currentThread().setContextClassLoader(stashedContextClassLoader);
                String channelName = this.myDevice.getSerialNumber();
                this.myPerfdProxy = new PerfdProxy(this.myDevice, (ManagedChannel)perfdChannel, channelName);
                this.myPerfdProxy.connect();
                StudioProfilerDeviceManager.this.mySerialToDeviceContextMap.compute(this.myDevice.getSerialNumber(), (serial, context) -> {
                    assert (context != null);
                    ((DeviceContext)context).myLastKnownPerfdProxy = this.myPerfdProxy;
                    return context;
                });
                ManagedChannelImpl proxyChannel = InProcessChannelBuilder.forName((String)channelName).build();
                this.myDataStore.connect((ManagedChannel)proxyChannel);
            }
            catch (AdbCommandRejectedException | TimeoutException | IOException e) {
                if (this.myPerfdProxy != null) {
                    this.myPerfdProxy.disconnect();
                }
                throw e;
            }
        }

        private boolean waitForBootComplete() throws InterruptedException {
            for (int i2 = 0; i2 < 60; ++i2) {
                String state = this.myDevice.getProperty(StudioProfilerDeviceManager.BOOT_COMPLETE_PROPERTY);
                if (StudioProfilerDeviceManager.BOOT_COMPLETE_MESSAGE.equals(state)) {
                    return true;
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "datastore";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/profilers/StudioProfilerDeviceManager$PerfdThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/profilers/StudioProfilerDeviceManager$PerfdThread";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProfilerDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

