/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ResizableImage
extends JLabel {
    private static final int[] LEFT_SHADOW_ALPHAS = new int[]{25, 15, 5};
    private static final int[] RIGHT_SHADOW_ALPHAS = new int[]{40, 35, 25, 15, 5};
    private static final JBColor CHECKERBOARD_COLOR_MAIN = new JBColor(new Color(201, 201, 201), new Color(51, 54, 55));
    private static final JBColor CHECKERBOARD_COLOR_ALT = new JBColor(new Color(236, 236, 236), new Color(60, 63, 65));
    @NotNull
    private final BufferedImage myImage;
    @NotNull
    private Dimension myLastSize;
    @NotNull
    private Rectangle myViewRectangle;

    private static boolean areSimilarSizes(@NotNull Dimension d1, @NotNull Dimension d2) {
        if (d1 == null) {
            ResizableImage.$$$reportNull$$$0(0);
        }
        if (d2 == null) {
            ResizableImage.$$$reportNull$$$0(1);
        }
        return Math.abs(d2.width - d1.width) <= 1 && Math.abs(d2.height - d1.height) <= 1;
    }

    public ResizableImage(@NotNull BufferedImage image) {
        if (image == null) {
            ResizableImage.$$$reportNull$$$0(2);
        }
        super("", 0);
        this.myImage = image;
        this.myLastSize = new Dimension();
        this.myViewRectangle = new Rectangle();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ResizableImage.this.resize();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            super.setPreferredSize(new Dimension(this.myImage.getWidth(), this.myImage.getHeight()));
        }
        return super.getPreferredSize();
    }

    private boolean hasIcon() {
        Icon icon = this.getIcon();
        return icon != null && icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    private void resize() {
        this.myViewRectangle = this.getViewRectangle();
        Dimension iconSize = this.calculateScaledSize();
        if (iconSize.width == 0 || iconSize.height == 0) {
            this.setIcon(null);
            this.myLastSize = new Dimension();
        } else if (!ResizableImage.areSimilarSizes(this.myLastSize, iconSize)) {
            BufferedImage image = iconSize.getWidth() == (double)this.myImage.getWidth() ? this.myImage : this.myImage.getScaledInstance(iconSize.width, iconSize.height, 4);
            this.setIcon(new ImageIcon(image));
            this.myLastSize = iconSize;
        }
    }

    @NotNull
    private Dimension calculateScaledSize() {
        float scale;
        int width = this.getWidth() - RIGHT_SHADOW_ALPHAS.length * 2;
        int height = this.getHeight() - RIGHT_SHADOW_ALPHAS.length * 2;
        if (width <= 0 || height <= 0) {
            Dimension dimension2 = new Dimension();
            if (dimension2 == null) {
                ResizableImage.$$$reportNull$$$0(3);
            }
            return dimension2;
        }
        float sourceRatio = (float)this.myImage.getWidth() / (float)this.myImage.getHeight();
        int finalWidth = width;
        int finalHeight = (int)((float)finalWidth / sourceRatio);
        int maxWidth = Math.min(width, this.myImage.getWidth());
        int maxHeight = Math.min(height, this.myImage.getHeight());
        if (finalWidth > maxWidth) {
            scale = (float)maxWidth / (float)finalWidth;
            finalWidth = (int)((float)finalWidth * scale);
            finalHeight = (int)((float)finalHeight * scale);
        }
        if (finalHeight > maxHeight) {
            scale = (float)maxHeight / (float)finalHeight;
            finalWidth = (int)((float)finalWidth * scale);
            finalHeight = (int)((float)finalHeight * scale);
        }
        Dimension dimension3 = new Dimension(finalWidth, finalHeight);
        if (dimension3 == null) {
            ResizableImage.$$$reportNull$$$0(4);
        }
        return dimension3;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintShadow(g);
        this.paintCheckerboard(g);
        super.paintComponent(g);
    }

    private void paintCheckerboard(Graphics g) {
        Rectangle rectangle = this.hasIcon() ? this.getIconRectangle() : this.myViewRectangle;
        int squareSize = 15;
        BiConsumer<Integer, Integer> fillRect = (x, y) -> g.fillRect(rectangle.x + x * squareSize, rectangle.y + y * squareSize, Math.min(squareSize, rectangle.width - x * squareSize), Math.min(squareSize, rectangle.height - y * squareSize));
        int squareX = (int)Math.ceil(rectangle.width / squareSize);
        int squareY = (int)Math.ceil(rectangle.height / squareSize);
        for (int x2 = 0; x2 < squareX; ++x2) {
            int y2;
            g.setColor((Color)CHECKERBOARD_COLOR_MAIN);
            for (y2 = x2 % 2; y2 < squareY; y2 += 2) {
                fillRect.accept(x2, y2);
            }
            g.setColor((Color)CHECKERBOARD_COLOR_ALT);
            for (y2 = 1 - x2 % 2; y2 < squareY; y2 += 2) {
                fillRect.accept(x2, y2);
            }
        }
    }

    private void paintShadow(Graphics g) {
        int i2;
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = this.hasIcon() ? this.getIconRectangle() : this.myViewRectangle;
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        int offset = 2;
        rectangle.width -= offset;
        rectangle.height -= offset;
        for (i2 = 0; i2 < LEFT_SHADOW_ALPHAS.length; ++i2) {
            g.setColor(new Color(0, 0, 0, LEFT_SHADOW_ALPHAS[i2]));
            g.drawRoundRect(rectangle.x - i2, rectangle.y - i2, rectangle.width + i2 * 2, rectangle.height + i2 * 2, i2 * 2 + 2, i2 * 2 + 2);
        }
        rectangle.x += offset;
        rectangle.y += offset;
        for (i2 = 0; i2 < RIGHT_SHADOW_ALPHAS.length; ++i2) {
            g.setColor(new Color(0, 0, 0, RIGHT_SHADOW_ALPHAS[i2]));
            g.drawRoundRect(rectangle.x - i2, rectangle.y - i2, rectangle.width + i2 * 2, rectangle.height + i2 * 2, i2 * 2 + 2, i2 * 2 + 2);
        }
    }

    @NotNull
    private Rectangle getViewRectangle() {
        Insets insets = this.getInsets(null);
        Rectangle viewR = new Rectangle();
        viewR.x = insets.left;
        viewR.y = insets.top;
        viewR.width = this.getWidth() - (insets.left + insets.right);
        viewR.height = this.getHeight() - (insets.top + insets.bottom);
        Rectangle rectangle = viewR;
        if (rectangle == null) {
            ResizableImage.$$$reportNull$$$0(5);
        }
        return rectangle;
    }

    @NotNull
    private Rectangle getIconRectangle() {
        if (this.getIcon() == null || this.getIcon().getIconWidth() == 0 || this.getIcon().getIconHeight() == 0) {
            Rectangle rectangle = new Rectangle();
            if (rectangle == null) {
                ResizableImage.$$$reportNull$$$0(6);
            }
            return rectangle;
        }
        Rectangle iconR = new Rectangle();
        SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(new Font(null, 0, 10)), this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getViewRectangle(), iconR, new Rectangle(), this.getIconTextGap());
        Rectangle rectangle = iconR;
        if (rectangle == null) {
            ResizableImage.$$$reportNull$$$0(7);
        }
        return rectangle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/ResizableImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/ResizableImage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateScaledSize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewRectangle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconRectangle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areSimilarSizes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

