/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.AndroidProfilerToolWindow;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.run.ExecutorIconProvider;
import com.android.tools.idea.run.LaunchOptionsProvider;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableMap;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfileRunExecutor
extends DefaultRunExecutor
implements ExecutorIconProvider,
LaunchOptionsProvider {
    public static final String PROFILER_LAUNCH_OPTION_KEY = "isProfiling";
    @NonNls
    public static final String EXECUTOR_ID = "Android Profiler";

    @NotNull
    public Icon getIcon() {
        Icon icon = StudioIcons.Shell.Toolbar.PROFILER;
        if (icon == null) {
            ProfileRunExecutor.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public Icon getDisabledIcon() {
        return StudioIcons.Shell.ToolWindows.ANDROID_PROFILER;
    }

    public String getDescription() {
        return "Profile selected configuration";
    }

    @NotNull
    public String getActionName() {
        if ("Profile" == null) {
            ProfileRunExecutor.$$$reportNull$$$0(1);
        }
        return "Profile";
    }

    @NotNull
    public String getId() {
        if (EXECUTOR_ID == null) {
            ProfileRunExecutor.$$$reportNull$$$0(2);
        }
        return EXECUTOR_ID;
    }

    @NotNull
    public String getStartActionText() {
        if ("Profile" == null) {
            ProfileRunExecutor.$$$reportNull$$$0(3);
        }
        return "Profile";
    }

    public String getContextActionId() {
        return "ProfileRunClass";
    }

    public String getHelpId() {
        return null;
    }

    public static Executor getProfileExecutorInstance() {
        return ExecutorRegistry.getInstance().getExecutorById(EXECUTOR_ID);
    }

    @Override
    @Nullable
    public Icon getExecutorIcon(@NotNull Project project, @NotNull Executor executor) {
        Common.Session profilingSession;
        StudioProfilers profilers;
        AndroidProfilerToolWindow profilerToolWindow;
        if (project == null) {
            ProfileRunExecutor.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            ProfileRunExecutor.$$$reportNull$$$0(5);
        }
        if ((profilerToolWindow = AndroidProfilerToolWindowFactory.getProfilerToolWindow(project)) != null && (profilers = profilerToolWindow.getProfilers()) != null && SessionsManager.isSessionAlive((Common.Session)(profilingSession = profilers.getSessionsManager().getProfilingSession()))) {
            return ExecutionUtil.getLiveIndicator((Icon)this.getIcon());
        }
        return this.getIcon();
    }

    @Override
    @NotNull
    public Map<String, Object> getLaunchOptions() {
        ImmutableMap immutableMap = ImmutableMap.of((Object)PROFILER_LAUNCH_OPTION_KEY, (Object)true);
        if (immutableMap == null) {
            ProfileRunExecutor.$$$reportNull$$$0(6);
        }
        return immutableMap;
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            ProfileRunExecutor.$$$reportNull$$$0(7);
        }
        return AndroidUtils.hasAndroidFacets(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/ProfileRunExecutor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartActionText";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/ProfileRunExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExecutorIcon";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

