/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.actions.NavigateToCodeAction;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.intellij.ide.actions.CopyAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class IntellijContextMenuInstaller
implements ContextMenuInstaller {
    private static final String COMPONENT_CONTEXT_MENU = "ComponentContextMenu";
    private int myCachedX = -1;

    public void installGenericContextMenu(final @NotNull JComponent component, final @NotNull ContextMenuItem contextMenuItem, final @NotNull IntPredicate itemEnabled, final @NotNull IntConsumer callback) {
        if (component == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(0);
        }
        if (contextMenuItem == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(1);
        }
        if (itemEnabled == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(3);
        }
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component);
        if (contextMenuItem.equals(ContextMenuItem.SEPARATOR)) {
            popupGroup.addSeparator();
            return;
        }
        if (contextMenuItem.equals(ContextMenuItem.COPY)) {
            popupGroup.add((AnAction)new CopyAction(){
                {
                    this.getTemplatePresentation().setText(contextMenuItem.getText());
                    this.getTemplatePresentation().setIcon(contextMenuItem.getIcon());
                    this.registerCustomShortcutSet(CommonShortcuts.getCopy(), component);
                }
            });
            return;
        }
        AnAction action2 = new AnAction(){

            public void update(AnActionEvent e) {
                Presentation presentation = e.getPresentation();
                presentation.setText(contextMenuItem.getText());
                presentation.setIcon(contextMenuItem.getIcon());
                presentation.setEnabled(itemEnabled.test(IntellijContextMenuInstaller.this.myCachedX));
            }

            public void actionPerformed(AnActionEvent e) {
                callback.accept(IntellijContextMenuInstaller.this.myCachedX);
            }
        };
        action2.registerCustomShortcutSet(new ShortcutSet(){

            @NotNull
            public Shortcut[] getShortcuts() {
                Shortcut[] shortcutArray = (Shortcut[])Arrays.stream(contextMenuItem.getKeyStrokes()).filter(keyStroke -> keyStroke != null).map(keyStroke -> new KeyboardShortcut(keyStroke, null)).toArray(Shortcut[]::new);
                if (shortcutArray == null) {
                    3.$$$reportNull$$$0(0);
                }
                return shortcutArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profilers/IntellijContextMenuInstaller$3", "getShortcuts"));
            }
        }, component);
        popupGroup.add(action2);
    }

    public void installNavigationContextMenu(@NotNull JComponent component, @NotNull CodeNavigator navigator, @NotNull Supplier<CodeLocation> codeLocationSupplier) {
        if (component == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(4);
        }
        if (navigator == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(5);
        }
        if (codeLocationSupplier == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(6);
        }
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component);
        popupGroup.add((AnAction)new NavigateToCodeAction(codeLocationSupplier, navigator));
    }

    @NotNull
    private DefaultActionGroup createOrGetActionGroup(@NotNull JComponent component) {
        DefaultActionGroup actionGroup;
        if (component == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(7);
        }
        if ((actionGroup = (DefaultActionGroup)component.getClientProperty(COMPONENT_CONTEXT_MENU)) == null) {
            final DefaultActionGroup newActionGroup = new DefaultActionGroup();
            component.putClientProperty(COMPONENT_CONTEXT_MENU, newActionGroup);
            component.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    IntellijContextMenuInstaller.this.myCachedX = x;
                    ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)newActionGroup).getComponent().show(comp, x, y);
                }
            });
            actionGroup = newActionGroup;
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            IntellijContextMenuInstaller.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextMenuItem";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemEnabled";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeLocationSupplier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/IntellijContextMenuInstaller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/IntellijContextMenuInstaller";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installGenericContextMenu";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installNavigationContextMenu";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOrGetActionGroup";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

