/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.ddmlib.IDevice;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.profilers.AndroidProfilerToolWindowFactory;
import com.android.tools.idea.profilers.IntellijProfilerComponents;
import com.android.tools.idea.profilers.IntellijProfilerServices;
import com.android.tools.idea.profilers.ProfilerService;
import com.android.tools.idea.profilers.perfd.ProfilerServiceProxy;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.Notification;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.sessions.SessionAspect;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import icons.StudioIcons;
import icons.StudioIllustrations;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.File;
import java.util.function.Predicate;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProfilerToolWindow
implements Disposable {
    static final Key<PreferredProcessInfo> LAST_RUN_APP_INFO = Key.create((String)"Profiler.Last.Run.App");
    private static final String HIDE_STOP_PROMPT = "profilers.hide.stop.prompt";
    @NotNull
    private static final Notification OPEN_FILE_FAILURE_NOTIFICATION = new Notification.Builder("Failed to open file", "The profiler was unable to open the selected file. Please try opening it again or select a different file.").setSeverity(Notification.Severity.ERROR).build();
    private static final String NO_CLIENT_TITLE = "Initialization failed";
    private static final String NO_CLIENT_MESSAGE = "To start the profiler, close all other Android Studio projects.";
    @NotNull
    private final JPanel myPanel;
    @Nullable
    private StudioProfilersWrapper myProfilersWrapper;
    @NotNull
    private final ToolWindow myWindow;
    @NotNull
    private final Project myProject;

    public AndroidProfilerToolWindow(@NotNull ToolWindow window, @NotNull Project project) {
        if (window == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(1);
        }
        this.myWindow = window;
        this.myProject = project;
        this.myPanel = new JPanel(new BorderLayout());
        if (!this.tryInitializeProfilers()) {
            this.myPanel.add(this.buildInitializationFailedUi());
        }
    }

    private boolean tryInitializeProfilers() {
        if (this.myProfilersWrapper != null) {
            return true;
        }
        ProfilerService service = ProfilerService.getInstance(this.myProject);
        if (service == null) {
            return false;
        }
        this.myProfilersWrapper = new StudioProfilersWrapper(this.myProject, this.myWindow, service);
        Disposer.register((Disposable)this, (Disposable)this.myProfilersWrapper);
        this.myPanel.removeAll();
        this.myPanel.add(this.myProfilersWrapper.getProfilersView().getComponent());
        this.myPanel.revalidate();
        this.myPanel.repaint();
        return true;
    }

    @NotNull
    private JComponent buildInitializationFailedUi() {
        JPanel panel2 = new JPanel();
        BoxLayout layout2 = new BoxLayout(panel2, 1);
        panel2.setLayout(layout2);
        panel2.add(Box.createVerticalGlue());
        panel2.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        JLabel icon = new JLabel(StudioIllustrations.Common.DISCONNECT_PROFILER);
        icon.setHorizontalAlignment(0);
        icon.setAlignmentX(0.5f);
        panel2.add(icon);
        JLabel title = new JLabel(NO_CLIENT_TITLE);
        title.setHorizontalAlignment(0);
        title.setAlignmentX(0.5f);
        title.setFont(ProfilerFonts.H1_FONT);
        title.setForeground(ProfilerColors.MESSAGE_COLOR);
        panel2.add(title);
        panel2.add(Box.createRigidArea(new Dimension(1, 15)));
        JLabel message = new JLabel(NO_CLIENT_MESSAGE);
        message.setHorizontalAlignment(0);
        message.setAlignmentX(0.5f);
        message.setFont(ProfilerFonts.STANDARD_FONT);
        message.setForeground(ProfilerColors.MESSAGE_COLOR);
        panel2.add(message);
        panel2.add(Box.createVerticalGlue());
        JPanel jPanel = panel2;
        if (jPanel == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    StudioProfilers getProfilers() {
        return this.myProfilersWrapper != null ? this.myProfilersWrapper.getProfilers() : null;
    }

    public void profile(@NotNull PreferredProcessInfo processInfo) {
        if (processInfo == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(3);
        }
        if (this.tryInitializeProfilers()) {
            StudioProfilers profilers = this.myProfilersWrapper.getProfilers();
            profilers.setPreferredProcess(processInfo.deviceName, processInfo.processName, processInfo.processFilter);
        }
    }

    void disableAutoProfiling() {
        if (this.tryInitializeProfilers()) {
            StudioProfilers profilers = this.myProfilersWrapper.getProfilers();
            profilers.setAutoProfilingEnabled(false);
        }
    }

    public void openFile(@NotNull VirtualFile file) {
        StudioProfilers profilers;
        if (file == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(4);
        }
        if (this.tryInitializeProfilers() && !(profilers = this.myProfilersWrapper.getProfilers()).getSessionsManager().importSessionFromFile(new File(file.getPath()))) {
            profilers.getIdeServices().showNotification(OPEN_FILE_FAILURE_NOTIFICATION);
        }
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @Nullable
    private static String getPreferredProcessName(@NotNull Project project) {
        if (project == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(6);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            String moduleName = AndroidProfilerToolWindow.getModuleName(module);
            if (moduleName == null) continue;
            return moduleName;
        }
        return null;
    }

    @Nullable
    static String getModuleName(@NotNull Module module) {
        String pkg;
        AndroidModuleInfo moduleInfo;
        if (module == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(7);
        }
        if ((moduleInfo = AndroidModuleInfo.getInstance(module)) != null && (pkg = moduleInfo.getPackage()) != null) {
            return pkg;
        }
        return null;
    }

    @NotNull
    static String getDeviceDisplayName(@NotNull IDevice device) {
        if (device == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(8);
        }
        StringBuilder deviceNameBuilder = new StringBuilder();
        String manufacturer = ProfilerServiceProxy.getDeviceManufacturer(device);
        String model = ProfilerServiceProxy.getDeviceModel(device);
        String serial = device.getSerialNumber();
        String suffix = String.format("-%s", serial);
        if (model.endsWith(suffix)) {
            model = model.substring(0, model.length() - suffix.length());
        }
        if (!StringUtil.isEmpty((String)manufacturer)) {
            deviceNameBuilder.append(manufacturer);
            deviceNameBuilder.append(" ");
        }
        deviceNameBuilder.append(model);
        String string = deviceNameBuilder.toString();
        if (string == null) {
            AndroidProfilerToolWindow.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/AndroidProfilerToolWindow";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerToolWindow";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInitializationFailedUi";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "profile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredProcessName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PreferredProcessInfo {
        @NotNull
        private final String deviceName;
        @NotNull
        private final String processName;
        @NotNull
        private final Predicate<Common.Process> processFilter;

        PreferredProcessInfo(@NotNull String deviceName, @NotNull String processName, @NotNull Predicate<Common.Process> processFilter) {
            if (deviceName == null) {
                PreferredProcessInfo.$$$reportNull$$$0(0);
            }
            if (processName == null) {
                PreferredProcessInfo.$$$reportNull$$$0(1);
            }
            if (processFilter == null) {
                PreferredProcessInfo.$$$reportNull$$$0(2);
            }
            this.deviceName = deviceName;
            this.processName = processName;
            this.processFilter = processFilter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deviceName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processFilter";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/profilers/AndroidProfilerToolWindow$PreferredProcessInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AndroidProfilerWindowManagerListener
    implements ToolWindowManagerListener {
        private boolean myIsProfilingActiveBalloonShown;
        private boolean myWasWindowExpanded;
        @NotNull
        private final Project myProject;
        @NotNull
        private final StudioProfilers myProfilers;
        @NotNull
        private final StudioProfilersView myProfilersView;

        AndroidProfilerWindowManagerListener(@NotNull Project project, @NotNull StudioProfilers profilers, @NotNull StudioProfilersView view) {
            if (project == null) {
                AndroidProfilerWindowManagerListener.$$$reportNull$$$0(0);
            }
            if (profilers == null) {
                AndroidProfilerWindowManagerListener.$$$reportNull$$$0(1);
            }
            if (view == null) {
                AndroidProfilerWindowManagerListener.$$$reportNull$$$0(2);
            }
            this.myIsProfilingActiveBalloonShown = false;
            this.myWasWindowExpanded = false;
            this.myProject = project;
            this.myProfilers = profilers;
            this.myProfilersView = view;
        }

        public void stateChanged() {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Android Profiler");
            if (window == null) {
                return;
            }
            boolean hasAliveSession = SessionsManager.isSessionAlive((Common.Session)this.myProfilers.getSessionsManager().getProfilingSession());
            boolean isWindowTabHidden = !window.isShowStripeButton();
            boolean isWindowExpanded = window.isVisible();
            boolean windowVisibilityChanged = isWindowExpanded != this.myWasWindowExpanded;
            this.myWasWindowExpanded = isWindowExpanded;
            if (isWindowTabHidden) {
                if (hasAliveSession) {
                    boolean confirm;
                    boolean hidePrompt = this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().getBoolean(AndroidProfilerToolWindow.HIDE_STOP_PROMPT, false);
                    boolean bl = confirm = hidePrompt || this.myProfilersView.getIdeProfilerComponents().createUiMessageHandler().displayOkCancelMessage("Confirm Stop Profiling", "Hiding the window will stop the current profiling session. Are you sure?", "Yes", "Cancel", null, result2 -> this.myProfilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(AndroidProfilerToolWindow.HIDE_STOP_PROMPT, result2.booleanValue()));
                    if (!confirm) {
                        window.setShowStripeButton(true);
                        return;
                    }
                }
                this.myProfilers.stop();
                return;
            }
            if (isWindowExpanded) {
                PreferredProcessInfo processInfo;
                this.myIsProfilingActiveBalloonShown = false;
                if (windowVisibilityChanged && (processInfo = (PreferredProcessInfo)this.myProject.getUserData(LAST_RUN_APP_INFO)) != null && Common.Session.getDefaultInstance().equals((Object)this.myProfilers.getSession())) {
                    this.myProfilers.setPreferredProcess(processInfo.deviceName, processInfo.processName, processInfo.processFilter);
                }
            } else {
                this.myProfilers.setAutoProfilingEnabled(false);
                if (hasAliveSession && !this.myIsProfilingActiveBalloonShown) {
                    this.myIsProfilingActiveBalloonShown = true;
                    String messageHtml = "A profiler session is running in the background.<br>" + (this.myProfilers.getIdeServices().getFeatureConfig().isSessionsEnabled() ? "To end the session, open the profiler and click the stop button in the Sessions pane." : "To end the session, open the profiler and click the \"End Session\" button");
                    ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon("Android Profiler", MessageType.INFO, messageHtml);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "profilers";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/profilers/AndroidProfilerToolWindow$AndroidProfilerWindowManagerListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StudioProfilersWrapper
    extends AspectObserver
    implements Disposable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final ToolWindow myWindow;
        @NotNull
        private final StudioProfilers myProfilers;
        @NotNull
        private final StudioProfilersView myView;

        StudioProfilersWrapper(@NotNull Project project, @NotNull ToolWindow window, @NotNull ProfilerService service) {
            if (project == null) {
                StudioProfilersWrapper.$$$reportNull$$$0(0);
            }
            if (window == null) {
                StudioProfilersWrapper.$$$reportNull$$$0(1);
            }
            if (service == null) {
                StudioProfilersWrapper.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myWindow = window;
            IntellijProfilerServices ideProfilerServices = new IntellijProfilerServices(this.myProject);
            service.getDataStoreService().setNoPiiExceptionHanlder(arg_0 -> ((IdeProfilerServices)ideProfilerServices).reportNoPiiException(arg_0));
            ProfilerClient client = service.getProfilerClient();
            this.myProfilers = new StudioProfilers(client, (IdeProfilerServices)ideProfilerServices);
            this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.MODE, this::modeChanged).onChange((Enum)ProfilerAspect.STAGE, this::stageChanged);
            this.myProfilers.getSessionsManager().addDependency((AspectObserver)this).onChange((Enum)SessionAspect.SELECTED_SESSION, this::selectedSessionChanged).onChange((Enum)SessionAspect.PROFILING_SESSION, this::profilingSessionChanged);
            PreferredProcessInfo processInfo = (PreferredProcessInfo)this.myProject.getUserData(LAST_RUN_APP_INFO);
            if (processInfo != null) {
                this.myProfilers.setPreferredProcess(processInfo.deviceName, processInfo.processName, processInfo.processFilter);
                this.myProject.putUserData(LAST_RUN_APP_INFO, null);
            } else {
                StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> this.myProfilers.setPreferredProcessName(AndroidProfilerToolWindow.getPreferredProcessName(this.myProject)));
            }
            IntellijProfilerComponents profilerComponents = new IntellijProfilerComponents(this.myProject, this.myProfilers.getIdeServices().getFeatureTracker());
            this.myView = new StudioProfilersView(this.myProfilers, (IdeProfilerComponents)profilerComponents);
            Disposer.register((Disposable)this, (Disposable)this.myView);
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)new AndroidProfilerWindowManagerListener(this.myProject, this.myProfilers, this.myView));
        }

        public void dispose() {
            this.myProfilers.stop();
        }

        @NotNull
        private StudioProfilers getProfilers() {
            StudioProfilers studioProfilers = this.myProfilers;
            if (studioProfilers == null) {
                StudioProfilersWrapper.$$$reportNull$$$0(3);
            }
            return studioProfilers;
        }

        @NotNull
        private StudioProfilersView getProfilersView() {
            StudioProfilersView studioProfilersView = this.myView;
            if (studioProfilersView == null) {
                StudioProfilersWrapper.$$$reportNull$$$0(4);
            }
            return studioProfilersView;
        }

        private void modeChanged() {
            boolean maximize;
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)this.myProject);
            boolean bl = maximize = this.myProfilers.getMode() == ProfilerMode.EXPANDED;
            if (maximize != manager.isMaximized(this.myWindow)) {
                manager.setMaximized(this.myWindow, maximize);
            }
        }

        private void stageChanged() {
            if (this.myProfilers.isStopped()) {
                AndroidProfilerToolWindowFactory.removeContent(this.myWindow);
            }
        }

        private void selectedSessionChanged() {
            Common.SessionMetaData metaData = this.myProfilers.getSessionsManager().getSelectedSessionMetaData();
            this.myWindow.setTitle(metaData.getSessionName());
        }

        private void profilingSessionChanged() {
            Common.Session profilingSession = this.myProfilers.getSessionsManager().getProfilingSession();
            if (SessionsManager.isSessionAlive((Common.Session)profilingSession)) {
                this.myWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)StudioIcons.Shell.ToolWindows.ANDROID_PROFILER));
            } else {
                this.myWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PROFILER);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/profilers/AndroidProfilerToolWindow$StudioProfilersWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/profilers/AndroidProfilerToolWindow$StudioProfilersWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProfilers";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProfilersView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

