/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.ui;

import com.android.tools.idea.observable.core.ObjectProperty;
import com.intellij.util.ArrayUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JRadioButton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B/\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0006\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ)\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0001\u0010\u00012\u0006\u0010\u0004\u001a\u0002H\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0018R\u0018\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/observable/ui/SelectedRadioButtonProperty;", "T", "Lcom/android/tools/idea/observable/core/ObjectProperty;", "Ljava/awt/event/ItemListener;", "selected", "values", "", "radioButtons", "Ljavax/swing/JRadioButton;", "(Ljava/lang/Object;[Ljava/lang/Object;[Ljavax/swing/JRadioButton;)V", "myRadioButtons", "[Ljavax/swing/JRadioButton;", "[Ljava/lang/Object;", "get", "()Ljava/lang/Object;", "getSelectedIndex", "", "(Ljava/lang/Object;[Ljava/lang/Object;)I", "itemStateChanged", "", "event", "Ljava/awt/event/ItemEvent;", "setDirectly", "value", "(Ljava/lang/Object;)V", "intellij.android.observable.ui"})
public final class SelectedRadioButtonProperty<T>
extends ObjectProperty<T>
implements ItemListener {
    private final JRadioButton[] myRadioButtons;
    private final T[] values;

    @Override
    public void itemStateChanged(@NotNull ItemEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getStateChange() == 1) {
            this.notifyInvalidated();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T get() {
        int n = 0;
        int n2 = this.myRadioButtons.length;
        while (n < n2) {
            void i2;
            if (this.myRadioButtons[i2].isSelected()) {
                return this.values[i2];
            }
            ++i2;
        }
        throw (Throwable)new IllegalStateException("No radio button is selected");
    }

    @Override
    protected void setDirectly(T value2) {
        int selectedIndex = this.getSelectedIndex(value2, this.values);
        this.myRadioButtons[selectedIndex].setSelected(true);
    }

    private final <T> int getSelectedIndex(T selected, T[] values2) {
        int selectedIndex = ArrayUtil.find((Object[])values2, selected);
        if (selectedIndex < 0) {
            throw (Throwable)new IllegalArgumentException("Invalid selected value (" + selected + ')');
        }
        return selectedIndex;
    }

    public SelectedRadioButtonProperty(T selected, @NotNull T[] values2, JRadioButton ... radioButtons) {
        Intrinsics.checkParameterIsNotNull(values2, (String)"values");
        Intrinsics.checkParameterIsNotNull((Object)radioButtons, (String)"radioButtons");
        this.values = values2;
        int selectedIndex = this.getSelectedIndex(selected, this.values);
        if (this.values.length != radioButtons.length) {
            String msg = "The number of values (" + this.values.length + ") doesn't match the number of radio buttons (" + radioButtons.length + ')';
            throw (Throwable)new IllegalArgumentException(msg);
        }
        radioButtons[selectedIndex].setSelected(true);
        this.myRadioButtons = radioButtons;
        for (JRadioButton radioButton : radioButtons) {
            radioButton.addItemListener(this);
        }
    }
}

