/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.observable.adapters;

import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.adapters.AdapterProperty;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringToDoubleAdapterProperty
extends AdapterProperty<String, Double> {
    @NotNull
    private final DecimalFormat myFormat;

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty) {
        if (wrappedProperty == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(0);
        }
        this(wrappedProperty, 1);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals) {
        if (wrappedProperty == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(1);
        }
        this(wrappedProperty, numDecimals, numDecimals);
    }

    public StringToDoubleAdapterProperty(@NotNull AbstractProperty<String> wrappedProperty, int numDecimals, int maxDecimals) {
        if (wrappedProperty == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(2);
        }
        super(wrappedProperty, 0.0);
        if (maxDecimals < numDecimals) {
            throw new IllegalArgumentException("maxDecimals must be larger or equal to numDecimals");
        }
        this.myFormat = new DecimalFormat("0." + Strings.repeat((String)"0", (int)numDecimals) + Strings.repeat((String)"#", (int)(maxDecimals - numDecimals)), new DecimalFormatSymbols());
    }

    @Override
    @Nullable
    protected Double convertFromSourceType(@NotNull String value2) {
        if (value2 == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(3);
        }
        try {
            ParsePosition pos = new ParsePosition(0);
            Number number = this.myFormat.parse(value2, pos);
            if (number != null && pos.getIndex() == value2.length()) {
                return number.doubleValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Override
    @NotNull
    protected String convertFromDestType(@NotNull Double value2) {
        if (value2 == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(4);
        }
        String string = this.myFormat.format(value2);
        if (string == null) {
            StringToDoubleAdapterProperty.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappedProperty";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/observable/adapters/StringToDoubleAdapterProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/observable/adapters/StringToDoubleAdapterProperty";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFromDestType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertFromSourceType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertFromDestType";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

