/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.NewProjectModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.FormFactorSdkControls;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.components.LanguageComboProvider;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ImageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidProjectStep
extends ModelWizardStep<NewProjectModuleModel> {
    private final NewProjectModel myProjectModel;
    private final ValidatorPanel myValidatorPanel;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    private final List<UpdatablePackage> myInstallRequests;
    private final List<RemotePackage> myInstallLicenseRequests;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myProjectLocation;
    private JTextField myAppName;
    private JTextField myPackageName;
    private JComboBox<Language> myProjectLanguage;
    private JCheckBox myInstantAppCheck;
    private JCheckBox myWearCheck;
    private JCheckBox myTvCheck;
    private JCheckBox myOfflineRepoCheck;
    private JLabel myTemplateIconTitle;
    private JLabel myTemplateIconDetail;
    private JPanel myFormFactorSdkControlsPanel;
    private JCheckBox myUseAndroidxCheck;
    private FormFactorSdkControls myFormFactorSdkControls;

    public ConfigureAndroidProjectStep(@NotNull NewProjectModuleModel newProjectModuleModel, @NotNull NewProjectModel projectModel) {
        if (newProjectModuleModel == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(0);
        }
        if (projectModel == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(1);
        }
        super(newProjectModuleModel, AndroidBundle.message("android.wizard.project.new.configure", new Object[0]));
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myInstallRequests = new ArrayList<UpdatablePackage>();
        this.myInstallLicenseRequests = new ArrayList<RemotePackage>();
        this.myProjectModel = projectModel;
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)StudioWizardStepPanel.wrappedWithVScroll(this.myPanel));
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        LicenseAgreementStep licenseAgreementStep = new LicenseAgreementStep(new LicenseAgreementModel(AndroidVersionsInfo.getSdkManagerLocalPath()), this.myInstallLicenseRequests);
        InstallSelectedPackagesStep installPackagesStep = new InstallSelectedPackagesStep(this.myInstallRequests, new HashSet<LocalPackage>(), AndroidSdks.getInstance().tryToChooseSdkHandler(), false);
        ArrayList arrayList = Lists.newArrayList((Object[])new ModelWizardStep[]{licenseAgreementStep, installPackagesStep});
        if (arrayList == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(3);
        }
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), this.myProjectModel.applicationName());
        StringValueProperty companyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(false));
        String basePackage = new DomainToPackageExpression(companyDomain, new StringValueProperty("")).get();
        Expression<String> computedPackageName = this.myProjectModel.applicationName().transform(appName -> String.format("%s.%s", basePackage, NewProjectModel.toPackagePart(appName)));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(this.myProjectModel.packageName(), packageNameText);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myListeners.receive(packageNameText, value2 -> isPackageNameSynced.set(value2.equals(computedPackageName.get())));
        Expression<String> computedLocation = this.myProjectModel.applicationName().transform(ConfigureAndroidProjectStep::findProjectLocation);
        TextProperty locationText = new TextProperty(this.myProjectLocation.getTextField());
        BoolValueProperty isLocationSynced = new BoolValueProperty(true);
        this.myBindings.bind(locationText, computedLocation, isLocationSynced);
        this.myBindings.bind(this.myProjectModel.projectLocation(), locationText);
        this.myListeners.receive(locationText, value2 -> isLocationSynced.set(value2.equals(computedLocation.get())));
        OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo = ((NewProjectModuleModel)this.getModel()).androidSdkInfo();
        this.myFormFactorSdkControls.init(androidSdkInfo, this);
        if (((Boolean)StudioFlags.UAB_NEW_PROJECT_INSTANT_APP_IS_DYNAMIC_APP.get()).booleanValue()) {
            this.myBindings.bindTwoWay(((NewProjectModuleModel)this.getModel()).dynamicInstantApp(), new SelectedProperty(this.myInstantAppCheck));
        } else {
            this.myBindings.bindTwoWay(((NewProjectModuleModel)this.getModel()).instantApp(), new SelectedProperty(this.myInstantAppCheck));
        }
        this.myBindings.bindTwoWay(this.myProjectModel.useAndroidx(), new SelectedProperty(this.myUseAndroidxCheck));
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.applicationName(), value2 -> {
            if (value2.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.application.name", new Object[0]));
            }
            if (!Character.isUpperCase(value2.charAt(0))) {
                return new Validator.Result(Validator.Severity.INFO, AndroidBundle.message("android.wizard.validate.lowercase.application.name", new Object[0]));
            }
            return Validator.Result.OK;
        });
        Expression<File> locationFile = this.myProjectModel.projectLocation().transform(File::new);
        this.myValidatorPanel.registerValidator(locationFile, (Validator)PathValidator.createDefault("project location"));
        this.myValidatorPanel.registerValidator((ObservableValue)this.myProjectModel.packageName(), value2 -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value2)));
        this.myValidatorPanel.registerValidator(androidSdkInfo, value2 -> value2.isPresent() ? Validator.Result.OK : new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("select.target.dialog.text", new Object[0])));
        this.myProjectLocation.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myProjectLanguage.setSelectedItem((Object)((Boolean)this.myProjectModel.enableKotlinSupport().get() != false ? Language.KOTLIN : Language.JAVA));
        this.myListeners.listenAll(((NewProjectModuleModel)this.getModel()).formFactor(), this.myProjectModel.enableCppSupport()).withAndFire(() -> {
            FormFactor formFactor = (FormFactor)((Object)((Object)((NewProjectModuleModel)this.getModel()).formFactor().get()));
            boolean isCppTemplate = (Boolean)this.myProjectModel.enableCppSupport().get();
            this.myInstantAppCheck.setVisible(formFactor == FormFactor.MOBILE && !isCppTemplate);
            this.myFormFactorSdkControls.showStatsPanel(formFactor == FormFactor.MOBILE);
            this.myWearCheck.setVisible(formFactor == FormFactor.WEAR);
            this.myTvCheck.setVisible(formFactor == FormFactor.TV);
            this.myOfflineRepoCheck.setVisible((Boolean)StudioFlags.NPW_OFFLINE_REPO_CHECKBOX.get());
            this.myUseAndroidxCheck.setVisible((Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get() != false && this.myProjectModel.isAndroidxAvailable());
        });
        this.myListeners.listenAndFire(androidSdkInfo, sender -> {
            boolean isAndroidxOnly;
            AndroidVersionsInfo.VersionItem androidVersion = (AndroidVersionsInfo.VersionItem)androidSdkInfo.getValueOrNull();
            boolean bl = isAndroidxOnly = androidVersion != null && androidVersion.getTargetApiLevel() >= 29;
            if (isAndroidxOnly) {
                this.myUseAndroidxCheck.setSelected(true);
                this.myUseAndroidxCheck.setEnabled(false);
            } else {
                this.myUseAndroidxCheck.setEnabled(true);
            }
        });
    }

    @Override
    protected void onEntering() {
        FormFactor formFactor = (FormFactor)((Object)((NewProjectModuleModel)this.getModel()).formFactor().get());
        TemplateHandle templateHandle = ((NewProjectModuleModel)this.getModel()).renderTemplateHandle().getValueOrNull();
        int minSdk = templateHandle == null ? formFactor.getMinOfflineApiLevel() : templateHandle.getMetadata().getMinSdk();
        this.myFormFactorSdkControls.startDataLoading(formFactor, minSdk);
        this.setTemplateThumbnail(templateHandle);
    }

    @Override
    protected void onProceeding() {
        this.myProjectModel.enableKotlinSupport().set(this.myProjectLanguage.getSelectedItem() == Language.KOTLIN);
        ((NewProjectModuleModel)this.getModel()).hasCompanionApp().set(this.myWearCheck.isVisible() && this.myWearCheck.isSelected() || this.myTvCheck.isVisible() && this.myTvCheck.isSelected() || ((NewProjectModuleModel)this.getModel()).formFactor().get() == FormFactor.CAR);
        this.myProjectModel.useOfflineRepo().set(this.myOfflineRepoCheck.isVisible() && this.myOfflineRepoCheck.isSelected());
        this.myInstallRequests.clear();
        this.myInstallLicenseRequests.clear();
        this.myInstallRequests.addAll(this.myFormFactorSdkControls.getSdkInstallPackageList());
        this.myInstallLicenseRequests.addAll(this.myInstallRequests.stream().map(UpdatablePackage::getRemote).collect(Collectors.toList()));
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(4);
        }
        return validatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(5);
        }
        return observableBool;
    }

    @NotNull
    private static String findProjectLocation(@NotNull String applicationName) {
        if (applicationName == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(6);
        }
        applicationName = NewProjectModel.sanitizeApplicationName(applicationName);
        File baseDirectory = WizardUtils.getProjectLocationParent();
        File projectDirectory = new File(baseDirectory, applicationName);
        int counter = 2;
        while (projectDirectory.exists()) {
            projectDirectory = new File(baseDirectory, String.format("%s%d", applicationName, counter++));
        }
        String string = projectDirectory.getPath();
        if (string == null) {
            ConfigureAndroidProjectStep.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void setTemplateThumbnail(@Nullable TemplateHandle templateHandle) {
        boolean isCppTemplate = (Boolean)this.myProjectModel.enableCppSupport().get();
        Image image = ActivityGallery.getTemplateImage(templateHandle, isCppTemplate);
        if (image != null) {
            BufferedImage buffImg = ImageUtil.toBufferedImage((Image)image);
            Rectangle imageExtents = ImageUtils.getCropBounds((BufferedImage)buffImg, (img, x, y) -> (img.getRGB(x, y) & 0xFF000000) == 0, null);
            if (imageExtents != null) {
                buffImg = buffImg.getSubimage(imageExtents.x, 0, imageExtents.width, buffImg.getHeight());
            }
            ImageIcon icon = new ImageIcon(buffImg.getScaledInstance(256 * buffImg.getWidth() / buffImg.getHeight(), 256, 4));
            this.myTemplateIconTitle.setIcon(icon);
            this.myTemplateIconTitle.setText(ActivityGallery.getTemplateImageLabel(templateHandle, isCppTemplate));
            this.myTemplateIconDetail.setText("<html>" + ActivityGallery.getTemplateDescription(templateHandle, isCppTemplate) + "</html>");
        }
        this.myTemplateIconTitle.setVisible(image != null);
        this.myTemplateIconDetail.setVisible(image != null);
    }

    private void createUIComponents() {
        this.myProjectLanguage = new LanguageComboProvider().createComponent();
        this.myFormFactorSdkControls = new FormFactorSdkControls();
        this.myFormFactorSdkControlsPanel = this.myFormFactorSdkControls.getRoot();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProjectModuleModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/project/ConfigureAndroidProjectStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findProjectLocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JLabel jLabel;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(20, 3, new Insets(0, 5, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        Font font = this.$$$getFont$$$(null, 0, -1, jLabel3.getFont());
        if (font != null) {
            jLabel3.setFont(font);
        }
        jLabel3.setText("Name");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jLabel3.setVerticalAlignment(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 2, 8, 0, 0, 0, null, new Dimension(-1, 24), null));
        JLabel jLabel4 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 0, -1, jLabel4.getFont());
        if (font2 != null) {
            jLabel4.setFont(font2);
        }
        jLabel4.setText("Package name");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(0);
        jLabel4.setVerticalAlignment(0);
        jPanel.add((Component)jLabel4, new GridConstraints(3, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        Font font3 = this.$$$getFont$$$(null, 0, -1, jLabel5.getFont());
        if (font3 != null) {
            jLabel5.setFont(font3);
        }
        jLabel5.setText("Language");
        jLabel5.setDisplayedMnemonic('L');
        jLabel5.setDisplayedMnemonicIndex(0);
        jLabel5.setVerticalAlignment(0);
        jPanel.add((Component)jLabel5, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppName = jTextField2 = new JTextField();
        jTextField2.setToolTipText("The name that will be shown in the Android launcher for this application");
        jPanel.add((Component)jTextField2, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        Font font4 = this.$$$getFont$$$(null, 0, -1, jLabel6.getFont());
        if (font4 != null) {
            jLabel6.setFont(font4);
        }
        jLabel6.setText("Save location");
        jLabel6.setDisplayedMnemonic('S');
        jLabel6.setDisplayedMnemonicIndex(0);
        jLabel6.setVerticalAlignment(0);
        jPanel.add((Component)jLabel6, new GridConstraints(6, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myProjectLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(7, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JComboBox<Language> jComboBox = this.myProjectLanguage;
        jPanel.add(jComboBox, new GridConstraints(10, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel.add((Component)jSeparator, new GridConstraints(11, 1, 1, 1, 0, 1, 6, 0, new Dimension(-1, 1), new Dimension(-1, 24), new Dimension(-1, 1)));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(8, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 19, 1, 0, 3, 3, 3, null, new Dimension(250, -1), new Dimension(250, -1)));
        this.myTemplateIconTitle = jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setHorizontalTextPosition(0);
        jLabel2.setText("Template Label");
        jLabel2.setVerticalTextPosition(3);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 6, 6, null, null, null));
        this.myTemplateIconDetail = jLabel = new JLabel();
        jLabel.setHorizontalAlignment(0);
        jLabel.setText("Detail");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 7, null, null, null));
        JPanel jPanel3 = this.myFormFactorSdkControlsPanel;
        jPanel.add((Component)jPanel3, new GridConstraints(12, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(18, 1, 2, 1, 0, 2, 1, 6, null, null, null));
        this.myInstantAppCheck = jCheckBox5 = new JCheckBox();
        Font font5 = this.$$$getFont$$$(null, 0, -1, jCheckBox5.getFont());
        if (font5 != null) {
            jCheckBox5.setFont(font5);
        }
        jCheckBox5.setLabel("This project will support instant apps");
        jCheckBox5.setText("This project will support instant apps");
        jPanel.add((Component)jCheckBox5, new GridConstraints(13, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWearCheck = jCheckBox4 = new JCheckBox();
        Font font6 = this.$$$getFont$$$(null, 0, -1, jCheckBox4.getFont());
        if (font6 != null) {
            jCheckBox4.setFont(font6);
        }
        jCheckBox4.setLabel("Pair with Empty Phone app");
        jCheckBox4.setText("Pair with Empty Phone app");
        jPanel.add((Component)jCheckBox4, new GridConstraints(14, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTvCheck = jCheckBox3 = new JCheckBox();
        Font font7 = this.$$$getFont$$$(null, 0, -1, jCheckBox3.getFont());
        if (font7 != null) {
            jCheckBox3.setFont(font7);
        }
        jCheckBox3.setLabel("Pair with companion Phone app");
        jCheckBox3.setText("Pair with companion Phone app");
        jPanel.add((Component)jCheckBox3, new GridConstraints(15, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOfflineRepoCheck = jCheckBox2 = new JCheckBox();
        Font font8 = this.$$$getFont$$$(null, 0, -1, jCheckBox2.getFont());
        if (font8 != null) {
            jCheckBox2.setFont(font8);
        }
        jCheckBox2.setLabel("Use offline repo");
        jCheckBox2.setSelected(true);
        jCheckBox2.setText("Use offline repo");
        jPanel.add((Component)jCheckBox2, new GridConstraints(16, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myUseAndroidxCheck = jCheckBox = new JCheckBox();
        Font font9 = this.$$$getFont$$$(null, 0, -1, jCheckBox.getFont());
        if (font9 != null) {
            jCheckBox.setFont(font9);
        }
        jCheckBox.setLabel("Use AndroidX artifacts");
        jCheckBox.setSelected(false);
        jCheckBox.setText("Use AndroidX artifacts");
        jPanel.add((Component)jCheckBox, new GridConstraints(17, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel3.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
        jLabel5.setLabelFor(jComboBox);
        jLabel6.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

