/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.stdui.CommonTabbedPane;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.cpp.ConfigureCppSupportStep;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.model.NewProjectModuleModel;
import com.android.tools.idea.npw.model.RenderTemplateModel;
import com.android.tools.idea.npw.project.ChooseAndroidProjectPanel;
import com.android.tools.idea.npw.project.ConfigureAndroidProjectStep;
import com.android.tools.idea.npw.template.ConfigureTemplateParametersStep;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.npw.ui.WizardGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseAndroidProjectStep
extends ModelWizardStep<NewProjectModel> {
    private final String[] ORDERED_ACTIVITY_NAMES;
    private final List<FormFactorInfo> myFormFactors;
    private JPanel myRootPanel;
    private CommonTabbedPane myTabsPanel;
    private NewProjectModuleModel myNewProjectModuleModel;

    public ChooseAndroidProjectStep(@NotNull NewProjectModel model) {
        if (model == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(0);
        }
        super(model, AndroidBundle.message("android.wizard.project.new.choose", new Object[0]));
        this.ORDERED_ACTIVITY_NAMES = new String[]{"Basic Activity", "Empty Activity", "Bottom Navigation Activity", "Fullscreen Activity", "Master/Detail Flow", "Navigation Drawer Activity", "Google Maps Activity", "Login Activity", "Scrolling Activity", "Tabbed Activity"};
        this.$$$setupUI$$$();
        this.myFormFactors = new ArrayList<FormFactorInfo>();
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        this.myNewProjectModuleModel = new NewProjectModuleModel((NewProjectModel)this.getModel());
        RenderTemplateModel renderModel = this.myNewProjectModuleModel.getExtraRenderTemplateModel();
        ArrayList arrayList = Lists.newArrayList((Object[])new ModelWizardStep[]{new ConfigureAndroidProjectStep(this.myNewProjectModuleModel, (NewProjectModel)this.getModel()), new ConfigureCppSupportStep((NewProjectModel)this.getModel()), new ConfigureTemplateParametersStep(renderModel, AndroidBundle.message("android.wizard.config.activity.title", new Object[0]), Lists.newArrayList())});
        if (arrayList == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(2);
        }
        this.populateFormFactors();
        for (FormFactorInfo formFactorInfo : this.myFormFactors) {
            ChooseAndroidProjectPanel<TemplateRenderer> tabPanel = formFactorInfo.tabPanel;
            this.myTabsPanel.addTab(formFactorInfo.formFactor.toString(), (Component)tabPanel.myRootPanel);
            tabPanel.myGallery.setDefaultAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    wizard.goForward();
                }
            });
            ListSelectionListener activitySelectedListener = selectionEvent -> {
                TemplateRenderer selectedTemplate = (TemplateRenderer)tabPanel.myGallery.getSelectedElement();
                if (selectedTemplate != null) {
                    tabPanel.myTemplateName.setText(selectedTemplate.getImageLabel());
                    tabPanel.myTemplateDesc.setText("<html>" + selectedTemplate.getTemplateDescription() + "</html>");
                    tabPanel.myDocumentationLink.setVisible(selectedTemplate.isCppTemplate());
                }
            };
            tabPanel.myGallery.addListSelectionListener(activitySelectedListener);
            activitySelectedListener.valueChanged(null);
        }
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    protected void onProceeding() {
        FormFactorInfo formFactorInfo = this.myFormFactors.get(this.myTabsPanel.getSelectedIndex());
        TemplateRenderer selectedTemplate = (TemplateRenderer)formFactorInfo.tabPanel.myGallery.getSelectedElement();
        ((NewProjectModel)this.getModel()).enableCppSupport().set(selectedTemplate.isCppTemplate());
        this.myNewProjectModuleModel.formFactor().set(formFactorInfo.formFactor);
        this.myNewProjectModuleModel.moduleTemplateFile().setNullableValue(formFactorInfo.templateFile);
        this.myNewProjectModuleModel.renderTemplateHandle().setNullableValue(selectedTemplate.getTemplate());
        TemplateHandle extraStepTemplateHandle = formFactorInfo.formFactor == FormFactor.THINGS ? selectedTemplate.getTemplate() : null;
        this.myNewProjectModuleModel.getExtraRenderTemplateModel().setTemplateHandle(extraStepTemplateHandle);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected JComponent getPreferredFocusComponent() {
        CommonTabbedPane commonTabbedPane = this.myTabsPanel;
        if (commonTabbedPane == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(4);
        }
        return commonTabbedPane;
    }

    private void populateFormFactors() {
        TreeMap formFactorInfoMap = Maps.newTreeMap();
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        for (File templateFile : applicationTemplates) {
            FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactor.get(metadata.getFormFactor())) == FormFactor.GLASS && !AndroidSdkUtils.isGlassInstalled()) continue;
            FormFactorInfo prevFormFactorInfo = (FormFactorInfo)formFactorInfoMap.get((Object)formFactor);
            int templateMinSdk = metadata.getMinSdk();
            if (prevFormFactorInfo == null) {
                int minSdk = Math.max(templateMinSdk, formFactor.getMinOfflineApiLevel());
                ChooseAndroidProjectPanel<TemplateRenderer> tabPanel = new ChooseAndroidProjectPanel<TemplateRenderer>(this.createGallery(this.getTitle(), formFactor));
                formFactorInfoMap.put(formFactor, new FormFactorInfo(templateFile, formFactor, minSdk, tabPanel));
                continue;
            }
            if (templateMinSdk <= prevFormFactorInfo.minSdk) continue;
            prevFormFactorInfo.minSdk = templateMinSdk;
            prevFormFactorInfo.templateFile = templateFile;
        }
        this.myFormFactors.addAll(formFactorInfoMap.values());
        this.myFormFactors.sort(Comparator.comparing(f -> f.formFactor));
    }

    @NotNull
    private List<TemplateHandle> getFilteredTemplateHandles(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(5);
        }
        List<TemplateHandle> templateHandles = TemplateManager.getInstance().getTemplateList(formFactor);
        if (formFactor == FormFactor.MOBILE) {
            Map<String, TemplateHandle> entryMap = templateHandles.stream().collect(Collectors.toMap(it -> it.getMetadata().getTitle(), it -> it));
            List<TemplateHandle> list = Arrays.stream(this.ORDERED_ACTIVITY_NAMES).map(it -> (TemplateHandle)entryMap.get(it)).filter(Objects::nonNull).collect(Collectors.toList());
            if (list == null) {
                ChooseAndroidProjectStep.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<TemplateHandle> list = templateHandles;
        if (list == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private ASGallery<TemplateRenderer> createGallery(@NotNull String title, @NotNull FormFactor formFactor) {
        if (title == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(8);
        }
        if (formFactor == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(9);
        }
        List<TemplateHandle> templateHandles = this.getFilteredTemplateHandles(formFactor);
        ArrayList templateRenderers = Lists.newArrayListWithExpectedSize((int)(templateHandles.size() + 2));
        templateRenderers.add(new TemplateRenderer(null, false));
        for (TemplateHandle templateHandle : templateHandles) {
            templateRenderers.add(new TemplateRenderer(templateHandle, false));
        }
        if (formFactor == FormFactor.MOBILE) {
            templateRenderers.add(new TemplateRenderer(null, true));
        }
        TemplateRenderer[] listItems = templateRenderers.toArray(new TemplateRenderer[0]);
        WizardGallery<TemplateRenderer> gallery = new WizardGallery<TemplateRenderer>(title, TemplateRenderer::getImage, TemplateRenderer::getImageLabel);
        gallery.setModel(JBList.createDefaultListModel((Object[])listItems));
        gallery.setSelectedIndex(ChooseAndroidProjectStep.getDefaultSelectedTemplateIndex(listItems));
        WizardGallery<TemplateRenderer> wizardGallery = gallery;
        if (wizardGallery == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(10);
        }
        return wizardGallery;
    }

    private static int getDefaultSelectedTemplateIndex(@NotNull TemplateRenderer[] templateRenderers) {
        int i2;
        if (templateRenderers == null) {
            ChooseAndroidProjectStep.$$$reportNull$$$0(11);
        }
        for (i2 = 0; i2 < templateRenderers.length; ++i2) {
            if (!templateRenderers[i2].getImageLabel().equals("Empty Activity")) continue;
            return i2;
        }
        for (i2 = 0; i2 < templateRenderers.length; ++i2) {
            if (templateRenderers[i2].getTemplate() == null) continue;
            return i2;
        }
        assert (false) : "No valid Template found";
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/project/ChooseAndroidProjectStep";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRenderers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/project/ChooseAndroidProjectStep";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredTemplateHandles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGallery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredTemplateHandles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGallery";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSelectedTemplateIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        CommonTabbedPane commonTabbedPane;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTabsPanel = commonTabbedPane = new CommonTabbedPane();
        jPanel.add((Component)commonTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class TemplateRenderer {
        @Nullable
        private final TemplateHandle myTemplate;
        private final boolean myIsCppTemplate;

        TemplateRenderer(@Nullable TemplateHandle template, boolean isCppTemplate) {
            this.myTemplate = template;
            this.myIsCppTemplate = isCppTemplate;
        }

        @Nullable
        TemplateHandle getTemplate() {
            return this.myTemplate;
        }

        boolean isCppTemplate() {
            return this.myIsCppTemplate;
        }

        @NotNull
        String getImageLabel() {
            String string = ActivityGallery.getTemplateImageLabel(this.myTemplate, this.isCppTemplate());
            if (string == null) {
                TemplateRenderer.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        String getTemplateDescription() {
            String string = ActivityGallery.getTemplateDescription(this.myTemplate, this.isCppTemplate());
            if (string == null) {
                TemplateRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String toString() {
            String string = this.getImageLabel();
            if (string == null) {
                TemplateRenderer.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        Image getImage() {
            return ActivityGallery.getTemplateImage(this.myTemplate, this.isCppTemplate());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/npw/project/ChooseAndroidProjectStep$TemplateRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImageLabel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class FormFactorInfo {
        @NotNull
        final FormFactor formFactor;
        @NotNull
        final ChooseAndroidProjectPanel<TemplateRenderer> tabPanel;
        @NotNull
        File templateFile;
        int minSdk;

        FormFactorInfo(@NotNull File templateFile, @NotNull FormFactor formFactor, int minSdk, @NotNull ChooseAndroidProjectPanel<TemplateRenderer> tabPanel) {
            if (templateFile == null) {
                FormFactorInfo.$$$reportNull$$$0(0);
            }
            if (formFactor == null) {
                FormFactorInfo.$$$reportNull$$$0(1);
            }
            if (tabPanel == null) {
                FormFactorInfo.$$$reportNull$$$0(2);
            }
            this.templateFile = templateFile;
            this.formFactor = formFactor;
            this.minSdk = minSdk;
            this.tabPanel = tabPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "templateFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "formFactor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tabPanel";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/project/ChooseAndroidProjectStep$FormFactorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

