/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidPackageUtils {
    private AndroidPackageUtils() {
    }

    @NotNull
    public static String getPackageForApplication(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            AndroidPackageUtils.$$$reportNull$$$0(0);
        }
        AndroidModel androidModel = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel();
        assert (androidModel != null);
        String string = androidModel.getApplicationId();
        if (string == null) {
            AndroidPackageUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidFacet androidFacet, @NotNull List<NamedModuleTemplate> moduleTemplates, @NotNull VirtualFile targetDirectory) {
        if (androidFacet == null) {
            AndroidPackageUtils.$$$reportNull$$$0(2);
        }
        if (moduleTemplates == null) {
            AndroidPackageUtils.$$$reportNull$$$0(3);
        }
        if (targetDirectory == null) {
            AndroidPackageUtils.$$$reportNull$$$0(4);
        }
        if (!moduleTemplates.isEmpty()) {
            Module module = androidFacet.getModule();
            File srcDirectory = moduleTemplates.get(0).getPaths().getSrcDirectory(null);
            if (srcDirectory != null) {
                ProjectRootManager projectManager;
                String suggestedPackage;
                Path srcPath = Paths.get(srcDirectory.getPath(), new String[0]).toAbsolutePath();
                Path targetPath = Paths.get(targetDirectory.getPath(), new String[0]).toAbsolutePath();
                if (targetPath.startsWith(srcPath) && (suggestedPackage = (projectManager = ProjectRootManager.getInstance((Project)module.getProject())).getFileIndex().getPackageNameByDirectory(targetDirectory)) != null && !suggestedPackage.isEmpty()) {
                    String string = suggestedPackage;
                    if (string == null) {
                        AndroidPackageUtils.$$$reportNull$$$0(5);
                    }
                    return string;
                }
            }
        }
        String string = AndroidPackageUtils.getPackageForApplication(androidFacet);
        if (string == null) {
            AndroidPackageUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static List<NamedModuleTemplate> getModuleTemplates(@NotNull AndroidFacet facet, @Nullable VirtualFile targetDirectory) {
        if (facet == null) {
            AndroidPackageUtils.$$$reportNull$$$0(7);
        }
        List<NamedModuleTemplate> list = ProjectSystemUtil.getModuleSystem(facet.getModule()).getModuleTemplates(targetDirectory);
        if (list == null) {
            AndroidPackageUtils.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/project/AndroidPackageUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTemplates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/project/AndroidPackageUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageForApplication";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageForPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackageForApplication";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackageForPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleTemplates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

