/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.platform;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.gradle.npw.project.GradleBuildSettings;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidVersionsInfo {
    private static final ProgressIndicator REPO_LOG = new StudioLoggerProgressIndicator(AndroidVersionsInfo.class);
    private static final IdDisplay NO_MATCH = IdDisplay.create((String)"no_match", (String)"No Match");
    private final List<VersionItem> myTargetVersions = Lists.newArrayList();
    private final Set<AndroidVersion> myInstalledVersions = Sets.newHashSet();
    private IAndroidTarget myHighestInstalledApiTarget;

    public void load() {
        this.loadTargetVersions();
        this.loadInstalledVersions();
    }

    private void loadInstalledVersions() {
        this.myInstalledVersions.clear();
        IAndroidTarget highestInstalledTarget = null;
        for (IAndroidTarget target : AndroidVersionsInfo.getCompilationTargets()) {
            if (target.isPlatform() && target.getVersion().getFeatureLevel() >= 22 && (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview())) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myInstalledVersions.add(target.getVersion());
        }
        this.myHighestInstalledApiTarget = highestInstalledTarget;
    }

    @Nullable(value="If we don't know (yet) the highest installed version")
    AndroidVersion getHighestInstalledVersion() {
        return this.myHighestInstalledApiTarget == null ? null : this.myHighestInstalledApiTarget.getVersion();
    }

    @Nullable
    public static File getSdkManagerLocalPath() {
        return IdeSdks.getInstance().getAndroidSdkPath();
    }

    @NotNull
    public List<UpdatablePackage> loadInstallPackageList(@NotNull List<VersionItem> installItems) {
        RepositoryPackages packages;
        if (installItems == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(0);
        }
        HashSet requestedPaths = Sets.newHashSet();
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        GradleCoordinate constraintCoordinate = GradleCoordinate.parseCoordinateString((String)"com.android.support.constraint:constraint-layout:+");
        RepoPackage constraintPackage = SdkMavenRepository.findBestPackageMatching((GradleCoordinate)constraintCoordinate, (packages = sdkHandler.getSdkManager(REPO_LOG).getPackages()).getLocalPackages().values());
        if (constraintPackage == null && (constraintPackage = SdkMavenRepository.findBestPackageMatching((GradleCoordinate)constraintCoordinate, packages.getRemotePackages().values())) != null) {
            requestedPaths.add(constraintPackage.getPath());
        }
        requestedPaths.add(DetailsTypes.getBuildToolsPath((Revision)GradleBuildSettings.getRecommendedBuildToolsRevision(sdkHandler, REPO_LOG)));
        for (VersionItem versionItem : installItems) {
            AndroidVersion androidVersion = versionItem.myAndroidVersion;
            String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)androidVersion);
            if (versionItem.myAddon != null) {
                requestedPaths.add(versionItem.myAddon.getPath());
                AndroidTargetManager targetManager = sdkHandler.getAndroidTargetManager(REPO_LOG);
                if (targetManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion), REPO_LOG) != null) continue;
                requestedPaths.add(platformPath);
                continue;
            }
            if (this.myHighestInstalledApiTarget != null && (androidVersion.getApiLevel() <= this.myHighestInstalledApiTarget.getVersion().getApiLevel() || this.myInstalledVersions.contains(androidVersion))) continue;
            requestedPaths.add(DetailsTypes.getPlatformPath((AndroidVersion)new AndroidVersion(27, null)));
        }
        List<UpdatablePackage> list = AndroidVersionsInfo.getPackageList(requestedPaths, sdkHandler);
        if (list == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void loadTargetVersions(@NotNull FormFactor formFactor, int minSdkLevel, ItemsLoaded itemsLoadedCallback) {
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(2);
        }
        ArrayList<VersionItem> versionItemList = new ArrayList<VersionItem>();
        for (VersionItem target : this.myTargetVersions) {
            if (!AndroidVersionsInfo.isFormFactorAvailable(formFactor, minSdkLevel, target.getMinApiLevel()) && (target.getAndroidTarget() == null || !target.getAndroidTarget().getVersion().isPreview())) continue;
            versionItemList.add(target);
        }
        this.loadRemoteTargets(formFactor, minSdkLevel, versionItemList, itemsLoadedCallback);
    }

    private void loadTargetVersions() {
        this.myTargetVersions.clear();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i2 = 0; i2 < knownVersions.length; ++i2) {
                this.myTargetVersions.add(new VersionItem(this, knownVersions[i2], i2 + 1));
            }
        }
        for (IAndroidTarget target : AndroidVersionsInfo.getCompilationTargets()) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            this.myTargetVersions.add(new VersionItem(this, target));
        }
    }

    @NotNull
    private static IAndroidTarget[] getCompilationTargets() {
        AndroidTargetManager targetManager = AndroidSdks.getInstance().tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
        ArrayList result2 = Lists.newArrayList();
        for (IAndroidTarget target : targetManager.getTargets(REPO_LOG)) {
            if (!target.isPlatform() && target.getAdditionalLibraries().isEmpty()) continue;
            result2.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = result2.toArray(new IAndroidTarget[0]);
        if (iAndroidTargetArray == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(3);
        }
        return iAndroidTargetArray;
    }

    private void loadRemoteTargets(@NotNull FormFactor myFormFactor, int minSdkLevel, @NotNull List<VersionItem> versionItemList, ItemsLoaded completedCallback) {
        if (myFormFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(4);
        }
        if (versionItemList == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(5);
        }
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Runnable runCallbacks = () -> {
            if (completedCallback != null) {
                completedCallback.onDataLoadedFinished(versionItemList);
            }
        };
        RepoManager.RepoLoadedCallback onComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> {
            this.addPackages(myFormFactor, versionItemList, packages.getNewPkgs(), minSdkLevel);
            this.addOfflineLevels(myFormFactor, versionItemList);
            runCallbacks.run();
        }, ModalityState.any());
        RepoManager.RepoLoadedCallback onLocalComplete = packages -> ApplicationManager.getApplication().invokeLater(() -> this.addPackages(myFormFactor, versionItemList, packages.getLocalPackages().values(), minSdkLevel), ModalityState.any());
        Runnable onError = () -> ApplicationManager.getApplication().invokeLater(() -> {
            this.addOfflineLevels(myFormFactor, versionItemList);
            runCallbacks.run();
        }, ModalityState.any());
        StudioProgressRunner runner = new StudioProgressRunner(false, false, "Refreshing Targets", null);
        sdkHandler.getSdkManager(REPO_LOG).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)onLocalComplete), (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    @NotNull
    private static List<UpdatablePackage> getPackageList(@NotNull Collection<String> requestedPaths, @NotNull AndroidSdkHandler sdkHandler) {
        if (requestedPaths == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(6);
        }
        if (sdkHandler == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(7);
        }
        ArrayList<UpdatablePackage> requestedPackages = new ArrayList<UpdatablePackage>();
        RepositoryPackages packages = sdkHandler.getSdkManager(REPO_LOG).getPackages();
        Map consolidated = packages.getConsolidatedPkgs();
        for (String path : requestedPaths) {
            UpdatablePackage p = (UpdatablePackage)consolidated.get(path);
            if (p == null || !p.hasRemote()) continue;
            requestedPackages.add(p);
        }
        ArrayList<UpdatablePackage> resolvedPackages = new ArrayList();
        try {
            resolvedPackages = SdkQuickfixUtils.resolve(requestedPackages, packages);
        }
        catch (SdkQuickfixUtils.PackageResolutionException e) {
            REPO_LOG.logError("Error Resolving Packages", (Throwable)e);
        }
        ArrayList<UpdatablePackage> arrayList = resolvedPackages;
        if (arrayList == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean filterPkgDesc(@NotNull RepoPackage p, @NotNull FormFactor formFactor, int minSdkLevel) {
        if (p == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(9);
        }
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(10);
        }
        return AndroidVersionsInfo.isApiType(p) && AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, AndroidVersionsInfo.getTag(p), AndroidVersionsInfo.getFeatureLevel(p));
    }

    private static boolean doFilter(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable IdDisplay tag, int targetSdkLevel) {
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(11);
        }
        return formFactor.isSupported(tag, targetSdkLevel) && targetSdkLevel >= minSdkLevel;
    }

    private static boolean isApiType(@NotNull RepoPackage repoPackage) {
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(12);
        }
        return repoPackage.getTypeDetails() instanceof DetailsTypes.ApiDetailsType;
    }

    private static int getFeatureLevel(@NotNull RepoPackage repoPackage) {
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(13);
        }
        return AndroidVersionsInfo.getAndroidVersion(repoPackage).getFeatureLevel();
    }

    private static boolean isFormFactorAvailable(@NotNull FormFactor formFactor, int minSdkLevel, int targetSdkLevel) {
        if (formFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(14);
        }
        return AndroidVersionsInfo.doFilter(formFactor, minSdkLevel, SystemImage.DEFAULT_TAG, targetSdkLevel);
    }

    @NotNull
    private static AndroidVersion getAndroidVersion(@NotNull RepoPackage repoPackage) {
        TypeDetails details;
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(15);
        }
        if ((details = repoPackage.getTypeDetails()) instanceof DetailsTypes.ApiDetailsType) {
            AndroidVersion androidVersion = ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
            if (androidVersion == null) {
                AndroidVersionsInfo.$$$reportNull$$$0(16);
            }
            return androidVersion;
        }
        throw new RuntimeException("Could not determine version");
    }

    @Nullable
    private static IdDisplay getTag(@NotNull RepoPackage repoPackage) {
        DetailsTypes.SysImgDetailsType imgDetailsType;
        if (repoPackage == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(17);
        }
        TypeDetails details = repoPackage.getTypeDetails();
        IdDisplay tag = NO_MATCH;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            tag = ((DetailsTypes.AddonDetailsType)details).getTag();
        }
        if (details instanceof DetailsTypes.SysImgDetailsType && (imgDetailsType = (DetailsTypes.SysImgDetailsType)details).getAbi().equals("x86")) {
            tag = imgDetailsType.getTag();
        }
        return tag;
    }

    private void addPackages(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList, @NotNull Collection<? extends RepoPackage> packages, int minSdkLevel) {
        if (myFormFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(18);
        }
        if (versionItemList == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(19);
        }
        if (packages == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(20);
        }
        List sorted = packages.stream().filter(repoPackage -> repoPackage != null && AndroidVersionsInfo.filterPkgDesc(repoPackage, myFormFactor, minSdkLevel)).collect(Collectors.toList());
        sorted.sort(Comparator.comparing(AndroidVersionsInfo::getAndroidVersion));
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (RepoPackage info : sorted) {
            int apiLevel = AndroidVersionsInfo.getFeatureLevel(info);
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myMinApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(this, info));
            prevInsertedApiLevel = apiLevel;
        }
    }

    private void addOfflineLevels(@NotNull FormFactor myFormFactor, @NotNull List<VersionItem> versionItemList) {
        if (myFormFactor == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(21);
        }
        if (versionItemList == null) {
            AndroidVersionsInfo.$$$reportNull$$$0(22);
        }
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (int apiLevel = myFormFactor.getMinOfflineApiLevel(); apiLevel <= myFormFactor.getMaxOfflineApiLevel(); ++apiLevel) {
            if (myFormFactor.isSupported(null, apiLevel) || apiLevel <= 0) continue;
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < versionItemList.size() ? versionItemList.get(index).myMinApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            versionItemList.add(index++, new VersionItem(this, apiLevel));
            prevInsertedApiLevel = apiLevel;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installItems";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo";
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 4: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myFormFactor";
                break;
            }
            case 5: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionItemList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedPaths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoPackage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInstallPackageList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilationTargets";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadInstallPackageList";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadTargetVersions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadRemoteTargets";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPackageList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterPkgDesc";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doFilter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApiType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureLevel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFormFactorAvailable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidVersion";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addPackages";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addOfflineLevels";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class VersionItem {
        private final AndroidVersion myAndroidVersion;
        private final String myLabel;
        private final int myMinApiLevel;
        private final String myMinApiLevelStr;
        private IAndroidTarget myAndroidTarget;
        private RemotePackage myAddon;
        final /* synthetic */ AndroidVersionsInfo this$0;

        VersionItem(@NotNull AndroidVersionsInfo this$0, @NotNull AndroidVersion androidVersion, @Nullable IdDisplay tag, IAndroidTarget target) {
            if (androidVersion == null) {
                VersionItem.$$$reportNull$$$0(0);
            }
            if (tag == null) {
                VersionItem.$$$reportNull$$$0(1);
            }
            this.this$0 = this$0;
            this.myAndroidVersion = androidVersion;
            this.myLabel = this.getLabel(androidVersion, tag, target);
            this.myAndroidTarget = target;
            this.myMinApiLevel = androidVersion.getFeatureLevel();
            this.myMinApiLevelStr = androidVersion.getApiString();
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, String label, int minApiLevel) {
            if (label == null) {
                VersionItem.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            this.myAndroidVersion = new AndroidVersion(minApiLevel, null);
            this.myLabel = label;
            this.myMinApiLevel = minApiLevel;
            this.myMinApiLevelStr = Integer.toString(minApiLevel);
        }

        VersionItem(AndroidVersionsInfo this$0, int minApiLevel) {
            this(this$0, new AndroidVersion(minApiLevel, null), SystemImage.DEFAULT_TAG, null);
        }

        public VersionItem(@NotNull AndroidVersionsInfo this$0, IAndroidTarget target) {
            if (target == null) {
                VersionItem.$$$reportNull$$$0(3);
            }
            this(this$0, target.getVersion(), SystemImage.DEFAULT_TAG, target);
        }

        VersionItem(@NotNull AndroidVersionsInfo this$0, RepoPackage info) {
            if (info == null) {
                VersionItem.$$$reportNull$$$0(4);
            }
            this(this$0, AndroidVersionsInfo.getAndroidVersion(info), AndroidVersionsInfo.getTag(info), null);
            if (info instanceof RemotePackage && SystemImage.GLASS_TAG.equals((Object)AndroidVersionsInfo.getTag(info))) {
                this.myAddon = (RemotePackage)info;
            }
        }

        @Nullable(value="null except for preview releases")
        public IAndroidTarget getAndroidTarget() {
            return this.myAndroidTarget;
        }

        @Nullable(value="null except when an addon needs to be installed (eg Google Glass)")
        public RemotePackage getAddon() {
            return this.myAddon;
        }

        public int getMinApiLevel() {
            return this.myMinApiLevel;
        }

        @NotNull
        public String getMinApiLevelStr() {
            String string = this.myMinApiLevelStr;
            if (string == null) {
                VersionItem.$$$reportNull$$$0(5);
            }
            return string;
        }

        public int getBuildApiLevel() {
            int apiLevel = this.myAddon != null || this.myAndroidTarget != null && (this.myAndroidTarget.getVersion().isPreview() || !this.myAndroidTarget.isPlatform()) ? this.myMinApiLevel : (this.this$0.getHighestInstalledVersion() != null && this.this$0.getHighestInstalledVersion().getFeatureLevel() > 27 ? this.this$0.getHighestInstalledVersion().getFeatureLevel() : 27);
            return apiLevel;
        }

        @NotNull
        public String getBuildApiLevelStr() {
            if (this.myAndroidTarget == null) {
                String string = Integer.toString(this.getBuildApiLevel());
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (this.myAndroidTarget.isPlatform()) {
                String string = TemplateMetadata.getBuildApiString(this.myAndroidTarget.getVersion());
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = AndroidTargetHash.getTargetHashString((IAndroidTarget)this.myAndroidTarget);
            if (string == null) {
                VersionItem.$$$reportNull$$$0(8);
            }
            return string;
        }

        public int getTargetApiLevel() {
            return this.getBuildApiLevel();
        }

        @NotNull
        public String getTargetApiLevelStr() {
            int buildApiLevel = this.getBuildApiLevel();
            if (buildApiLevel >= 28 || this.myAndroidTarget != null && this.myAndroidTarget.getVersion().isPreview()) {
                String string = this.myAndroidTarget == null ? Integer.toString(buildApiLevel) : this.myAndroidTarget.getVersion().getApiString();
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(9);
                }
                return string;
            }
            AndroidVersion installedVersion = this.this$0.getHighestInstalledVersion();
            if (installedVersion != null && installedVersion.getFeatureLevel() == buildApiLevel) {
                String string = installedVersion.getApiString();
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(10);
                }
                return string;
            }
            String string = Integer.toString(buildApiLevel);
            if (string == null) {
                VersionItem.$$$reportNull$$$0(11);
            }
            return string;
        }

        @NotNull
        public String getLabel() {
            String string = this.myLabel;
            if (string == null) {
                VersionItem.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        private String getLabel(@NotNull AndroidVersion version2, @Nullable IdDisplay tag, @Nullable IAndroidTarget target) {
            if (version2 == null) {
                VersionItem.$$$reportNull$$$0(13);
            }
            int featureLevel = version2.getFeatureLevel();
            if (SystemImage.GLASS_TAG.equals((Object)tag)) {
                String string = String.format("Glass Development Kit Preview (API %1$d)", featureLevel);
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(14);
                }
                return string;
            }
            if (featureLevel <= 28) {
                if (version2.isPreview()) {
                    String string = String.format("API %1$s: Android %2$s (%3$s preview)", SdkVersionInfo.getCodeName((int)featureLevel), SdkVersionInfo.getVersionString((int)featureLevel), SdkVersionInfo.getCodeName((int)featureLevel));
                    if (string == null) {
                        VersionItem.$$$reportNull$$$0(15);
                    }
                    return string;
                }
                if (target == null || target.isPlatform()) {
                    String string = SdkVersionInfo.getAndroidName((int)featureLevel);
                    if (string == null) {
                        VersionItem.$$$reportNull$$$0(16);
                    }
                    return string;
                }
                if (!StringUtil.isEmptyOrSpaces((String)target.getDescription())) {
                    String string = String.format("API %1$d: %2$s", featureLevel, target.getDescription());
                    if (string == null) {
                        VersionItem.$$$reportNull$$$0(17);
                    }
                    return string;
                }
                String string = AndroidTargetHash.getTargetHashString((IAndroidTarget)target);
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(18);
                }
                return string;
            }
            if (version2.isPreview()) {
                String string = String.format("API %1$d: Android (%2$s)", featureLevel, version2.getCodename());
                if (string == null) {
                    VersionItem.$$$reportNull$$$0(19);
                }
                return string;
            }
            String string = String.format("API %1$d: Android", featureLevel);
            if (string == null) {
                VersionItem.$$$reportNull$$$0(20);
            }
            return string;
        }

        public String toString() {
            return this.myLabel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidVersion";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/platform/AndroidVersionsInfo$VersionItem";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMinApiLevelStr";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildApiLevelStr";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetApiLevelStr";
                    break;
                }
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "getLabel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ItemsLoaded {
        public void onDataLoadedFinished(List<VersionItem> var1);
    }
}

