/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.repository.io.FileOpUtils;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.ng.nosyncbuilder.misc.NewProjectExtraInfo;
import com.android.tools.idea.gradle.project.sync.ng.nosyncbuilder.misc.NewProjectExtraInfoBuilder;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.npw.model.MultiTemplateRenderer;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.platform.NavigationType;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class NewProjectModel
extends WizardModel {
    private static final String PROPERTIES_DOMAIN_KEY = "SAVED_COMPANY_DOMAIN";
    private static final String PROPERTIES_ANDROID_PACKAGE_KEY = "SAVED_ANDROID_PACKAGE";
    private static final String PROPERTIES_CPP_SUPPORT_KEY = "SAVED_PROJECT_CPP_SUPPORT";
    private static final String PROPERTIES_KOTLIN_SUPPORT_KEY = "SAVED_PROJECT_KOTLIN_SUPPORT";
    private static final String EXAMPLE_DOMAIN = "example.com";
    private static final Pattern DISALLOWED_IN_DOMAIN = Pattern.compile("[^a-zA-Z0-9_]");
    private final StringProperty myApplicationName;
    private final StringProperty myCompanyDomain;
    private final StringProperty myPackageName;
    private final StringProperty myProjectLocation;
    private final BoolProperty myEnableCppSupport;
    private final StringProperty myCppFlags;
    private final OptionalProperty<Project> myProject;
    private final Map<String, Object> myTemplateValues;
    private final Set<NewModuleModel> myNewModels;
    private final ProjectSyncInvoker myProjectSyncInvoker;
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    private final BoolProperty myEnableKotlinSupport;
    private final BoolProperty myUseOfflineRepo;
    private final BoolProperty myUseAndroidx;
    private final OptionalProperty<NavigationType> myNavigationType;
    private NewProjectExtraInfo myNewProjectExtraInfo;

    private static Logger getLogger() {
        return Logger.getInstance(NewProjectModel.class);
    }

    public NewProjectModel() {
        this(new ProjectSyncInvoker.DefaultProjectSyncInvoker());
    }

    public NewProjectModel(@NotNull ProjectSyncInvoker projectSyncInvoker) {
        if (projectSyncInvoker == null) {
            NewProjectModel.$$$reportNull$$$0(0);
        }
        this.myApplicationName = new StringValueProperty(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myCompanyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(true));
        this.myPackageName = new StringValueProperty();
        this.myProjectLocation = new StringValueProperty();
        this.myEnableCppSupport = new BoolValueProperty();
        this.myCppFlags = new StringValueProperty();
        this.myProject = new OptionalValueProperty<Project>();
        this.myTemplateValues = Maps.newHashMap();
        this.myNewModels = new HashSet<NewModuleModel>();
        this.myEnableKotlinSupport = new BoolValueProperty();
        this.myUseOfflineRepo = new BoolValueProperty();
        this.myUseAndroidx = new BoolValueProperty();
        this.myNavigationType = new OptionalValueProperty<NavigationType>(NavigationType.NONE);
        this.myProjectSyncInvoker = projectSyncInvoker;
        this.myMultiTemplateRenderer = new MultiTemplateRenderer(null, this.myProjectSyncInvoker);
        this.myCompanyDomain.addListener(sender -> {
            String domain = (String)this.myCompanyDomain.get();
            if (AndroidUtils.isValidAndroidPackageName(domain)) {
                PropertiesComponent.getInstance().setValue(PROPERTIES_DOMAIN_KEY, domain);
            }
        });
        this.myPackageName.addListener(sender -> {
            String androidPackage = (String)this.myPackageName.get();
            int lastDotIdx = androidPackage.lastIndexOf(46);
            if (lastDotIdx >= 0) {
                androidPackage = androidPackage.substring(0, lastDotIdx);
            }
            if (AndroidUtils.isValidAndroidPackageName(androidPackage)) {
                PropertiesComponent.getInstance().setValue(PROPERTIES_ANDROID_PACKAGE_KEY, androidPackage);
            }
        });
        this.myApplicationName.addConstraint(String::trim);
        this.myEnableCppSupport.set(NewProjectModel.getInitialCppSupport());
        this.myEnableKotlinSupport.set(NewProjectModel.getInitialKotlinSupport());
        this.myUseAndroidx.set(this.getInitialUseAndroidxSupport());
    }

    @NotNull
    public ProjectSyncInvoker getProjectSyncInvoker() {
        ProjectSyncInvoker projectSyncInvoker = this.myProjectSyncInvoker;
        if (projectSyncInvoker == null) {
            NewProjectModel.$$$reportNull$$$0(1);
        }
        return projectSyncInvoker;
    }

    public StringProperty packageName() {
        return this.myPackageName;
    }

    public StringProperty applicationName() {
        return this.myApplicationName;
    }

    public StringProperty companyDomain() {
        return this.myCompanyDomain;
    }

    public StringProperty projectLocation() {
        return this.myProjectLocation;
    }

    public BoolProperty enableCppSupport() {
        return this.myEnableCppSupport;
    }

    public StringProperty cppFlags() {
        return this.myCppFlags;
    }

    public BoolProperty enableKotlinSupport() {
        return this.myEnableKotlinSupport;
    }

    @NotNull
    public BoolProperty useOfflineRepo() {
        BoolProperty boolProperty = this.myUseOfflineRepo;
        if (boolProperty == null) {
            NewProjectModel.$$$reportNull$$$0(2);
        }
        return boolProperty;
    }

    public boolean isAndroidxAvailable() {
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (sdkData == null) {
            return false;
        }
        for (IAndroidTarget target : sdkData.getTargets()) {
            if (target.getVersion().getApiLevel() < 28) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public BoolProperty useAndroidx() {
        BoolProperty boolProperty = this.myUseAndroidx;
        if (boolProperty == null) {
            NewProjectModel.$$$reportNull$$$0(3);
        }
        return boolProperty;
    }

    public OptionalProperty<Project> project() {
        return this.myProject;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        Map<String, Object> map2 = this.myTemplateValues;
        if (map2 == null) {
            NewProjectModel.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @NotNull
    public OptionalProperty<NavigationType> navigationType() {
        OptionalProperty<NavigationType> optionalProperty = this.myNavigationType;
        if (optionalProperty == null) {
            NewProjectModel.$$$reportNull$$$0(5);
        }
        return optionalProperty;
    }

    public Set<NewModuleModel> getNewModuleModels() {
        return this.myNewModels;
    }

    public MultiTemplateRenderer getMultiTemplateRenderer() {
        return this.myMultiTemplateRenderer;
    }

    @NotNull
    public static String getInitialDomain(boolean includeUserName) {
        String androidPackage = PropertiesComponent.getInstance().getValue(PROPERTIES_ANDROID_PACKAGE_KEY);
        if (androidPackage != null) {
            String string = new DomainToPackageExpression(new StringValueProperty(androidPackage), new StringValueProperty("")).get();
            if (string == null) {
                NewProjectModel.$$$reportNull$$$0(6);
            }
            return string;
        }
        String domain = PropertiesComponent.getInstance().getValue(PROPERTIES_DOMAIN_KEY);
        if (domain != null) {
            String string = domain;
            if (string == null) {
                NewProjectModel.$$$reportNull$$$0(7);
            }
            return string;
        }
        String userName = includeUserName ? System.getProperty("user.name") : null;
        String string = userName == null ? EXAMPLE_DOMAIN : NewProjectModel.toPackagePart(userName) + '.' + EXAMPLE_DOMAIN;
        if (string == null) {
            NewProjectModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getSuggestedProjectPackage(@NotNull Project project, boolean isInstantApp) {
        if (project == null) {
            NewProjectModel.$$$reportNull$$$0(9);
        }
        String basePackage = null;
        if (isInstantApp) {
            AndroidFacet androidFacet;
            Module baseFeatureModule = InstantApps.findBaseFeature(project);
            AndroidFacet androidFacet2 = androidFacet = baseFeatureModule == null ? null : AndroidFacet.getInstance(baseFeatureModule);
            if (androidFacet != null && ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel() != null) {
                basePackage = AndroidPackageUtils.getPackageForApplication(androidFacet);
            }
        }
        if (basePackage == null) {
            StringValueProperty companyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(false));
            basePackage = new DomainToPackageExpression(companyDomain, new StringValueProperty("")).get();
        }
        String string = basePackage;
        if (string == null) {
            NewProjectModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static boolean getInitialCppSupport() {
        return PropertiesComponent.getInstance().isTrueValue(PROPERTIES_CPP_SUPPORT_KEY);
    }

    private static boolean getInitialKotlinSupport() {
        return PropertiesComponent.getInstance().isTrueValue(PROPERTIES_KOTLIN_SUPPORT_KEY);
    }

    @NotNull
    private Boolean getInitialUseAndroidxSupport() {
        Boolean bl = (Boolean)StudioFlags.NELE_USE_ANDROIDX_DEFAULT.get() != false && this.isAndroidxAvailable();
        if (bl == null) {
            NewProjectModel.$$$reportNull$$$0(11);
        }
        return bl;
    }

    public void onWizardFinished(@NotNull ModelWizard.WizardResult wizardResult) {
        if (wizardResult == null) {
            NewProjectModel.$$$reportNull$$$0(12);
        }
        if (wizardResult == ModelWizard.WizardResult.FINISHED) {
            PropertiesComponent.getInstance().setValue(PROPERTIES_CPP_SUPPORT_KEY, ((Boolean)this.myEnableCppSupport.get()).booleanValue());
            PropertiesComponent.getInstance().setValue(PROPERTIES_KOTLIN_SUPPORT_KEY, ((Boolean)this.myEnableKotlinSupport.get()).booleanValue());
        }
    }

    @NotNull
    public static String toPackagePart(@NotNull String s) {
        String name;
        if (s == null) {
            NewProjectModel.$$$reportNull$$$0(13);
        }
        if (!(name = StringUtil.toLowerCase((String)DISALLOWED_IN_DOMAIN.matcher(s = s.replace('-', '_')).replaceAll(""))).isEmpty() && AndroidUtils.isReservedKeyword(name) != null) {
            name = StringUtil.toLowerCase((String)StringUtil.fixVariableNameDerivedFromPropertyName((String)name));
        }
        String string = name;
        if (string == null) {
            NewProjectModel.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static String sanitizeApplicationName(@NotNull String s) {
        if (s == null) {
            NewProjectModel.$$$reportNull$$$0(15);
        }
        String string = DISALLOWED_IN_DOMAIN.matcher(s).replaceAll("");
        if (string == null) {
            NewProjectModel.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    protected void handleFinished() {
        String projectLocation = (String)this.projectLocation().get();
        String projectName = (String)this.applicationName().get();
        boolean couldEnsureLocationExists = (Boolean)WriteCommandAction.runWriteCommandAction(null, () -> {
            try {
                if (VfsUtil.createDirectoryIfMissing((String)projectLocation) != null && FileOpUtils.create().canWrite(new File(projectLocation))) {
                    return true;
                }
            }
            catch (Exception e) {
                NewProjectModel.getLogger().error(String.format("Exception thrown when creating target project location: %1$s", projectLocation), (Throwable)e);
            }
            return false;
        });
        if (couldEnsureLocationExists) {
            Project project = (Project)UIUtil.invokeAndWaitIfNeeded(() -> ProjectManager.getInstance().createProject(projectName, projectLocation));
            this.project().setValue(project);
            this.myMultiTemplateRenderer.setProject(project);
        } else {
            String msg = "Could not ensure the target project location exists and is accessible:\n\n%1$s\n\nPlease try to specify another path.";
            Messages.showErrorDialog((String)String.format(msg, projectLocation), (String)"Error Creating Project");
        }
        this.myMultiTemplateRenderer.requestRender(new ProjectTemplateRenderer());
    }

    private static String getOfflineReposString() {
        return EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths().stream().map(f -> FilenameUtils.normalize((String)f.toString())).collect(Collectors.joining(","));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSyncInvoker";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/model/NewProjectModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardResult";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/model/NewProjectModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSyncInvoker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "useOfflineRepo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "useAndroidx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateValues";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "navigationType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialDomain";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuggestedProjectPackage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialUseAndroidxSupport";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toPackagePart";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeApplicationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSuggestedProjectPackage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onWizardFinished";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toPackagePart";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeApplicationName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProjectTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        private ProjectTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            if (NewProjectModel.this.project().getValueOrNull() == null) {
                return false;
            }
            this.performCreateProject(true);
            return true;
        }

        @Override
        public void render() {
            this.performCreateProject(false);
            try {
                File projectRoot = VfsUtilCore.virtualToIoFile((VirtualFile)NewProjectModel.this.project().getValue().getBaseDir());
                AndroidGradleModuleUtils.setGradleWrapperExecutable(projectRoot);
            }
            catch (IOException e) {
                NewProjectModel.getLogger().warn("Failed to update Gradle wrapper permissions", (Throwable)e);
            }
            ApplicationManager.getApplication().invokeLater(this::performGradleImport);
        }

        private void performCreateProject(boolean dryRun) {
            Project project = NewProjectModel.this.project().getValue();
            NewProjectModel.this.myTemplateValues.put("includeCppSupport", NewProjectModel.this.myEnableCppSupport.get());
            NewProjectModel.this.myTemplateValues.put("cppFlags", NewProjectModel.this.myCppFlags.get());
            NewProjectModel.this.myTemplateValues.put("topOut", project.getBasePath());
            NewProjectModel.this.myTemplateValues.put("includeKotlinSupport", NewProjectModel.this.myEnableKotlinSupport.get());
            NewProjectModel.this.myTemplateValues.put("navigationType", NewProjectModel.this.myNavigationType.getValue());
            if (((Boolean)StudioFlags.NPW_OFFLINE_REPO_CHECKBOX.get()).booleanValue()) {
                String offlineReposString = NewProjectModel.getOfflineReposString();
                NewProjectModel.this.myTemplateValues.put("offlineRepoPath", offlineReposString);
                if (((Boolean)NewProjectModel.this.myUseOfflineRepo.get()).booleanValue()) {
                    NewProjectModel.this.myTemplateValues.put("useOfflineRepo", true);
                }
            }
            boolean shouldUseNewExtraProjectInfo = !dryRun & (Boolean)StudioFlags.SHIPPED_SYNC_ENABLED.get();
            NewProjectExtraInfoBuilder newProjectExtraInfoBuilder = null;
            if (shouldUseNewExtraProjectInfo) {
                newProjectExtraInfoBuilder = new NewProjectExtraInfoBuilder();
            }
            NewProjectModel.this.myTemplateValues.put("addAndroidXSupport", NewProjectModel.this.myUseAndroidx.get());
            HashMap params = Maps.newHashMap((Map)NewProjectModel.this.myTemplateValues);
            for (NewModuleModel newModuleModel : NewProjectModel.this.getNewModuleModels()) {
                params.putAll(newModuleModel.getTemplateValues());
                Map<String, Object> renderTemplateValues = newModuleModel.getRenderTemplateValues().getValue();
                renderTemplateValues.putAll(NewProjectModel.this.myTemplateValues);
                newModuleModel.getTemplateValues().putAll(NewProjectModel.this.myTemplateValues);
                if (!shouldUseNewExtraProjectInfo) continue;
                newProjectExtraInfoBuilder.fill(renderTemplateValues);
            }
            if (shouldUseNewExtraProjectInfo) {
                newProjectExtraInfoBuilder.fill(params);
            }
            if (shouldUseNewExtraProjectInfo) {
                try {
                    NewProjectModel.this.myNewProjectExtraInfo = newProjectExtraInfoBuilder.build();
                }
                catch (IllegalStateException e) {
                    NewProjectModel.getLogger().warn("Failed to build NewProjectExtraInfo", (Throwable)e);
                }
            }
            Template projectTemplate = Template.createFromName("gradle-projects", "NewAndroidProject");
            RenderingContext context = RenderingContext.Builder.newContext(projectTemplate, project).withCommandName("New Project").withDryRun(dryRun).withShowErrors(true).withParams(params).build();
            projectTemplate.render(context, dryRun);
        }

        private void performGradleImport() {
            Sdk jdk;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            GradleProjectImporter projectImporter = GradleProjectImporter.getInstance();
            File rootLocation = new File((String)NewProjectModel.this.projectLocation().get());
            File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(rootLocation);
            try {
                File gradleDistFile = EmbeddedDistributionPaths.getInstance().findEmbeddedGradleDistributionFile("4.10.1");
                if (gradleDistFile == null) {
                    GradleWrapper.get(wrapperPropertiesFilePath).updateDistributionUrl("4.10.1");
                } else {
                    GradleWrapper.get(wrapperPropertiesFilePath).updateDistributionUrl(gradleDistFile);
                }
            }
            catch (IOException e) {
                NewProjectModel.getLogger().warn("Failed to update Gradle wrapper file", (Throwable)e);
            }
            if (!IdeInfo.getInstance().isAndroidStudio() && (jdk = IdeSdks.getInstance().getJdk()) != null) {
                ApplicationManager.getApplication().runWriteAction(() -> ProjectRootManager.getInstance((Project)NewProjectModel.this.project().getValue()).setProjectSdk(jdk));
            }
            try {
                LanguageLevel initialLanguageLevel = null;
                AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
                if (sdkData != null) {
                    JavaSdkVersion version2;
                    JavaSdk jdk2 = JavaSdk.getInstance();
                    Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk2);
                    if (sdk != null && (version2 = jdk2.getVersion(sdk)) != null && version2.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                        initialLanguageLevel = LanguageLevel.JDK_1_7;
                    }
                }
                GradleProjectImporter.Request request = new GradleProjectImporter.Request();
                request.isNewProject = true;
                request.javaLanguageLevel = initialLanguageLevel;
                request.project = NewProjectModel.this.project().getValue();
                request.extraInfo = NewProjectModel.this.myNewProjectExtraInfo;
                projectImporter.importProject((String)NewProjectModel.this.applicationName().get(), rootLocation, request, new GradleSyncListener(){});
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)AndroidBundle.message("android.wizard.project.create.error", new Object[0]));
                NewProjectModel.getLogger().error((Throwable)e);
            }
        }
    }
}

