/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.model;

import com.android.tools.idea.npw.template.ConvertJavaToKotlinProvider;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.google.common.collect.Lists;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaToKotlinHandler {
    private JavaToKotlinHandler() {
    }

    @NotNull
    public static ConvertJavaToKotlinProvider getJavaToKotlinConversionProvider() {
        ConvertJavaToKotlinProvider[] providers = (ConvertJavaToKotlinProvider[])ConvertJavaToKotlinProvider.EP_NAME.getExtensions();
        if (providers.length == 0) {
            throw new RuntimeException("Could not find a JavaToKotlinConversionProvider, even though one should be bundled with Studio");
        }
        ConvertJavaToKotlinProvider convertJavaToKotlinProvider = providers[0];
        if (convertJavaToKotlinProvider == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(0);
        }
        return convertJavaToKotlinProvider;
    }

    static void convertJavaFilesToKotlin(@NotNull Project project, @NotNull List<File> files2, @NotNull Runnable postProcessFunction) {
        if (project == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(2);
        }
        if (postProcessFunction == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(3);
        }
        if (!JavaToKotlinHandler.hasJavaFiles(files2)) {
            DumbService.getInstance((Project)project).smartInvokeLater(postProcessFunction);
            return;
        }
        ConvertJavaToKotlinProvider provider = JavaToKotlinHandler.getJavaToKotlinConversionProvider();
        Disposable tempDisposable = Disposer.newDisposable();
        project.getMessageBus().connect(tempDisposable).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
            if (result2 == ProjectSystemSyncManager.SyncResult.SUCCESS || result2 == ProjectSystemSyncManager.SyncResult.FAILURE) {
                JavaToKotlinHandler.callConverter(project, provider, files2, postProcessFunction);
                Disposer.dispose((Disposable)tempDisposable);
            }
        });
    }

    static boolean hasJavaFiles(@NotNull List<File> files2) {
        if (files2 == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(4);
        }
        return files2.stream().anyMatch(file -> file.getName().endsWith(".java"));
    }

    private static void callConverter(@NotNull Project project, @NotNull ConvertJavaToKotlinProvider provider, @NotNull List<File> files2, @NotNull Runnable postProcessFunction) {
        if (project == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(6);
        }
        if (files2 == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(7);
        }
        if (postProcessFunction == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(8);
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            List<PsiJavaFile> psiJavaFiles = JavaToKotlinHandler.files2PsiJavaFiles(project, files2);
            if (!psiJavaFiles.isEmpty()) {
                provider.convertToKotlin(project, psiJavaFiles);
            }
            postProcessFunction.run();
        });
    }

    private static List<PsiJavaFile> files2PsiJavaFiles(Project project, List<File> files2) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        ArrayList psiJavaFiles = Lists.newArrayListWithExpectedSize((int)files2.size());
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (File file : files2) {
            PsiFile psiFile;
            VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
            if (virtualFile == null || !((psiFile = psiManager.findFile(virtualFile)) instanceof PsiJavaFile)) continue;
            psiJavaFiles.add((PsiJavaFile)psiFile);
        }
        return psiJavaFiles;
    }

    static boolean hasKotlinFacet(@NotNull Project project) {
        FacetType kotlinFacet;
        if (project == null) {
            JavaToKotlinHandler.$$$reportNull$$$0(9);
        }
        if ((kotlinFacet = FacetTypeRegistry.getInstance().findFacetType("kotlin-language")) == null) {
            return false;
        }
        FacetTypeId kotlinFacetId = kotlinFacet.getId();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (FacetManager.getInstance((Module)module).getFacetByType(kotlinFacetId) == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/model/JavaToKotlinHandler";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postProcessFunction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaToKotlinConversionProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/model/JavaToKotlinHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertJavaFilesToKotlin";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasJavaFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "callConverter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasKotlinFacet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

