/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.dynamicapp.ConfigureDynamicModuleStep;
import com.android.tools.idea.npw.dynamicapp.DynamicFeatureModel;
import com.android.tools.idea.npw.model.NewModuleModel;
import com.android.tools.idea.npw.model.NewProjectModel;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.ui.ActivityGallery;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.awt.Image;
import java.io.File;
import java.util.Collection;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewDynamicAppModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public static final String DYNAMIC_FEATURE_TEMPLATE = "Dynamic Feature";
    public static final String INSTANT_DYNAMIC_FEATURE_TEMPLATE = "Dynamic Feature (Instant App)";

    public Collection<ModuleGalleryEntry> getDescriptions(Project project) {
        if (((Boolean)StudioFlags.UAB_INSTANT_DYNAMIC_FEATURE_MODULE.get()).booleanValue() && !this.hasFeaturePlugin(project)) {
            return ImmutableList.of((Object)new FeatureTemplateGalleryEntry(false), (Object)new FeatureTemplateGalleryEntry(true));
        }
        return ImmutableList.of((Object)new FeatureTemplateGalleryEntry(false));
    }

    private boolean hasFeaturePlugin(Project project) {
        return (Boolean)StudioFlags.UAB_HIDE_INSTANT_MODULES_FOR_NON_FEATURE_PLUGIN_PROJECTS.get() != false && AndroidGradleModuleUtils.projectContainsFeatureModule(project);
    }

    private static class FeatureTemplateGalleryEntry
    implements ModuleTemplateGalleryEntry {
        @NotNull
        private final File myTemplateFile;
        @NotNull
        private TemplateHandle myTemplateHandle;
        private boolean myIsInstant;

        FeatureTemplateGalleryEntry(boolean isInstant) {
            this.myTemplateFile = TemplateManager.getInstance().getTemplateFile("Application", isInstant ? NewDynamicAppModuleDescriptionProvider.INSTANT_DYNAMIC_FEATURE_TEMPLATE : NewDynamicAppModuleDescriptionProvider.DYNAMIC_FEATURE_TEMPLATE);
            this.myTemplateHandle = new TemplateHandle(this.myTemplateFile);
            this.myIsInstant = isInstant;
        }

        @Override
        @Nullable
        public Image getIcon() {
            return ActivityGallery.getTemplateImage(this.myTemplateHandle, false);
        }

        @Override
        @NotNull
        public String getName() {
            String string = AndroidBundle.message(this.myIsInstant ? "android.wizard.module.new.dynamic.module.instant" : "android.wizard.module.new.dynamic.module", new Object[0]);
            if (string == null) {
                FeatureTemplateGalleryEntry.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myTemplateHandle.getMetadata().getDescription();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        @NotNull
        public File getTemplateFile() {
            File file = this.myTemplateFile;
            if (file == null) {
                FeatureTemplateGalleryEntry.$$$reportNull$$$0(1);
            }
            return file;
        }

        @Override
        @NotNull
        public FormFactor getFormFactor() {
            FormFactor formFactor = FormFactor.MOBILE;
            if (formFactor == null) {
                FeatureTemplateGalleryEntry.$$$reportNull$$$0(2);
            }
            return formFactor;
        }

        @Override
        public boolean isLibrary() {
            return false;
        }

        @Override
        public boolean isInstantApp() {
            return false;
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                FeatureTemplateGalleryEntry.$$$reportNull$$$0(3);
            }
            Project project = model.getProject().getValue();
            String basePackage = NewProjectModel.getSuggestedProjectPackage(project, false);
            ConfigureDynamicModuleStep configureDynamicModuleStep = new ConfigureDynamicModuleStep(new DynamicFeatureModel(project, this.myTemplateHandle, model.getProjectSyncInvoker()), basePackage, this.myIsInstant);
            if (configureDynamicModuleStep == null) {
                FeatureTemplateGalleryEntry.$$$reportNull$$$0(4);
            }
            return configureDynamicModuleStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/dynamicapp/NewDynamicAppModuleDescriptionProvider$FeatureTemplateGalleryEntry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormFactor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/dynamicapp/NewDynamicAppModuleDescriptionProvider$FeatureTemplateGalleryEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

