/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.PositiveIntegerValidator;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.VectorIconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.ui.VectorAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.VectorIconButton;
import com.android.tools.idea.npw.assetstudio.wizard.ConfirmGenerateIconsStep;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentStateUtil;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.adapters.StringToIntAdapterProperty;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.expressions.string.FormatExpression;
import com.android.tools.idea.observable.ui.ColorProperty;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.ui.VectorImageComponent;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public final class NewVectorAssetStep
extends ModelWizardStep<GenerateIconsModel>
implements PersistentStateComponent<PersistentState> {
    private static final int DEFAULT_MATERIAL_ICON_SIZE = 24;
    private static final String ICON_PREFIX = "ic_";
    private static final String DEFAULT_OUTPUT_NAME = "ic_vector_name";
    private static final AssetSourceType DEFAULT_ASSET_SOURCE_TYPE = AssetSourceType.CLIP_ART;
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private static final String VECTOR_ASSET_STEP_PROPERTY = "vectorAssetStep";
    private static final String OUTPUT_NAME_PROPERTY = "outputName";
    private static final String ASSET_SOURCE_TYPE_PROPERTY = "assetSourceType";
    private static final String CLIPART_ASSET_PROPERTY = "clipartAsset";
    private static final String SOURCE_FILE_PROPERTY = "sourceFile";
    private static final String OVERRIDE_SIZE_PROPERTY = "overrideSize";
    private static final String WIDTH_PROPERTY = "width";
    private static final String HEIGHT_PROPERTY = "height";
    private static final String COLOR_PROPERTY = "color";
    private static final String OPACITY_PERCENT_PROPERTY = "opacityPercent";
    private static final String AUTO_MIRRORED_PROPERTY = "autoMirrored";
    private final ObjectProperty<AssetSourceType> myAssetSourceType;
    private final ObjectProperty<VectorAsset> myActiveAsset;
    private final OptionalProperty<Dimension> myOriginalSize;
    private final StringProperty myOutputName;
    private final BoolProperty myOverrideSize;
    private final IntProperty myWidth;
    private final IntProperty myHeight;
    private final ObjectProperty<Color> myColor;
    private final IntProperty myOpacityPercent;
    private final BoolProperty myAutoMirrored;
    private final ObjectValueProperty<Validator.Result> myAssetValidityState;
    private final IdeResourceNameValidator myNameValidator;
    private final BindingsManager myGeneralBindings;
    private final BindingsManager myActiveAssetBindings;
    private final ListenerManager myListeners;
    @NotNull
    private final VectorIconGenerator myIconGenerator;
    @NotNull
    private final AndroidFacet myFacet;
    private final ValidatorPanel myValidatorPanel;
    private JPanel myPanel;
    private JPanel myImagePreviewPanel;
    private VectorImageComponent myImagePreview;
    private JPanel myResourceNamePanel;
    private JTextField myOutputNameTextField;
    private JPanel mySourceAssetTypePanel;
    private JPanel mySourceAssetRadioButtons;
    private JRadioButton myClipartRadioButton;
    private JRadioButton myLocalFileRadioButton;
    private JPanel myIconPickerPanel;
    private VectorIconButton myClipartAssetButton;
    private JPanel myFileBrowserPanel;
    private VectorAssetBrowser myFileBrowser;
    private JPanel myResizePanel;
    private JTextField myWidthTextField;
    private JTextField myHeightTextField;
    private JCheckBox myOverrideSizeCheckBox;
    private JPanel myColorRowPanel;
    private ColorPanel myColorPanel;
    private JPanel myOpacityPanel;
    private JSlider myOpacitySlider;
    private JBLabel myOpacityValueLabel;
    private JCheckBox myEnableAutoMirroredCheckBox;
    private JPanel myPreviewPanel;
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JBScrollPane myScrollPane;

    public NewVectorAssetStep(@NotNull GenerateIconsModel model, @NotNull AndroidFacet facet) {
        if (model == null) {
            NewVectorAssetStep.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            NewVectorAssetStep.$$$reportNull$$$0(1);
        }
        super(model, "Configure Vector Asset");
        this.$$$setupUI$$$();
        this.myOriginalSize = new OptionalValueProperty<Dimension>();
        this.myWidth = new IntValueProperty();
        this.myHeight = new IntValueProperty();
        this.myAssetValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
        this.myNameValidator = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE);
        this.myGeneralBindings = new BindingsManager();
        this.myActiveAssetBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myFacet = facet;
        int minSdkVersion2 = AndroidModuleInfo.getInstance(this.myFacet).getMinSdkVersion().getApiLevel();
        this.myIconGenerator = new VectorIconGenerator(this.myFacet.getModule().getProject(), minSdkVersion2);
        Disposer.register((Disposable)this, (Disposable)this.myIconGenerator);
        this.myImagePreviewPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        this.myAssetSourceType = new SelectedRadioButtonProperty<AssetSourceType>(DEFAULT_ASSET_SOURCE_TYPE, (T[])AssetSourceType.values(), this.myClipartRadioButton, this.myLocalFileRadioButton);
        this.myActiveAsset = new ObjectValueProperty<VectorAsset>(this.myClipartAssetButton.getAsset());
        this.myOutputName = new TextProperty(this.myOutputNameTextField);
        this.myOverrideSize = new SelectedProperty(this.myOverrideSizeCheckBox);
        this.myColor = ObjectProperty.wrap(new ColorProperty(this.myColorPanel));
        this.myOpacityPercent = new SliderValueProperty(this.myOpacitySlider);
        this.myAutoMirrored = new SelectedProperty(this.myEnableAutoMirroredCheckBox);
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        ActionListener assetListener = actionEvent -> this.renderPreviews();
        this.myClipartAssetButton.addAssetListener(assetListener);
        this.myFileBrowser.addAssetListener(assetListener);
        this.myListeners.receiveAndFire(this.myAssetSourceType, sourceType -> {
            this.myIconPickerPanel.setVisible(sourceType == AssetSourceType.CLIP_ART);
            this.myColorRowPanel.setVisible(sourceType == AssetSourceType.CLIP_ART);
            this.myFileBrowserPanel.setVisible(sourceType == AssetSourceType.FILE);
            this.myActiveAsset.set(sourceType == AssetSourceType.CLIP_ART ? this.myClipartAssetButton.getAsset() : this.myFileBrowser.getAsset());
        });
        this.myGeneralBindings.bindTwoWay(new StringToIntAdapterProperty(new TextProperty(this.myWidthTextField)), this.myWidth);
        this.myGeneralBindings.bindTwoWay(new StringToIntAdapterProperty(new TextProperty(this.myHeightTextField)), this.myHeight);
        this.myGeneralBindings.bind(new EnabledProperty(this.myWidthTextField), this.myOverrideSize);
        this.myGeneralBindings.bind(new EnabledProperty(this.myHeightTextField), this.myOverrideSize);
        this.myListeners.listenAll(this.myOverrideSize, this.myOriginalSize).withAndFire(() -> {
            if (!((Boolean)this.myOverrideSize.get()).booleanValue() || !((Optional)this.myOriginalSize.get()).isPresent()) {
                this.myWidth.set(24);
                this.myHeight.set(24);
            } else {
                this.myWidth.set(this.myOriginalSize.getValue().width);
                this.myHeight.set(this.myOriginalSize.getValue().height);
            }
        });
        this.myGeneralBindings.bind(new TextProperty((JLabel)this.myOpacityValueLabel), new FormatExpression("%d %%", this.myOpacityPercent));
        this.myListeners.listenAll(this.myActiveAsset, this.myOverrideSize, this.myWidth, this.myHeight, this.myColor, this.myOpacityPercent, this.myAutoMirrored).with(this::renderPreviews);
        this.myListeners.listenAndFire(this.myActiveAsset, sender -> {
            this.myActiveAssetBindings.releaseAll();
            this.myActiveAssetBindings.bind(this.myOutputName, new Expression<String>(new ObservableValue[]{((VectorAsset)this.myActiveAsset.get()).path()}){

                @Override
                @NotNull
                public String get() {
                    File file = (File)((VectorAsset)NewVectorAssetStep.this.myActiveAsset.get()).path().get();
                    if (!file.exists() || file.isDirectory()) {
                        if (NewVectorAssetStep.DEFAULT_OUTPUT_NAME == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return NewVectorAssetStep.DEFAULT_OUTPUT_NAME;
                    }
                    String name = FileUtilRt.getNameWithoutExtension((String)file.getName()).toLowerCase(Locale.getDefault());
                    if (!name.startsWith(NewVectorAssetStep.ICON_PREFIX)) {
                        name = NewVectorAssetStep.ICON_PREFIX + AndroidResourceUtil.getValidResourceFileName(name);
                    }
                    String string = AndroidResourceUtil.getValidResourceFileName(name);
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/wizard/NewVectorAssetStep$1", "get"));
                }
            });
            this.myValidatorPanel.registerValidator((ObservableValue)this.myOutputName, name -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText((String)name)));
            this.myValidatorPanel.registerValidator((ObservableValue)this.myWidth, (Validator)new PositiveIntegerValidator("Width should be a positive value"));
            this.myValidatorPanel.registerValidator((ObservableValue)this.myHeight, (Validator)new PositiveIntegerValidator("Height should be a positive value"));
            this.myValidatorPanel.registerValidator(this.myAssetValidityState, validity -> NewVectorAssetStep.truncateMessage(validity));
            if (this.myAssetSourceType.get() == AssetSourceType.CLIP_ART) {
                this.myActiveAssetBindings.bind(ObjectProperty.wrap(((VectorAsset)this.myActiveAsset.get()).color()), this.myColor);
            }
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).opacityPercent(), this.myOpacityPercent);
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).autoMirrored(), this.myAutoMirrored);
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).outputWidth(), this.myWidth);
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).outputHeight(), this.myHeight);
        });
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<VectorAsset>(this.myActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.outputName(), this.myOutputName);
        PersistentStateUtil.load(this, ((GenerateIconsModel)this.getModel()).getPersistentState().getChild(VECTOR_ASSET_STEP_PROPERTY));
        this.renderPreviews();
    }

    @NotNull
    private static Validator.Result truncateMessage(@NotNull Validator.Result validity) {
        if (validity == null) {
            NewVectorAssetStep.$$$reportNull$$$0(2);
        }
        String message = validity.getMessage();
        int lineCount = 0;
        int lineOffset = 0;
        int offset = 0;
        while ((offset = message.indexOf(10, offset)) >= 0) {
            ++offset;
            if (++lineCount > 3) {
                message = message.substring(0, lineOffset) + "...";
                Validator.Result result2 = new Validator.Result(validity.getSeverity(), message);
                if (result2 == null) {
                    NewVectorAssetStep.$$$reportNull$$$0(3);
                }
                return result2;
            }
            lineOffset = offset;
        }
        Validator.Result result3 = validity;
        if (result3 == null) {
            NewVectorAssetStep.$$$reportNull$$$0(4);
        }
        return result3;
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        List<ConfirmGenerateIconsStep> list = Collections.singletonList(new ConfirmGenerateIconsStep((GenerateIconsModel)this.getModel(), AndroidPackageUtils.getModuleTemplates(this.myFacet, null)));
        if (list == null) {
            NewVectorAssetStep.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            NewVectorAssetStep.$$$reportNull$$$0(6);
        }
        return validatorPanel;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            NewVectorAssetStep.$$$reportNull$$$0(7);
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setIconGenerator(this.myIconGenerator);
    }

    @Override
    public void onWizardFinished() {
        ((GenerateIconsModel)this.getModel()).getPersistentState().setChild(VECTOR_ASSET_STEP_PROPERTY, this.getState());
    }

    @Override
    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        state.set(OUTPUT_NAME_PROPERTY, (String)this.myOutputName.get(), DEFAULT_OUTPUT_NAME);
        state.set(ASSET_SOURCE_TYPE_PROPERTY, (Enum)this.myAssetSourceType.get(), DEFAULT_ASSET_SOURCE_TYPE);
        state.setChild(CLIPART_ASSET_PROPERTY, this.myClipartAssetButton.getState());
        File file = (File)this.myFileBrowser.getAsset().path().get();
        state.set(SOURCE_FILE_PROPERTY, file.getPath(), this.getProjectPath());
        state.set(OVERRIDE_SIZE_PROPERTY, (Boolean)this.myOverrideSize.get(), false);
        state.set(WIDTH_PROPERTY, (Integer)this.myWidth.get(), 24);
        state.set(HEIGHT_PROPERTY, (Integer)this.myHeight.get(), 24);
        state.set(COLOR_PROPERTY, (Color)this.myColor.get(), DEFAULT_COLOR);
        state.set(OPACITY_PERCENT_PROPERTY, (Integer)this.myOpacityPercent.get(), 100);
        state.set(AUTO_MIRRORED_PROPERTY, (Boolean)this.myAutoMirrored.get(), false);
        PersistentState persistentState = state;
        if (persistentState == null) {
            NewVectorAssetStep.$$$reportNull$$$0(8);
        }
        return persistentState;
    }

    public void loadState(@NotNull PersistentState state) {
        if (state == null) {
            NewVectorAssetStep.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myOutputName.set(state.get(OUTPUT_NAME_PROPERTY, DEFAULT_OUTPUT_NAME));
            this.myAssetSourceType.set(state.get(ASSET_SOURCE_TYPE_PROPERTY, DEFAULT_ASSET_SOURCE_TYPE));
            PersistentStateUtil.load(this.myClipartAssetButton, state.getChild(CLIPART_ASSET_PROPERTY));
            String path = state.get(SOURCE_FILE_PROPERTY, this.getProjectPath());
            this.myFileBrowser.getAsset().path().set(new File(path));
            this.myOverrideSize.set(state.get(OVERRIDE_SIZE_PROPERTY, false));
            this.myWidth.set(state.get(WIDTH_PROPERTY, 24));
            this.myHeight.set(state.get(HEIGHT_PROPERTY, 24));
            this.myColor.set(state.get(COLOR_PROPERTY, DEFAULT_COLOR));
            this.myOpacityPercent.set(state.get(OPACITY_PERCENT_PROPERTY, 100));
            this.myAutoMirrored.set(state.get(AUTO_MIRRORED_PROPERTY, false));
        }, ModalityState.any());
    }

    @NotNull
    private @SystemIndependent String getProjectPath() {
        String projectPath = this.myFacet.getModule().getProject().getBasePath();
        assert (projectPath != null);
        String string = projectPath;
        if (string == null) {
            NewVectorAssetStep.$$$reportNull$$$0(10);
        }
        return string;
    }

    private void renderPreviews() {
        VectorPreviewUpdater previewUpdater = new VectorPreviewUpdater();
        NewVectorAssetStep.invokeVeryLate(previewUpdater::enqueueUpdate, ModalityState.any(), o -> Disposer.isDisposed((Disposable)this));
    }

    private static void invokeVeryLate(@NotNull Runnable runnable, @NotNull ModalityState state, @NotNull Condition expired) {
        if (runnable == null) {
            NewVectorAssetStep.$$$reportNull$$$0(11);
        }
        if (state == null) {
            NewVectorAssetStep.$$$reportNull$$$0(12);
        }
        if (expired == null) {
            NewVectorAssetStep.$$$reportNull$$$0(13);
        }
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> application.invokeLater(runnable, state, expired), state, expired);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validity";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/NewVectorAssetStep";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/NewVectorAssetStep";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "truncateMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invokeVeryLate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        VectorImageComponent vectorImageComponent;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        ColorPanel colorPanel;
        JPanel jPanel4;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JSlider jSlider;
        JPanel jPanel5;
        JCheckBox jCheckBox2;
        JPanel jPanel6;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel7;
        JPanel jPanel8;
        VectorAssetBrowser vectorAssetBrowser;
        JPanel jPanel9;
        VectorIconButton vectorIconButton;
        JPanel jPanel10;
        JTextField jTextField;
        JPanel jPanel11;
        JPanel jPanel12;
        JPanel jPanel13;
        this.myPanel = jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.setMinimumSize(new Dimension(720, 512));
        jPanel13.setPreferredSize(new Dimension(-1, -1));
        jPanel13.setToolTipText("");
        this.myLeftPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel12, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myResourceNamePanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel11, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jPanel11.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 15), null, null));
        this.myOutputNameTextField = jTextField = new JTextField();
        jTextField.setText("(name)");
        jPanel11.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(-1, 20), null, null));
        this.myIconPickerPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel10, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Clip Art:");
        jPanel10.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClipartAssetButton = vectorIconButton = new VectorIconButton();
        jPanel10.add((Component)vectorIconButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(24, 24), null));
        this.myFileBrowserPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel9).setVisible(true);
        jPanel12.add((Component)jPanel9, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Path:");
        jPanel9.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileBrowser = vectorAssetBrowser = new VectorAssetBrowser();
        jPanel9.add((Component)((Object)vectorAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.mySourceAssetTypePanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel8, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.mySourceAssetRadioButtons = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myClipartRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Clip Art");
        jPanel7.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLocalFileRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Local file (SVG, PSD)");
        jPanel7.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Asset Type:");
        jPanel8.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResizePanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Size:");
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel6.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, new Dimension(-1, 25), null, null));
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        this.myWidthTextField = jFormattedTextField;
        jFormattedTextField.setText("24");
        jPanel14.add((Component)jFormattedTextField, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("dp  X ");
        jPanel14.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JFormattedTextField jFormattedTextField2 = new JFormattedTextField();
        this.myHeightTextField = jFormattedTextField2;
        jFormattedTextField2.setText("24");
        jPanel14.add((Component)jFormattedTextField2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("dp");
        jPanel14.add((Component)jLabel5, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOverrideSizeCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        jCheckBox2.setText("Override");
        jCheckBox2.setToolTipText("Check to override the default Material Design size");
        jPanel14.add((Component)jCheckBox2, new GridConstraints(0, 4, 1, 1, 8, 0, 7, 0, null, null, null, 1));
        this.myOpacityPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel5, new GridConstraints(6, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Opacity:");
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel15, new GridConstraints(0, 1, 1, 1, 8, 2, 7, 3, null, null, null));
        this.myOpacitySlider = jSlider = new JSlider();
        jSlider.setMajorTickSpacing(20);
        jSlider.setMinorTickSpacing(10);
        jSlider.setPaintLabels(false);
        jSlider.setPaintTicks(false);
        jSlider.setPaintTrack(true);
        jSlider.setValue(100);
        jPanel15.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myOpacityValueLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(4);
        jBLabel.setText("100 %");
        jPanel15.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        this.myEnableAutoMirroredCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable auto mirroring for RTL layout");
        jCheckBox.setToolTipText("Check if your icon should flip in right-to-left layouts.");
        jPanel12.add((Component)jCheckBox, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel12.add((Component)spacer, new GridConstraints(8, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myColorRowPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 0, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Color:");
        jPanel4.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myColorPanel = colorPanel = new ColorPanel();
        colorPanel.setSelectedColor(new Color(-16777216));
        jPanel4.add((Component)colorPanel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myRightPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPreviewPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 20), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 0, 3, 6, null, null, null));
        this.myImagePreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        this.myImagePreview = vectorImageComponent = new VectorImageComponent();
        jPanel.add((Component)((Object)vectorImageComponent), new GridConstraints(0, 0, 1, 1, 1, 0, 3, 7, new Dimension(256, 256), new Dimension(256, 256), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Vector Drawable Preview");
        jPanel2.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static enum AssetSourceType {
        CLIP_ART,
        FILE;

    }

    private final class VectorPreviewUpdater {
        @Nullable
        private SwingWorker<Void, Void> myCurrentWorker;
        @Nullable
        private SwingWorker<Void, Void> myEnqueuedWorker;

        private VectorPreviewUpdater() {
        }

        public void enqueueUpdate() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myCurrentWorker == null) {
                this.myCurrentWorker = this.createWorker();
                this.myCurrentWorker.execute();
            } else if (this.myEnqueuedWorker == null) {
                this.myEnqueuedWorker = this.createWorker();
            }
        }

        private SwingWorker<Void, Void> createWorker() {
            return new SwingWorker<Void, Void>(){
                VectorAsset.ParseResult myParseResult;

                @Override
                protected Void doInBackground() {
                    try {
                        this.myParseResult = ((VectorAsset)NewVectorAssetStep.this.myActiveAsset.get()).parse(NewVectorAssetStep.this.myImagePreview.getWidth(), true);
                    }
                    catch (Throwable t) {
                        Logger.getInstance(this.getClass()).error(t);
                        this.myParseResult = new VectorAsset.ParseResult("Internal error parsing " + ((File)((VectorAsset)NewVectorAssetStep.this.myActiveAsset.get()).path().get()).getName());
                    }
                    return null;
                }

                @Override
                protected void done() {
                    assert (this.myParseResult != null);
                    NewVectorAssetStep.this.myAssetValidityState.set(this.myParseResult.getValidityState());
                    if (this.myParseResult.isValid()) {
                        BufferedImage image = this.myParseResult.getImage();
                        NewVectorAssetStep.this.myImagePreview.setIcon(image == null ? null : new ImageIcon(image));
                        NewVectorAssetStep.this.myOriginalSize.setValue(new Dimension(Math.round(this.myParseResult.getOriginalWidth()), Math.round(this.myParseResult.getOriginalHeight())));
                    } else {
                        NewVectorAssetStep.this.myImagePreview.setIcon(null);
                        NewVectorAssetStep.this.myOriginalSize.clear();
                    }
                    VectorPreviewUpdater.this.myCurrentWorker = null;
                    if (VectorPreviewUpdater.this.myEnqueuedWorker != null) {
                        VectorPreviewUpdater.this.myCurrentWorker = VectorPreviewUpdater.this.myEnqueuedWorker;
                        VectorPreviewUpdater.this.myEnqueuedWorker = null;
                        ApplicationManager.getApplication().invokeLater(() -> VectorPreviewUpdater.this.myCurrentWorker.execute(), ModalityState.any());
                    }
                }
            };
        }
    }
}

