/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.adtui.ImageComponent;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.utils.Pair;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewIconsPanel
extends JPanel {
    private static final String GENERATED_IMAGE_KEY = "GeneratedImage";
    @NotNull
    private final Theme myTheme;
    @NotNull
    private final Map<String, ImageComponent> myIconImages;
    @Nullable
    private CategoryIconMap.Filter myFilter;
    private JPanel myRootPanel;
    private JPanel myIconsPanel;
    private JBLabel myTitleLabel;

    public PreviewIconsPanel(@NotNull String title, @NotNull Theme theme) {
        if (title == null) {
            PreviewIconsPanel.$$$reportNull$$$0(0);
        }
        if (theme == null) {
            PreviewIconsPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myIconImages = new HashMap<String, ImageComponent>();
        this.add(this.myRootPanel);
        this.myTitleLabel.setText(title);
        this.myTitleLabel.setVisible(!title.isEmpty());
        this.myTheme = theme;
        this.myRootPanel.setBackground(this.myTheme.getMainColor());
        this.myRootPanel.setOpaque(this.myTheme != Theme.TRANSPARENT);
        this.myTitleLabel.setForeground(this.myTheme.getAltColor());
        this.setName("PreviewIconsPanel");
    }

    public PreviewIconsPanel(@NotNull String title, @NotNull Theme theme, @NotNull CategoryIconMap.Filter filter2) {
        if (title == null) {
            PreviewIconsPanel.$$$reportNull$$$0(2);
        }
        if (theme == null) {
            PreviewIconsPanel.$$$reportNull$$$0(3);
        }
        if (filter2 == null) {
            PreviewIconsPanel.$$$reportNull$$$0(4);
        }
        this(title, theme);
        this.myFilter = filter2;
    }

    private static void showPreviewImageImpl(@NotNull ImageComponent imageComponent, @NotNull BufferedImage sourceImage) {
        if (imageComponent == null) {
            PreviewIconsPanel.$$$reportNull$$$0(5);
        }
        if (sourceImage == null) {
            PreviewIconsPanel.$$$reportNull$$$0(6);
        }
        imageComponent.putClientProperty((Object)GENERATED_IMAGE_KEY, (Object)sourceImage);
        JBImageIcon icon = IconUtil.createImageIcon((BufferedImage)sourceImage);
        Dimension d = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        imageComponent.setPreferredSize(d);
        imageComponent.setMinimumSize(d);
        imageComponent.setIcon((Icon)icon);
    }

    @NotNull
    public List<IconPreviewInfo> getIconPreviewInfos() {
        ArrayList<IconPreviewInfo> result2 = new ArrayList<IconPreviewInfo>();
        JPanel icons = this.myIconsPanel;
        for (Component icon : icons.getComponents()) {
            JPanel iconPanel = (JPanel)icon;
            JBLabel label = (JBLabel)iconPanel.getComponent(0);
            ImageComponent imageComponent = (ImageComponent)iconPanel.getComponent(1);
            IconPreviewInfo previewInfo = new IconPreviewInfo();
            previewInfo.setLabel(label.getText());
            BufferedImage bufferedImage = (BufferedImage)imageComponent.getClientProperty((Object)GENERATED_IMAGE_KEY);
            if (bufferedImage != null) {
                previewInfo.setImage(bufferedImage);
            }
            previewInfo.setImageBorder(imageComponent.getBorder());
            previewInfo.setImageBackground(iconPanel.getBackground());
            previewInfo.setImageOpaque(iconPanel.isOpaque());
            result2.add(previewInfo);
        }
        ArrayList<IconPreviewInfo> arrayList = result2;
        if (arrayList == null) {
            PreviewIconsPanel.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public void showPreviewImages(@NotNull IconGeneratorResult iconGeneratorResult) {
        if (iconGeneratorResult == null) {
            PreviewIconsPanel.$$$reportNull$$$0(8);
        }
        Collection<GeneratedIcon> generatedIcons = iconGeneratorResult.getIcons();
        List<Pair<String, BufferedImage>> list = generatedIcons.stream().filter(icon -> icon instanceof GeneratedImageIcon && icon.getCategory() == IconCategory.PREVIEW).map(icon -> (GeneratedImageIcon)icon).sorted(Comparator.comparingInt(icon -> -icon.getDensity().getDpiValue())).map(icon -> Pair.of((Object)icon.getName(), (Object)icon.getImage())).collect(Collectors.toList());
        this.showPreviewImagesImpl(list);
    }

    protected void showPreviewImagesImpl(@NotNull List<Pair<String, BufferedImage>> images) {
        if (images == null) {
            PreviewIconsPanel.$$$reportNull$$$0(9);
        }
        this.initializeIconComponents(images.stream().map(Pair::getFirst).collect(Collectors.toList()));
        images.forEach(pair -> PreviewIconsPanel.showPreviewImageImpl(this.myIconImages.get(pair.getFirst()), (BufferedImage)pair.getSecond()));
    }

    private void initializeIconComponents(@NotNull List<String> labels) {
        int labelIndex;
        if (labels == null) {
            PreviewIconsPanel.$$$reportNull$$$0(10);
        }
        for (labelIndex = 0; labelIndex < labels.size(); ++labelIndex) {
            String label = labels.get(labelIndex);
            int iconIndex = this.findIconPanel(labelIndex, label);
            if (iconIndex < 0) {
                JPanel iconPanel = new JPanel((LayoutManager)new VerticalFlowLayout(false, false));
                iconPanel.setName("IconPanel");
                iconPanel.setBackground(this.myTheme.getMainColor());
                iconPanel.setOpaque(this.myTheme != Theme.TRANSPARENT);
                JBLabel title = new JBLabel(label);
                title.setForeground(this.myTheme.getAltColor());
                iconPanel.add((Component)title);
                ImageComponent iconImage = new ImageComponent(null);
                iconImage.setBorder((Border)new LineBorder(this.myTheme.getAltColor()));
                iconImage.setOpaque(false);
                iconPanel.add((Component)iconImage);
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 19;
                this.myIconsPanel.add(iconPanel, c, labelIndex);
                this.myIconImages.put(label, iconImage);
                continue;
            }
            for (int i2 = labelIndex; i2 < iconIndex; ++i2) {
                this.removeIconPanel(i2);
            }
        }
        assert (labelIndex == labels.size());
        assert (this.myIconsPanel.getComponentCount() >= labels.size());
        assert (this.myIconImages.size() == this.myIconsPanel.getComponentCount());
        while (this.myIconsPanel.getComponentCount() > labels.size()) {
            this.removeIconPanel(labels.size());
        }
    }

    private void removeIconPanel(int i2) {
        JPanel iconPanel = (JPanel)this.myIconsPanel.getComponent(i2);
        String iconLabel = ((JLabel)iconPanel.getComponent(0)).getText();
        this.myIconsPanel.remove(i2);
        this.myIconImages.remove(iconLabel);
    }

    private int findIconPanel(int startIndex, String label) {
        for (int i2 = startIndex; i2 < this.myIconsPanel.getComponentCount(); ++i2) {
            JPanel iconPanel = (JPanel)this.myIconsPanel.getComponent(i2);
            String iconLabel = ((JLabel)iconPanel.getComponent(0)).getText();
            if (!Objects.equals(label, iconLabel)) continue;
            return i2;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceImage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconGeneratorResult";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "images";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPreviewInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showPreviewImageImpl";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showPreviewImages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showPreviewImagesImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initializeIconComponents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setOpaque(true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.myIconsPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTitleLabel = jBLabel = new JBLabel();
        jBLabel.setText("(title)");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    public static enum Theme {
        DARK(Color.BLACK, Color.WHITE),
        LIGHT(Color.WHITE, Color.BLACK),
        GRAY(Color.DARK_GRAY, Color.LIGHT_GRAY),
        TRANSPARENT(UIUtil.TRANSPARENT_COLOR, (Color)JBColor.BLACK);

        private final Color myMainColor;
        private final Color myAltColor;

        private Theme(Color mainColor, Color altColor) {
            if (mainColor == null) {
                Theme.$$$reportNull$$$0(0);
            }
            if (altColor == null) {
                Theme.$$$reportNull$$$0(1);
            }
            this.myMainColor = mainColor;
            this.myAltColor = altColor;
        }

        @NotNull
        public Color getMainColor() {
            Color color = this.myMainColor;
            if (color == null) {
                Theme.$$$reportNull$$$0(2);
            }
            return color;
        }

        @NotNull
        public Color getAltColor() {
            Color color = this.myAltColor;
            if (color == null) {
                Theme.$$$reportNull$$$0(3);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mainColor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "altColor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel$Theme";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ui/PreviewIconsPanel$Theme";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMainColor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAltColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IconPreviewInfo {
        @Nullable
        private String myLabel;
        @Nullable
        private BufferedImage myImage;
        @Nullable
        private Border myImageBorder;
        private boolean myImageOpaque;
        @Nullable
        private Color myImageBackground;

        public void setLabel(@Nullable String label) {
            this.myLabel = label;
        }

        @Nullable
        public String getLabel() {
            return this.myLabel;
        }

        public void setImageBackground(@Nullable Color imageBackground) {
            this.myImageBackground = imageBackground;
        }

        @Nullable
        public Color getImageBackground() {
            return this.myImageBackground;
        }

        public void setImageOpaque(boolean imageOpaque) {
            this.myImageOpaque = imageOpaque;
        }

        public boolean isImageOpaque() {
            return this.myImageOpaque;
        }

        public void setImage(@Nullable BufferedImage image) {
            this.myImage = image;
        }

        @Nullable
        public BufferedImage getImage() {
            return this.myImage;
        }

        public void setImageBorder(@Nullable Border imageBorder) {
            this.myImageBorder = imageBorder;
        }

        @Nullable
        public Border getImageBorder() {
            return this.myImageBorder;
        }
    }
}

