/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.utils.SdkUtils;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public final class VectorAsset
extends BaseAsset {
    private static final String ERROR_EMPTY_PREVIEW = "Could not generate a preview";
    private final ObjectProperty<File> myPath = new ObjectValueProperty<File>(new File(System.getProperty("user.home")));
    private final BoolProperty myAutoMirrored = new BoolValueProperty();
    private final IntProperty myOutputWidth = new IntValueProperty();
    private final IntProperty myOutputHeight = new IntValueProperty();

    @NotNull
    public ObjectProperty<File> path() {
        ObjectProperty<File> objectProperty = this.myPath;
        if (objectProperty == null) {
            VectorAsset.$$$reportNull$$$0(0);
        }
        return objectProperty;
    }

    @NotNull
    public BoolProperty autoMirrored() {
        BoolProperty boolProperty = this.myAutoMirrored;
        if (boolProperty == null) {
            VectorAsset.$$$reportNull$$$0(1);
        }
        return boolProperty;
    }

    @NotNull
    public IntProperty outputWidth() {
        IntProperty intProperty = this.myOutputWidth;
        if (intProperty == null) {
            VectorAsset.$$$reportNull$$$0(2);
        }
        return intProperty;
    }

    @NotNull
    public IntProperty outputHeight() {
        IntProperty intProperty = this.myOutputHeight;
        if (intProperty == null) {
            VectorAsset.$$$reportNull$$$0(3);
        }
        return intProperty;
    }

    @NotNull
    public ParseResult parse(int previewWidth, boolean allowPropertyOverride) {
        boolean valid;
        Document document;
        File path = (File)this.myPath.get();
        if (!path.exists()) {
            ParseResult parseResult = new ParseResult("File " + path.getName() + " does not exist");
            if (parseResult == null) {
                VectorAsset.$$$reportNull$$$0(4);
            }
            return parseResult;
        }
        if (path.isDirectory()) {
            ParseResult parseResult = new ParseResult(new Validator.Result(Validator.Severity.WARNING, "Please select a file"));
            if (parseResult == null) {
                VectorAsset.$$$reportNull$$$0(5);
            }
            return parseResult;
        }
        String xmlFileContent = null;
        FileType fileType = FileType.fromFile(path);
        StringBuilder errorBuffer = new StringBuilder();
        try {
            switch (fileType) {
                case SVG: {
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    String errorLog = Svg2Vector.parseSvgToXml((File)path, (OutputStream)outStream);
                    errorBuffer.append(errorLog);
                    xmlFileContent = ((Object)outStream).toString();
                    break;
                }
                case LAYERED_IMAGE: {
                    xmlFileContent = new LayeredImageConverter().toVectorDrawableXml(path);
                    break;
                }
                case VECTOR_DRAWABLE: {
                    xmlFileContent = Files.toString((File)path, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
        catch (IOException e) {
            errorBuffer.append(e.getMessage());
        }
        BufferedImage image = null;
        float originalWidth = 0.0f;
        float originalHeight = 0.0f;
        if (!Strings.isNullOrEmpty((String)xmlFileContent) && (document = VdPreview.parseVdStringIntoDocument((String)xmlFileContent, (StringBuilder)(errorBuffer.length() == 0 ? errorBuffer : null))) != null) {
            String overriddenXml;
            VdPreview.SourceSize originalSize = VdPreview.getVdOriginalSize((Document)document);
            originalWidth = originalSize.getWidth();
            originalHeight = originalSize.getHeight();
            if (allowPropertyOverride && (overriddenXml = this.overrideXmlFileContent(document, originalSize, errorBuffer)) != null) {
                xmlFileContent = overriddenXml;
            }
            if (previewWidth <= 0) {
                previewWidth = (Integer)this.myOutputWidth.get() > 0 ? (Integer)this.myOutputWidth.get() : Math.round(originalWidth);
            }
            VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createFromMaxDimension((int)previewWidth);
            try {
                image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageTargetSize, (String)xmlFileContent, (StringBuilder)errorBuffer);
            }
            catch (Throwable e) {
                Logger.getInstance(this.getClass()).error(e);
            }
        }
        if (image == null) {
            if (errorBuffer.length() == 0) {
                errorBuffer.append(ERROR_EMPTY_PREVIEW);
            }
            ParseResult parseResult = new ParseResult(errorBuffer.toString());
            if (parseResult == null) {
                VectorAsset.$$$reportNull$$$0(6);
            }
            return parseResult;
        }
        boolean bl = valid = originalWidth > 0.0f && originalHeight > 0.0f;
        if (!valid && errorBuffer.length() == 0) {
            errorBuffer.append("The specified asset could not be parsed. Please choose another asset.");
        }
        Validator.Severity severity = !valid ? Validator.Severity.ERROR : (errorBuffer.length() == 0 ? Validator.Severity.OK : Validator.Severity.WARNING);
        Validator.Result messages = new Validator.Result(severity, errorBuffer.toString());
        ParseResult parseResult = new ParseResult(messages, image, originalWidth, originalHeight, xmlFileContent);
        if (parseResult == null) {
            VectorAsset.$$$reportNull$$$0(7);
        }
        return parseResult;
    }

    @NotNull
    public ParseResult parse() {
        ParseResult parseResult = this.parse(0, true);
        if (parseResult == null) {
            VectorAsset.$$$reportNull$$$0(8);
        }
        return parseResult;
    }

    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        return Futures.immediateFuture((Object)this.parse().getImage());
    }

    @Nullable
    private String overrideXmlFileContent(@NotNull Document document, @NotNull VdPreview.SourceSize originalSize, @NotNull StringBuilder errorBuffer) {
        if (document == null) {
            VectorAsset.$$$reportNull$$$0(9);
        }
        if (originalSize == null) {
            VectorAsset.$$$reportNull$$$0(10);
        }
        if (errorBuffer == null) {
            VectorAsset.$$$reportNull$$$0(11);
        }
        float finalWidth = originalSize.getWidth();
        float finalHeight = originalSize.getHeight();
        int outputWidth = (Integer)this.myOutputWidth.get();
        int outputHeight = (Integer)this.myOutputHeight.get();
        if (outputWidth > 0) {
            finalWidth = outputWidth;
        }
        if (outputHeight > 0) {
            finalHeight = outputHeight;
        }
        finalWidth = Math.max(1.0f, finalWidth);
        finalHeight = Math.max(1.0f, finalHeight);
        VdOverrideInfo overrideInfo = new VdOverrideInfo(finalWidth, finalHeight, (Color)this.color().getValueOrNull(), (float)((Integer)this.opacityPercent().get()).intValue() / 100.0f, ((Boolean)this.myAutoMirrored.get()).booleanValue());
        return VdPreview.overrideXmlContent((Document)document, (VdOverrideInfo)overrideInfo, (StringBuilder)errorBuffer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalSize";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "path";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "autoMirrored";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "outputWidth";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "outputHeight";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "overrideXmlFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FileType {
        SVG,
        LAYERED_IMAGE,
        VECTOR_DRAWABLE;


        @NotNull
        static FileType fromFile(@NotNull File file) {
            String path;
            if (file == null) {
                FileType.$$$reportNull$$$0(0);
            }
            if (SdkUtils.endsWithIgnoreCase((String)(path = file.getPath()), (String)".svg")) {
                FileType fileType = SVG;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(1);
                }
                return fileType;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".psd")) {
                FileType fileType = LAYERED_IMAGE;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(2);
                }
                return fileType;
            }
            FileType fileType = VECTOR_DRAWABLE;
            if (fileType == null) {
                FileType.$$$reportNull$$$0(3);
            }
            return fileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$FileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$FileType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ParseResult {
        @NotNull
        private final Validator.Result myValidityState;
        @Nullable
        private final BufferedImage myImage;
        private final float myOriginalWidth;
        private final float myOriginalHeight;
        private final boolean myIsValid;
        @NotNull
        private final String myXmlContent;

        public ParseResult(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ParseResult.$$$reportNull$$$0(0);
            }
            this(Validator.Result.fromNullableMessage((String)errorMessage));
        }

        public ParseResult(@NotNull Validator.Result validityState) {
            if (validityState == null) {
                ParseResult.$$$reportNull$$$0(1);
            }
            this(validityState, null, 0.0f, 0.0f, "");
        }

        public ParseResult(@NotNull Validator.Result validityState, @Nullable BufferedImage image, float originalWidth, float originalHeight, @NotNull String xmlContent) {
            if (validityState == null) {
                ParseResult.$$$reportNull$$$0(2);
            }
            if (xmlContent == null) {
                ParseResult.$$$reportNull$$$0(3);
            }
            this.myValidityState = validityState;
            this.myImage = image;
            this.myOriginalWidth = originalWidth;
            this.myOriginalHeight = originalHeight;
            this.myXmlContent = xmlContent;
            this.myIsValid = originalWidth > 0.0f && originalHeight > 0.0f;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        public float getOriginalWidth() {
            return this.myOriginalWidth;
        }

        public float getOriginalHeight() {
            return this.myOriginalHeight;
        }

        @NotNull
        public Validator.Result getValidityState() {
            Validator.Result result2 = this.myValidityState;
            if (result2 == null) {
                ParseResult.$$$reportNull$$$0(4);
            }
            return result2;
        }

        @Nullable
        public BufferedImage getImage() {
            return this.myImage;
        }

        @NotNull
        public String getXmlContent() {
            String string = this.myXmlContent;
            if (string == null) {
                ParseResult.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "validityState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlContent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValidityState";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getXmlContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

