/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.util.PathString;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.tools.lint.checks.ApiLookup;
import com.android.utils.CharSequences;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class IconGenerator
implements Disposable {
    protected static final ImmutableSet<Density> DENSITIES = ImmutableSet.of((Object)Density.MEDIUM, (Object)Density.HIGH, (Object)Density.XHIGH, (Object)Density.XXHIGH, (Object)Density.XXXHIGH);
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    protected static final BufferedImage PLACEHOLDER_IMAGE;
    private final OptionalProperty<BaseAsset> mySourceAsset;
    private final StringProperty myOutputName;
    protected final int myMinSdkVersion;
    @NotNull
    private final GraphicGeneratorContext myContext;
    @NotNull
    private final AtomicNullableLazyValue<ApiLookup> myApiLookup;
    @NotNull
    protected final String myLineSeparator;

    public IconGenerator(final @NotNull Project project, int minSdkVersion2, @NotNull GraphicGeneratorContext context) {
        if (project == null) {
            IconGenerator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(1);
        }
        this.mySourceAsset = new OptionalValueProperty<BaseAsset>();
        this.myOutputName = new StringValueProperty();
        this.myMinSdkVersion = minSdkVersion2;
        this.myContext = context;
        this.myApiLookup = new AtomicNullableLazyValue<ApiLookup>(){

            @Nullable
            protected ApiLookup compute() {
                return LintIdeClient.getApiLookup(project);
            }
        };
        this.myLineSeparator = CodeStyle.getSettings((Project)project).getLineSeparator();
    }

    public void dispose() {
    }

    @NotNull
    public GraphicGeneratorContext getGraphicGeneratorContext() {
        GraphicGeneratorContext graphicGeneratorContext = this.myContext;
        if (graphicGeneratorContext == null) {
            IconGenerator.$$$reportNull$$$0(2);
        }
        return graphicGeneratorContext;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        OptionalProperty<BaseAsset> optionalProperty = this.mySourceAsset;
        if (optionalProperty == null) {
            IconGenerator.$$$reportNull$$$0(3);
        }
        return optionalProperty;
    }

    @NotNull
    public final StringProperty outputName() {
        StringProperty stringProperty = this.myOutputName;
        if (stringProperty == null) {
            IconGenerator.$$$reportNull$$$0(4);
        }
        return stringProperty;
    }

    @NotNull
    public IconGeneratorResult generateIcons(Options options) {
        IconGeneratorResult iconGeneratorResult = new IconGeneratorResult(this.generateIcons(this.myContext, options, (String)this.myOutputName.get()), options);
        if (iconGeneratorResult == null) {
            IconGenerator.$$$reportNull$$$0(5);
        }
        return iconGeneratorResult;
    }

    @NotNull
    private CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        Options options = this.createOptions(false);
        CategoryIconMap categoryIconMap = this.generateIntoMemory(options);
        if (categoryIconMap == null) {
            IconGenerator.$$$reportNull$$$0(6);
        }
        return categoryIconMap;
    }

    @NotNull
    private CategoryIconMap generateIntoMemory(Options options) {
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generateRasterImage(null, categoryMap, this.myContext, options, (String)this.myOutputName.get());
        CategoryIconMap categoryIconMap = new CategoryIconMap(categoryMap);
        if (categoryIconMap == null) {
            IconGenerator.$$$reportNull$$$0(7);
        }
        return categoryIconMap;
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull File resDirectory) {
        if (resDirectory == null) {
            IconGenerator.$$$reportNull$$$0(8);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        if (resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        Map<File, BufferedImage> map2 = categoryIconMap.toFileMap(resDirectory.getParentFile());
        if (map2 == null) {
            IconGenerator.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    public Map<File, GeneratedIcon> generateIntoIconMap(@NotNull File resDirectory) {
        if (resDirectory == null) {
            IconGenerator.$$$reportNull$$$0(10);
        }
        Options options = this.createOptions(false);
        Map<File, GeneratedIcon> map2 = this.generateIntoIconMap(resDirectory, options);
        if (map2 == null) {
            IconGenerator.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIconPlaceholders(@NotNull File resDirectory) {
        if (resDirectory == null) {
            IconGenerator.$$$reportNull$$$0(12);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            Map<File, GeneratedIcon> map2 = Collections.emptyMap();
            if (map2 == null) {
                IconGenerator.$$$reportNull$$$0(13);
            }
            return map2;
        }
        Options options = this.createOptions(false);
        options.usePlaceholders = true;
        Map<File, GeneratedIcon> map3 = this.generateIntoIconMap(resDirectory, options);
        if (map3 == null) {
            IconGenerator.$$$reportNull$$$0(14);
        }
        return map3;
    }

    @NotNull
    private Map<File, GeneratedIcon> generateIntoIconMap(@NotNull File resDirectory, Options options) {
        if (resDirectory == null) {
            IconGenerator.$$$reportNull$$$0(15);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        if (resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        IconGeneratorResult icons = this.generateIcons(options);
        HashMap<File, GeneratedIcon> outputMap = new HashMap<File, GeneratedIcon>();
        icons.getIcons().forEach(icon -> {
            if (icon.getOutputPath() != null && icon.getCategory() != IconCategory.PREVIEW) {
                File path = new File(resDirectory.getParentFile(), icon.getOutputPath().getNativePath());
                outputMap.put(path, (GeneratedIcon)icon);
            }
        });
        HashMap<File, GeneratedIcon> hashMap = outputMap;
        if (hashMap == null) {
            IconGenerator.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    public void generateIconsToDisk(@NotNull AndroidModuleTemplate moduleTemplate) {
        File resDirectory;
        if (moduleTemplate == null) {
            IconGenerator.$$$reportNull$$$0(17);
        }
        if ((resDirectory = IconGenerator.getResDirectory(moduleTemplate)) != null) {
            this.generateIconsToDisk(resDirectory);
        }
    }

    public void generateIconsToDisk(@NotNull File resDirectory) {
        if (resDirectory == null) {
            IconGenerator.$$$reportNull$$$0(18);
        }
        Map<File, GeneratedIcon> pathIconMap = this.generateIntoIconMap(resDirectory);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry fileImageEntry : pathIconMap.entrySet()) {
                File file = (File)fileImageEntry.getKey();
                GeneratedIcon icon = (GeneratedIcon)fileImageEntry.getValue();
                if (icon instanceof GeneratedImageIcon) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"png")) {
                        this.writePngToDisk(file, ((GeneratedImageIcon)icon).getImage());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                if (icon instanceof GeneratedXmlResource) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"xml")) {
                        this.writeTextToDisk(file, ((GeneratedXmlResource)icon).getXmlText());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
            }
        });
    }

    private void writePngToDisk(@NotNull File file, @NotNull BufferedImage image) {
        if (file == null) {
            IconGenerator.$$$reportNull$$$0(19);
        }
        if (image == null) {
            IconGenerator.$$$reportNull$$$0(20);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeTextToDisk(@NotNull File file, @NotNull String text) {
        if (file == null) {
            IconGenerator.$$$reportNull$$$0(21);
        }
        if (text == null) {
            IconGenerator.$$$reportNull$$$0(22);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
                outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        List list;
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(23);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(24);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(25);
        }
        List<Callable<GeneratedIcon>> tasks = this.createIconGenerationTasks(context, options, name);
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        Disposable taskCanceler = () -> executor.cancelAllTasks();
        Disposer.register((Disposable)this, (Disposable)taskCanceler);
        tasks.forEach(arg_0 -> ((WaitableExecutor)executor).execute(arg_0));
        try {
            List list2 = executor.waitForTasksWithQuickFail(true);
            list = list2;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            Disposer.dispose((Disposable)taskCanceler);
        }
        if (list == null) {
            IconGenerator.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    protected List<Callable<GeneratedIcon>> createIconGenerationTasks(@NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        TransformedImageAsset image;
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(27);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(28);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(29);
        }
        if ((image = options.image) == null) {
            List<Callable<GeneratedIcon>> list = Collections.emptyList();
            if (list == null) {
                IconGenerator.$$$reportNull$$$0(30);
            }
            return list;
        }
        ArrayList<Callable<GeneratedIcon>> tasks = new ArrayList<Callable<GeneratedIcon>>();
        for (Density density : DENSITIES) {
            Density outputDensity;
            Options localOptions = options.clone();
            localOptions.density = density;
            Density density2 = outputDensity = density == Density.XXXHIGH && image.isDrawable() ? Density.ANYDPI : density;
            if (options.generateOutputIcons) {
                if (outputDensity == Density.ANYDPI) {
                    tasks.add(() -> {
                        Options iconOptions = options.clone();
                        iconOptions.density = Density.ANYDPI;
                        String xmlDrawableText = image.getTransformedDrawable();
                        assert (xmlDrawableText != null);
                        iconOptions.apiVersion = this.calculateMinRequiredApiLevel(xmlDrawableText, this.myMinSdkVersion);
                        return new GeneratedXmlResource(name, new PathString(this.getIconPath(iconOptions, name)), IconCategory.REGULAR, xmlDrawableText);
                    });
                } else {
                    tasks.add(() -> {
                        BufferedImage foregroundImage = this.generateRasterImage(context, localOptions);
                        return new GeneratedImageIcon(name, new PathString(this.getIconPath(localOptions, name)), IconCategory.REGULAR, density, foregroundImage);
                    });
                }
            }
            if (!options.generatePreviewIcons) continue;
            tasks.add(() -> {
                BufferedImage rasterImage = this.generateRasterImage(context, localOptions);
                return new GeneratedImageIcon(outputDensity.getResourceValue(), null, IconCategory.PREVIEW, density, rasterImage);
            });
        }
        ArrayList<Callable<GeneratedIcon>> arrayList = tasks;
        if (arrayList == null) {
            IconGenerator.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public abstract BufferedImage generateRasterImage(@NotNull GraphicGeneratorContext var1, @NotNull Options var2);

    @NotNull
    protected BufferedImage generateRasterImage(@NotNull Dimension iconSize, @NotNull Options options) {
        if (iconSize == null) {
            IconGenerator.$$$reportNull$$$0(32);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(33);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                IconGenerator.$$$reportNull$$$0(34);
            }
            return bufferedImage;
        }
        double scaleFactor = IconGenerator.getMdpiScaleFactor(options.density);
        Dimension imageSize = AssetStudioUtils.scaleDimension(iconSize, scaleFactor);
        TransformedImageAsset imageAsset = options.image;
        BufferedImage bufferedImage = imageAsset == null ? PLACEHOLDER_IMAGE : imageAsset.getTransformedImage(imageSize);
        if (bufferedImage == null) {
            IconGenerator.$$$reportNull$$$0(35);
        }
        return bufferedImage;
    }

    @NotNull
    public abstract Options createOptions(boolean var1);

    @NotNull
    protected String getIconPath(@NotNull Options options, @NotNull String iconName) {
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(36);
        }
        if (iconName == null) {
            IconGenerator.$$$reportNull$$$0(37);
        }
        String string = this.getIconFolder(options) + '/' + IconGenerator.getIconFileName(options, iconName);
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static String getIconFileName(@NotNull Options options, @NotNull String iconName) {
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(39);
        }
        if (iconName == null) {
            IconGenerator.$$$reportNull$$$0(40);
        }
        if (options.density == Density.ANYDPI) {
            String string = iconName + ".xml";
            if (string == null) {
                IconGenerator.$$$reportNull$$$0(41);
            }
            return string;
        }
        String string = iconName + ".png";
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    protected String getIconFolder(@NotNull Options options) {
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(43);
        }
        switch (options.iconFolderKind) {
            case DRAWABLE: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, options.density, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(44);
                }
                return string;
            }
            case MIPMAP: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.MIPMAP, options.density, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(45);
                }
                return string;
            }
            case DRAWABLE_NO_DPI: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, Density.NODPI, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(46);
                }
                return string;
            }
            case VALUES: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.VALUES, Density.NODPI, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(47);
                }
                return string;
            }
        }
        throw new IllegalArgumentException("Unexpected folder kind: " + (Object)((Object)options.iconFolderKind));
    }

    @NotNull
    private static String getIconFolder(@NotNull ResourceFolderType folderType, @NotNull Density density, int apiVersion) {
        if (folderType == null) {
            IconGenerator.$$$reportNull$$$0(48);
        }
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(49);
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append("res");
        buf.append('/');
        buf.append(folderType.getName());
        if (density != Density.NODPI) {
            buf.append('-');
            buf.append(density.getResourceValue());
        }
        if (apiVersion > 1) {
            buf.append("-v");
            buf.append(apiVersion);
        }
        String string = buf.toString();
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(50);
        }
        return string;
    }

    public void generateRasterImage(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        if (categoryMap == null) {
            IconGenerator.$$$reportNull$$$0(51);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(52);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(53);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(54);
        }
        if (options.density == Density.ANYDPI) {
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
            return;
        }
        Density[] densityValues = Density.values();
        Arrays.sort(densityValues, Comparator.comparingInt(Density::getDpiValue));
        for (Density density : densityValues) {
            if (!density.isValidValueForDevice() || !this.includeDensity(density)) continue;
            options.density = density;
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
        }
    }

    private void generateImageAndUpdateMap(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        if (categoryMap == null) {
            IconGenerator.$$$reportNull$$$0(55);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(56);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(57);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(58);
        }
        BufferedImage image = this.generateRasterImage(context, options);
        String mapCategory = category;
        if (mapCategory == null) {
            mapCategory = options.density.getResourceValue();
        }
        Map imageMap = categoryMap.computeIfAbsent(mapCategory, k -> new LinkedHashMap());
        imageMap.put(this.getIconPath(options, name), image);
    }

    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(59);
        }
        return density.isRecommended() && density != Density.LOW;
    }

    public static double getMdpiScaleFactor(@NotNull Density density) {
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(60);
        }
        if (density == Density.ANYDPI) {
            density = Density.XXXHIGH;
        }
        if (density == Density.NODPI) {
            density = Density.MEDIUM;
        }
        return (double)density.getDpiValue() / (double)Density.MEDIUM.getDpiValue();
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        if (iconPath == null) {
            IconGenerator.$$$reportNull$$$0(61);
        }
        iconPath = FileUtils.toSystemIndependentPath((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    protected int calculateMinRequiredApiLevel(@NotNull String xmlDrawableText, int minSdk) {
        ApiLookup apiLookup;
        if (xmlDrawableText == null) {
            IconGenerator.$$$reportNull$$$0(62);
        }
        if ((apiLookup = (ApiLookup)this.myApiLookup.getValue()) == null) {
            return 0;
        }
        KXmlParser parser = new KXmlParser();
        int requiredApiLevel = 0;
        try {
            int type;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)xmlDrawableText, (boolean)true));
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                for (int i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                    int attributeApiLevel;
                    String attributeName;
                    if (!"http://schemas.android.com/apk/res/android".equals(parser.getAttributeNamespace(i2)) || (attributeName = parser.getAttributeName(i2)).equals("fillType") || requiredApiLevel >= (attributeApiLevel = apiLookup.getFieldVersion("android/R$attr", attributeName))) continue;
                    requiredApiLevel = attributeApiLevel;
                }
            }
        }
        catch (IOException | XmlPullParserException throwable) {
            // empty catch block
        }
        return requiredApiLevel > minSdk && requiredApiLevel > 21 ? requiredApiLevel : 0;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(IconGenerator.class);
        if (logger == null) {
            IconGenerator.$$$reportNull$$$0(63);
        }
        return logger;
    }

    @Nullable
    public static File getResDirectory(@NotNull AndroidModuleTemplate template) {
        if (template == null) {
            IconGenerator.$$$reportNull$$$0(64);
        }
        return (File)Iterables.getLast(template.getResDirectories(), null);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
        PLACEHOLDER_IMAGE = AssetStudioUtils.createDummyImage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 23: 
            case 27: 
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/IconGenerator";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDirectory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTemplate";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: 
            case 28: 
            case 33: 
            case 36: 
            case 39: 
            case 43: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 25: 
            case 29: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconSize";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 49: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawableText";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/IconGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphicGeneratorContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceAsset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "outputName";
                break;
            }
            case 5: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoMemory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoFileMap";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoIconMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconPlaceholders";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconGenerationTasks";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRasterImage";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFileName";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFolder";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 63: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoFileMap";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoIconMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateIconPlaceholders";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generateIconsToDisk";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writePngToDisk";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeTextToDisk";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createIconGenerationTasks";
                break;
            }
            case 32: 
            case 33: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "generateRasterImage";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIconFileName";
                break;
            }
            case 43: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getIconFolder";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "generateImageAndUpdateMap";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getMdpiScaleFactor";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "pathToDensity";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinRequiredApiLevel";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getResDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 26: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 50: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Style {
        SIMPLE("fore1");

        public final String id;

        private Style(String id) {
            this.id = id;
        }
    }

    public static enum Shape {
        NONE("none"),
        CIRCLE("circle"),
        SQUARE("square"),
        VRECT("vrect"),
        HRECT("hrect"),
        SQUARE_DOG("square_dogear"),
        VRECT_DOG("vrect_dogear"),
        HRECT_DOG("hrect_dogear");

        public final String id;

        private Shape(String id) {
            this.id = id;
        }
    }

    public static enum IconFolderKind {
        DRAWABLE,
        DRAWABLE_NO_DPI,
        MIPMAP,
        VALUES;

    }

    public static class Options
    implements Cloneable {
        public boolean generateOutputIcons;
        public boolean generatePreviewIcons;
        @Nullable
        public TransformedImageAsset image;
        @Nullable
        public ListenableFuture<BufferedImage> sourceImageFuture;
        public boolean isTrimmed;
        public int paddingPercent;
        @NotNull
        public IconFolderKind iconFolderKind = IconFolderKind.DRAWABLE;
        @NotNull
        public Density density = Density.XHIGH;
        public int apiVersion;
        public boolean usePlaceholders;

        public Options(boolean forPreview) {
            this.generatePreviewIcons = forPreview;
            this.generateOutputIcons = !forPreview;
        }

        @NotNull
        public Options clone() {
            Options options;
            try {
                options = (Options)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error(e);
            }
            if (options == null) {
                Options.$$$reportNull$$$0(0);
            }
            return options;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/IconGenerator$Options", "clone"));
        }
    }
}

