/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.BuiltInImages;
import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.utils.Pair;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphicGeneratorContext {
    private final Cache<Object, ListenableFuture<BufferedImage>> myImageCache;
    private final DrawableRenderer myDrawableRenderer;

    public GraphicGeneratorContext(int maxCacheSize) {
        this(maxCacheSize, null);
    }

    public GraphicGeneratorContext(int maxCacheSize, @Nullable DrawableRenderer drawableRenderer) {
        this.myImageCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).build();
        this.myDrawableRenderer = drawableRenderer;
    }

    @NotNull
    public final ListenableFuture<BufferedImage> getFromCacheOrCreate(@NotNull Object key, @NotNull Callable<? extends ListenableFuture<BufferedImage>> creator) {
        ListenableFuture listenableFuture;
        if (key == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(0);
        }
        if (creator == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(1);
        }
        try {
            listenableFuture = (ListenableFuture)this.myImageCache.get(key, creator);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.getLog().error(cause);
            ListenableFuture listenableFuture2 = Futures.immediateFailedFuture((Throwable)cause);
            if (listenableFuture2 == null) {
                GraphicGeneratorContext.$$$reportNull$$$0(3);
            }
            return listenableFuture2;
        }
        if (listenableFuture == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(2);
        }
        return listenableFuture;
    }

    @Nullable
    public BufferedImage loadImageResource(@NotNull String path) {
        if (path == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(4);
        }
        try {
            ListenableFuture<BufferedImage> imageFuture = this.getFromCacheOrCreate(path, () -> GraphicGeneratorContext.getStencilImage(path));
            return (BufferedImage)imageFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.getLog().error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public ListenableFuture<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
        if (xmlDrawableText == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(5);
        }
        if (size == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(6);
        }
        Pair key = Pair.of((Object)xmlDrawableText, (Object)size);
        Callable<ListenableFuture> renderer = this.myDrawableRenderer == null ? () -> GraphicGeneratorContext.renderVectorDrawable(xmlDrawableText, size) : () -> this.myDrawableRenderer.renderDrawable(xmlDrawableText, size);
        ListenableFuture<BufferedImage> listenableFuture = this.getFromCacheOrCreate(key, renderer);
        if (listenableFuture == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(7);
        }
        return listenableFuture;
    }

    @NotNull
    private static ListenableFuture<BufferedImage> renderVectorDrawable(@NotNull String vectorDrawableText, @NotNull Dimension size) {
        VdPreview.TargetSize targetSize;
        BufferedImage image;
        if (vectorDrawableText == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(8);
        }
        if (size == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(9);
        }
        if ((image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)(targetSize = VdPreview.TargetSize.createFromMaxDimension((int)Math.max(size.width, size.height))), (String)vectorDrawableText, null)) == null) {
            image = AssetStudioUtils.createDummyImage();
        }
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)image);
        if (listenableFuture == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(10);
        }
        return listenableFuture;
    }

    @NotNull
    private static ListenableFuture<BufferedImage> getStencilImage(@NotNull String path) throws IOException {
        BufferedImage image;
        if (path == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(11);
        }
        if ((image = BuiltInImages.getStencilImage(path)) == null) {
            image = AssetStudioUtils.createDummyImage();
        }
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)image);
        if (listenableFuture == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(12);
        }
        return listenableFuture;
    }

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            GraphicGeneratorContext.$$$reportNull$$$0(13);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/GraphicGeneratorContext";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawableText";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vectorDrawableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/GraphicGeneratorContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromCacheOrCreate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "renderVectorDrawable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStencilImage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFromCacheOrCreate";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadImageResource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "renderDrawable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderVectorDrawable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStencilImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

