/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.io.FileOpUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class PathValidationResult {
    public static final PathValidationResult OK = new PathValidationResult(Status.OK, null, "any", new Object[0]);
    private static final CharMatcher ILLEGAL_CHARACTER_MATCHER = CharMatcher.anyOf((CharSequence)"[/\\\\?%*:|\"<>!;]");
    private static final Set<String> INVALID_WINDOWS_FILENAMES = ImmutableSet.of((Object)"con", (Object)"prn", (Object)"aux", (Object)"clock$", (Object)"nul", (Object)"com1", (Object[])new String[]{"com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "$mft", "$mftmirr", "$logfile", "$volume", "$attrdef", "$bitmap", "$boot", "$badclus", "$secure", "$upcase", "$extend", "$quota", "$objid", "$reparse"});
    private static final int WINDOWS_PATH_LENGTH_LIMIT = 100;
    private final Status myStatus;
    private final Message myMessage;
    private final Object[] myMessageParams;

    public static PathValidationResult warn(@NotNull Message message, String field2, Object ... params) {
        if (message == null) {
            PathValidationResult.$$$reportNull$$$0(0);
        }
        return new PathValidationResult(Status.WARN, message, field2, params);
    }

    public static PathValidationResult error(@NotNull Message message, String field2, Object ... params) {
        if (message == null) {
            PathValidationResult.$$$reportNull$$$0(1);
        }
        return new PathValidationResult(Status.ERROR, message, field2, params);
    }

    @NotNull
    public static PathValidationResult validateLocation(@Nullable String projectLocation) {
        PathValidationResult pathValidationResult = PathValidationResult.validateLocation(projectLocation, "project location", true);
        if (pathValidationResult == null) {
            PathValidationResult.$$$reportNull$$$0(2);
        }
        return pathValidationResult;
    }

    @NotNull
    public static PathValidationResult validateLocation(@Nullable String projectLocation, @NotNull String fieldName, boolean checkEmpty) {
        if (fieldName == null) {
            PathValidationResult.$$$reportNull$$$0(3);
        }
        PathValidationResult pathValidationResult = PathValidationResult.validateLocation(projectLocation, fieldName, checkEmpty, WritableCheckMode.NOT_WRITABLE_IS_ERROR);
        if (pathValidationResult == null) {
            PathValidationResult.$$$reportNull$$$0(4);
        }
        return pathValidationResult;
    }

    @NotNull
    public static PathValidationResult validateLocation(@Nullable String projectLocation, @NotNull String fieldName, boolean checkEmpty, @NotNull WritableCheckMode writableCheckMode) {
        if (fieldName == null) {
            PathValidationResult.$$$reportNull$$$0(5);
        }
        if (writableCheckMode == null) {
            PathValidationResult.$$$reportNull$$$0(6);
        }
        PathValidationResult warningResult = null;
        if (projectLocation == null || projectLocation.isEmpty()) {
            PathValidationResult pathValidationResult = PathValidationResult.error(Message.NO_LOCATION_SPECIFIED, fieldName, new Object[0]);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(7);
            }
            return pathValidationResult;
        }
        if (File.separatorChar == '/' && projectLocation.contains("\\") || File.separatorChar == '\\' && projectLocation.contains("/")) {
            PathValidationResult pathValidationResult = PathValidationResult.error(Message.BAD_SLASHES, fieldName, new Object[0]);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(8);
            }
            return pathValidationResult;
        }
        File testFile = new File(projectLocation);
        while (testFile != null) {
            String filename = testFile.getName();
            if (ILLEGAL_CHARACTER_MATCHER.matchesAnyOf((CharSequence)filename)) {
                char illegalChar = filename.charAt(ILLEGAL_CHARACTER_MATCHER.indexIn((CharSequence)filename));
                PathValidationResult pathValidationResult = PathValidationResult.error(Message.ILLEGAL_CHARACTER, fieldName, Character.valueOf(illegalChar), filename);
                if (pathValidationResult == null) {
                    PathValidationResult.$$$reportNull$$$0(9);
                }
                return pathValidationResult;
            }
            if (INVALID_WINDOWS_FILENAMES.contains(StringUtil.toLowerCase((String)filename))) {
                Status status = SystemInfo.isWindows ? Status.ERROR : Status.WARN;
                PathValidationResult pathValidationResult = new PathValidationResult(status, Message.ILLEGAL_FILENAME, fieldName, filename);
                if (pathValidationResult == null) {
                    PathValidationResult.$$$reportNull$$$0(10);
                }
                return pathValidationResult;
            }
            if (CharMatcher.whitespace().matchesAnyOf((CharSequence)filename)) {
                warningResult = PathValidationResult.warn(Message.WHITESPACE, fieldName, new Object[0]);
            }
            if (!CharMatcher.ascii().matchesAllOf((CharSequence)filename)) {
                if (SystemInfo.isWindows) {
                    PathValidationResult pathValidationResult = PathValidationResult.error(Message.NON_ASCII_CHARS_ERROR, fieldName, new Object[0]);
                    if (pathValidationResult == null) {
                        PathValidationResult.$$$reportNull$$$0(11);
                    }
                    return pathValidationResult;
                }
                warningResult = PathValidationResult.warn(Message.NON_ASCII_CHARS_WARNING, fieldName, new Object[0]);
            }
            File parent = testFile.getParentFile();
            if (!writableCheckMode.equals((Object)WritableCheckMode.DO_NOT_CHECK) && !testFile.exists() && parent != null && parent.exists() && !parent.canWrite()) {
                PathValidationResult pathValidationResult = PathValidationResult.pathNotWritable(WritableCheckMode.NOT_WRITABLE_IS_ERROR, fieldName, parent);
                if (pathValidationResult == null) {
                    PathValidationResult.$$$reportNull$$$0(12);
                }
                return pathValidationResult;
            }
            testFile = parent;
        }
        if (SystemInfo.isWindows && projectLocation.length() > 100) {
            PathValidationResult pathValidationResult = PathValidationResult.error(Message.PATH_TOO_LONG, fieldName, new Object[0]);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(13);
            }
            return pathValidationResult;
        }
        File file = new File(projectLocation);
        if (file.isFile()) {
            PathValidationResult pathValidationResult = PathValidationResult.error(Message.PROJECT_LOC_IS_FILE, fieldName, new Object[0]);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(14);
            }
            return pathValidationResult;
        }
        if (file.getParent() == null) {
            PathValidationResult pathValidationResult = PathValidationResult.error(Message.PROJECT_IS_FILE_SYSTEM_ROOT, fieldName, new Object[0]);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(15);
            }
            return pathValidationResult;
        }
        if (file.getParentFile().exists() && !file.getParentFile().isDirectory()) {
            PathValidationResult pathValidationResult = PathValidationResult.error(Message.PARENT_NOT_DIR, fieldName, new Object[0]);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(16);
            }
            return pathValidationResult;
        }
        if (!writableCheckMode.equals((Object)WritableCheckMode.DO_NOT_CHECK) && file.exists() && !file.canWrite()) {
            PathValidationResult pathValidationResult = PathValidationResult.pathNotWritable(writableCheckMode, fieldName, file);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(17);
            }
            return pathValidationResult;
        }
        String installLocation = PathManager.getHomePathFor(Application.class);
        if (installLocation != null && FileUtil.isAncestor((File)new File(installLocation), (File)file, (boolean)false)) {
            String applicationName = ApplicationNamesInfo.getInstance().getProductName();
            PathValidationResult pathValidationResult = PathValidationResult.error(Message.INSIDE_ANDROID_STUDIO, fieldName, applicationName);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(18);
            }
            return pathValidationResult;
        }
        if (checkEmpty && file.exists() && FileOpUtils.create().listFiles(file).length > 0) {
            PathValidationResult pathValidationResult = PathValidationResult.warn(Message.NON_EMPTY_DIR, fieldName, new Object[0]);
            if (pathValidationResult == null) {
                PathValidationResult.$$$reportNull$$$0(19);
            }
            return pathValidationResult;
        }
        PathValidationResult pathValidationResult = warningResult == null ? OK : warningResult;
        if (pathValidationResult == null) {
            PathValidationResult.$$$reportNull$$$0(20);
        }
        return pathValidationResult;
    }

    private PathValidationResult(@NotNull Status status, @Nullable Message message, @NotNull String field2, Object ... messageParams) {
        if (status == null) {
            PathValidationResult.$$$reportNull$$$0(21);
        }
        if (field2 == null) {
            PathValidationResult.$$$reportNull$$$0(22);
        }
        this.myStatus = status;
        this.myMessage = message;
        this.myMessageParams = ArrayUtil.prepend((Object)field2, (Object[])messageParams);
    }

    @NotNull
    private static PathValidationResult pathNotWritable(@NotNull WritableCheckMode mode, @NotNull String field2, @NotNull File file) {
        if (mode == null) {
            PathValidationResult.$$$reportNull$$$0(23);
        }
        if (field2 == null) {
            PathValidationResult.$$$reportNull$$$0(24);
        }
        if (file == null) {
            PathValidationResult.$$$reportNull$$$0(25);
        }
        switch (mode) {
            case NOT_WRITABLE_IS_ERROR: {
                PathValidationResult pathValidationResult = PathValidationResult.error(Message.PATH_NOT_WRITABLE, field2, file.getPath());
                if (pathValidationResult == null) {
                    PathValidationResult.$$$reportNull$$$0(26);
                }
                return pathValidationResult;
            }
            case NOT_WRITABLE_IS_WARNING: {
                PathValidationResult pathValidationResult = PathValidationResult.warn(Message.PATH_NOT_WRITABLE, field2, file.getPath());
                if (pathValidationResult == null) {
                    PathValidationResult.$$$reportNull$$$0(27);
                }
                return pathValidationResult;
            }
        }
        throw new IllegalArgumentException(mode.toString());
    }

    public String getFormattedMessage() {
        if (this.myMessage == null) {
            throw new IllegalStateException("Null message, are you trying to get the message of an OK?");
        }
        return String.format(this.myMessage.toString(), this.myMessageParams);
    }

    @NotNull
    public Status getStatus() {
        Status status = this.myStatus;
        if (status == null) {
            PathValidationResult.$$$reportNull$$$0(28);
        }
        return status;
    }

    public boolean isError() {
        return this.myStatus.equals((Object)Status.ERROR);
    }

    public boolean isOk() {
        return this.myStatus.equals((Object)Status.OK);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/PathValidationResult";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writableCheckMode";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/PathValidationResult";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "validateLocation";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "pathNotWritable";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateLocation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "pathNotWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum WritableCheckMode {
        DO_NOT_CHECK,
        NOT_WRITABLE_IS_ERROR,
        NOT_WRITABLE_IS_WARNING;

    }

    public static enum Message {
        NO_LOCATION_SPECIFIED("Please specify a %1$s"),
        BAD_SLASHES("Your %1$s contains incorrect slashes ('\\' vs '/')"),
        ILLEGAL_CHARACTER("Illegal character in %1$s path: '%2$c' in filename %3s"),
        ILLEGAL_FILENAME("Illegal filename in %1$s path: %2$s"),
        WHITESPACE("%1$s should not contain whitespace, as this can cause problems with the NDK tools."),
        NON_ASCII_CHARS_WARNING("Your %1$s contains non-ASCII characters, which can cause problems. Proceed with caution."),
        NON_ASCII_CHARS_ERROR("Your %1$s contains non-ASCII characters."),
        PATH_NOT_WRITABLE("The path '%2$s' is not writable. Please choose a new location."),
        PROJECT_LOC_IS_FILE("There must not already be a file at the %1$s."),
        NON_EMPTY_DIR("A non-empty directory already exists at the specified %1$s. Existing files may be overwritten. Proceed with caution."),
        PROJECT_IS_FILE_SYSTEM_ROOT("The %1$s can not be at the filesystem root"),
        PARENT_NOT_DIR("The %1$s's parent directory must be a directory, not a plain file"),
        INSIDE_ANDROID_STUDIO("The %1$s is inside %2$s install location"),
        PATH_TOO_LONG("The %1$s is too long");

        private final String myText;

        private Message(String text) {
            this.myText = text;
        }

        public String toString() {
            return this.myText;
        }
    }

    public static enum Status {
        OK,
        WARN,
        ERROR;

    }
}

