/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.intellij.openapi.application.Application;
import org.jetbrains.annotations.NotNull;

public abstract class AsyncValidator<V> {
    @NotNull
    private final Application myApplication;
    private final ResultReporter myResultReporter;
    private boolean myIsDirty;
    private boolean myIsScheduled;

    public AsyncValidator(@NotNull Application application) {
        if (application == null) {
            AsyncValidator.$$$reportNull$$$0(0);
        }
        this.myResultReporter = new ResultReporter();
        this.myIsDirty = false;
        this.myIsScheduled = false;
        this.myApplication = application;
    }

    public final synchronized void invalidate() {
        this.myIsDirty = true;
        this.myResultReporter.setDirty();
        if (!this.myIsScheduled) {
            this.myIsScheduled = true;
            this.myApplication.executeOnPooledThread(this::revalidateUntilClean);
        }
    }

    private void revalidateUntilClean() {
        V result2;
        do {
            this.markClean();
        } while (!this.submit(result2 = this.validate()));
    }

    private synchronized boolean submit(@NotNull V result2) {
        if (result2 == null) {
            AsyncValidator.$$$reportNull$$$0(1);
        }
        this.myIsScheduled = this.myIsDirty;
        if (!this.myIsScheduled) {
            this.myResultReporter.report(result2);
            return true;
        }
        return false;
    }

    private synchronized void markClean() {
        this.myIsDirty = false;
    }

    protected abstract void showValidationResult(@NotNull V var1);

    @NotNull
    protected abstract V validate();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/npw/AsyncValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "submit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class ResultReporter
    implements Runnable {
        private V myResult = null;
        private boolean myIsPending = false;

        private ResultReporter() {
        }

        public synchronized void report(@NotNull V value2) {
            if (value2 == null) {
                ResultReporter.$$$reportNull$$$0(0);
            }
            this.myResult = value2;
            if (!this.myIsPending) {
                this.myIsPending = true;
                AsyncValidator.this.myApplication.invokeLater((Runnable)this, AsyncValidator.this.myApplication.getAnyModalityState());
            }
        }

        @Override
        public synchronized void run() {
            Object result2 = this.myResult;
            this.myResult = null;
            try {
                if (result2 != null) {
                    AsyncValidator.this.showValidationResult(result2);
                }
            }
            finally {
                this.myIsPending = false;
            }
        }

        public synchronized void setDirty() {
            this.myResult = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/npw/AsyncValidator$ResultReporter", "report"));
        }
    }
}

