/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.IncludeSet;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.IncludeViewNodes;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingViewNode
extends IncludeViewNode<PackageValue> {
    protected PackagingViewNode(@NotNull VirtualFile buildFileFolder, @NotNull IncludeSet includeFolders, @Nullable Project project, @NotNull PackageValue dependency, @NotNull ViewSettings viewSettings, boolean showPackageType) {
        if (buildFileFolder == null) {
            PackagingViewNode.$$$reportNull$$$0(0);
        }
        if (includeFolders == null) {
            PackagingViewNode.$$$reportNull$$$0(1);
        }
        if (dependency == null) {
            PackagingViewNode.$$$reportNull$$$0(2);
        }
        if (viewSettings == null) {
            PackagingViewNode.$$$reportNull$$$0(3);
        }
        super(buildFileFolder, dependency, includeFolders, showPackageType, project, viewSettings);
    }

    @NotNull
    private PackageValue getPackageValue() {
        PackageValue value2 = (PackageValue)this.getValue();
        assert (value2 != null);
        PackageValue packageValue = value2;
        if (packageValue == null) {
            PackagingViewNode.$$$reportNull$$$0(4);
        }
        return packageValue;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Project project = this.getProject();
        if (project == null) {
            List list = Collections.EMPTY_LIST;
            if (list == null) {
                PackagingViewNode.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<File> folders = new ArrayList<File>();
        ArrayList<SimpleIncludeValue> result2 = new ArrayList<SimpleIncludeValue>();
        PackageValue value2 = this.getPackageValue();
        for (File folder : this.myIncludeFolders.getIncludesInOrder()) {
            for (SimpleIncludeValue simpleIncludeValue : value2.myIncludes) {
                if (!FileUtil.filesEqual((File)simpleIncludeValue.myIncludeFolder, (File)folder)) continue;
                result2.add(simpleIncludeValue);
            }
        }
        for (SimpleIncludeValue child : result2) {
            folders.add(child.myIncludeFolder);
        }
        Collection<AbstractTreeNode> collection = IncludeViewNodes.getIncludeFolderNodesWithShadowing(folders, (ImmutableList<VirtualFile>)ImmutableList.of(), true, project, this.getSettings());
        if (collection == null) {
            PackagingViewNode.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    protected void writeDescription(@NotNull PresentationDataWrapper presentation) {
        if (presentation == null) {
            PackagingViewNode.$$$reportNull$$$0(7);
        }
        presentation.setIcon(AllIcons.Nodes.JavaModuleRoot);
        PackageValue value2 = this.getPackageValue();
        presentation.addText(value2.getSimplePackageName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowPackageType) {
            presentation.addText(String.format(" (%s, ", this.getPackageValue().getPackageType().myDescription), SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            presentation.addText(" (", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.addText(String.format("%s)", this.getPackageValue().getDescriptiveText()), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            PackagingViewNode.$$$reportNull$$$0(8);
        }
        if (!LexicalIncludePaths.hasHeaderExtension(file.getName())) {
            return false;
        }
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        PackageValue value2 = this.getPackageValue();
        for (SimpleIncludeValue include : value2.myIncludes) {
            VirtualFile ancestor = fileSystem.findFileByIoFile(include.myIncludeFolder);
            if (ancestor == null || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileFolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFolders";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/PackagingViewNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/PackagingViewNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeDescription";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

