/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PsiIncludeDirectoryView;
import com.android.tools.idea.util.VirtualFiles;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class IncludeViewNodes {
    @NotNull
    public static Collection<AbstractTreeNode> getIncludeFolderNodesWithShadowing(@NotNull Collection<File> includes, @NotNull ImmutableList<VirtualFile> excludesVirtualFiles, boolean folderParentIsObvious, @NotNull Project project, @NotNull ViewSettings settings) {
        if (includes == null) {
            IncludeViewNodes.$$$reportNull$$$0(0);
        }
        if (excludesVirtualFiles == null) {
            IncludeViewNodes.$$$reportNull$$$0(1);
        }
        if (project == null) {
            IncludeViewNodes.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            IncludeViewNodes.$$$reportNull$$$0(3);
        }
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        HashSet baseNameSeenAlready = new HashSet();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File include : includes) {
            PsiDirectory psiDirectory;
            VirtualFile folder = fileSystem.findFileByIoFile(include);
            if (folder == null || (psiDirectory = psiManager.findDirectory(folder)) == null) continue;
            psiDirectory.processChildren(element -> {
                if (VirtualFiles.isElementAncestorOfExclude(element, excludesVirtualFiles)) {
                    return true;
                }
                if (baseNameSeenAlready.contains(element.getName())) {
                    return true;
                }
                baseNameSeenAlready.add(element.getName());
                if (element instanceof PsiDirectory) {
                    PsiDirectory concrete = (PsiDirectory)element;
                    PsiIncludeDirectoryView node = new PsiIncludeDirectoryView(project, excludesVirtualFiles, folderParentIsObvious, concrete, settings);
                    if (!node.getChildren().isEmpty()) {
                        result2.add((AbstractTreeNode)node);
                    }
                    return true;
                }
                if (element instanceof PsiFile) {
                    PsiFile concrete = (PsiFile)element;
                    if (!LexicalIncludePaths.hasHeaderExtension(concrete.getName())) {
                        return true;
                    }
                    result2.add((AbstractTreeNode)new PsiFileNode(project, concrete, settings));
                    return true;
                }
                return true;
            });
        }
        ArrayList<AbstractTreeNode> arrayList = result2;
        if (arrayList == null) {
            IncludeViewNodes.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludesVirtualFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/IncludeViewNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/IncludeViewNodes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludeFolderNodesWithShadowing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeFolderNodesWithShadowing";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

