/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.view;

import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.ClassifiedIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageFamilyValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.IncludeSet;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapper;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.PresentationDataWrapperKt;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PackagingFamilyViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.PackagingViewNode;
import com.android.tools.idea.navigator.nodes.ndk.includes.view.SimpleIncludeViewNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncludeViewNode<T extends ClassifiedIncludeValue>
extends ProjectViewNode<T>
implements FolderGroupNode {
    @NotNull
    protected final VirtualFile myBuildFileFolder;
    private String myDescription;
    private int myHashCode;
    @NotNull
    protected final IncludeSet myIncludeFolders;
    protected final boolean myShowPackageType;

    protected IncludeViewNode(@NotNull VirtualFile buildFileFolder, @NotNull T thisInclude, @NotNull IncludeSet allIncludes, boolean showPackageType, @Nullable Project project, @NotNull ViewSettings viewSettings) {
        if (buildFileFolder == null) {
            IncludeViewNode.$$$reportNull$$$0(0);
        }
        if (thisInclude == null) {
            IncludeViewNode.$$$reportNull$$$0(1);
        }
        if (allIncludes == null) {
            IncludeViewNode.$$$reportNull$$$0(2);
        }
        if (viewSettings == null) {
            IncludeViewNode.$$$reportNull$$$0(3);
        }
        super(project, thisInclude, viewSettings);
        this.myBuildFileFolder = buildFileFolder;
        this.myIncludeFolders = allIncludes;
        this.myShowPackageType = showPackageType;
    }

    public static IncludeViewNode createIncludeView(@NotNull VirtualFile buildFileFolder, @NotNull ClassifiedIncludeValue thisInclude, @NotNull IncludeSet allIncludes, boolean showPackageType, @Nullable Project project, @NotNull ViewSettings viewSettings) {
        if (buildFileFolder == null) {
            IncludeViewNode.$$$reportNull$$$0(4);
        }
        if (thisInclude == null) {
            IncludeViewNode.$$$reportNull$$$0(5);
        }
        if (allIncludes == null) {
            IncludeViewNode.$$$reportNull$$$0(6);
        }
        if (viewSettings == null) {
            IncludeViewNode.$$$reportNull$$$0(7);
        }
        if (thisInclude instanceof SimpleIncludeValue) {
            return new SimpleIncludeViewNode(buildFileFolder, (SimpleIncludeValue)thisInclude, allIncludes, showPackageType, project, viewSettings);
        }
        if (thisInclude instanceof PackageValue) {
            return new PackagingViewNode(buildFileFolder, allIncludes, project, (PackageValue)thisInclude, viewSettings, showPackageType);
        }
        if (thisInclude instanceof PackageFamilyValue) {
            return new PackagingFamilyViewNode(buildFileFolder, allIncludes, project, (PackageFamilyValue)thisInclude, viewSettings, showPackageType);
        }
        throw new RuntimeException(thisInclude.getClass().toString());
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        if (PsiDirectory.EMPTY_ARRAY == null) {
            IncludeViewNode.$$$reportNull$$$0(8);
        }
        return PsiDirectory.EMPTY_ARRAY;
    }

    @Nullable
    public Comparable getSortKey() {
        ClassifiedIncludeValue value2 = (ClassifiedIncludeValue)this.getValue();
        return "[icon-f]" + (value2 == null ? "" : value2.getSortKey());
    }

    @NotNull
    public final String toString() {
        String string = this.myDescription;
        if (string == null) {
            IncludeViewNode.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void lazyInitializeHashCodeAndDescription() {
        if (this.myDescription == null) {
            StringBuilder sb = new StringBuilder();
            this.writeDescription(PresentationDataWrapperKt.createPresentationDataWrapper(sb));
            this.myDescription = sb.toString();
            this.myHashCode = Objects.hash(this.myBuildFileFolder, this.myDescription);
        }
    }

    abstract void writeDescription(@NotNull PresentationDataWrapper var1);

    protected final void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            IncludeViewNode.$$$reportNull$$$0(10);
        }
        this.writeDescription(PresentationDataWrapperKt.createPresentationDataWrapper(presentation));
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        IncludeViewNode that = (IncludeViewNode)object;
        this.lazyInitializeHashCodeAndDescription();
        return Objects.equals(this.myBuildFileFolder, that.myBuildFileFolder) && Objects.equals(this.myDescription, that.myDescription);
    }

    public final int hashCode() {
        this.lazyInitializeHashCodeAndDescription();
        return this.myHashCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileFolder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisInclude";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allIncludes";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/IncludeViewNode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/view/IncludeViewNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIncludeView";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

