/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeSet {
    @NotNull
    private static final String TAKE_NEXT_SENTINEL = "TAKE_NEXT_SENTINEL";
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("://", 16);
    @NotNull
    private final LinkedHashSet<String> myIncludes = new LinkedHashSet();

    @NotNull
    private static String getSysrootEquivalentPath(@NotNull String compilerFlag) {
        if (compilerFlag == null) {
            IncludeSet.$$$reportNull$$$0(0);
        }
        String result2 = compilerFlag;
        result2 = FilenameUtils.concat((String)result2, (String)"usr");
        String string = result2 = FilenameUtils.concat((String)result2, (String)"include");
        if (string == null) {
            IncludeSet.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String analyzeFlagPattern(@NotNull String flag, @NotNull IncludeFlags checkFlag) {
        if (flag == null) {
            IncludeSet.$$$reportNull$$$0(2);
        }
        if (checkFlag == null) {
            IncludeSet.$$$reportNull$$$0(3);
        }
        String check = checkFlag.myFlag;
        if (flag.equals("-" + check)) {
            return TAKE_NEXT_SENTINEL;
        }
        if (flag.equals("--" + check)) {
            return TAKE_NEXT_SENTINEL;
        }
        if (flag.startsWith("-" + check + "=")) {
            return flag.substring(check.length() + 2);
        }
        if (flag.startsWith("--" + check + "=")) {
            return flag.substring(check.length() + 3);
        }
        if (flag.startsWith("-" + check)) {
            return flag.substring(check.length() + 1);
        }
        if (flag.startsWith("--" + check)) {
            return flag.substring(check.length() + 2);
        }
        return null;
    }

    public List<File> getIncludesInOrder() {
        return this.myIncludes.stream().map(File::new).collect(Collectors.toList());
    }

    public void addIncludesFromCompilerFlags(@NotNull Collection<String> compilerFlags, @Nullable File compilerWorkingFolder) {
        if (compilerFlags == null) {
            IncludeSet.$$$reportNull$$$0(4);
        }
        ArrayList<String> includeFolders = new ArrayList<String>();
        boolean useNextFlagAsInclude = false;
        boolean appendUsrInclude = false;
        block0: for (String compilerFlag : compilerFlags) {
            if (useNextFlagAsInclude) {
                if (appendUsrInclude) {
                    compilerFlag = IncludeSet.getSysrootEquivalentPath(compilerFlag);
                }
                includeFolders.add(compilerFlag);
                useNextFlagAsInclude = false;
                continue;
            }
            for (IncludeFlags test : IncludeFlags.values()) {
                String analysis = IncludeSet.analyzeFlagPattern(compilerFlag, test);
                if (analysis == TAKE_NEXT_SENTINEL) {
                    useNextFlagAsInclude = true;
                    appendUsrInclude = test.myAppendUsrInclude;
                    continue block0;
                }
                if (analysis == null) continue;
                if (test.myAppendUsrInclude) {
                    analysis = IncludeSet.getSysrootEquivalentPath(analysis);
                }
                includeFolders.add(analysis);
                continue block0;
            }
        }
        for (String include : includeFolders) {
            this.add(include, compilerWorkingFolder);
        }
    }

    public void add(@NotNull String include, @Nullable File compilerWorkingFolder) {
        if (include == null) {
            IncludeSet.$$$reportNull$$$0(5);
        }
        String includePath = include;
        if (compilerWorkingFolder != null) {
            includePath = FilenameUtils.concat((String)compilerWorkingFolder.getAbsolutePath(), (String)includePath);
        }
        includePath = FilenameUtils.normalizeNoEndSeparator((String)includePath, (boolean)true);
        includePath = PATTERN.matcher(includePath).replaceAll(Matcher.quoteReplacement(":/"));
        this.myIncludes.add(includePath);
    }

    @NotNull
    public String toString() {
        String string = this.myIncludes.toString();
        if (string == null) {
            IncludeSet.$$$reportNull$$$0(6);
        }
        return string;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncludeSet)) {
            return false;
        }
        IncludeSet that = (IncludeSet)obj;
        return Objects.equals(this.myIncludes, that.myIncludes);
    }

    public final int hashCode() {
        return this.myIncludes.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerFlag";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/utils/IncludeSet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkFlag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerFlags";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/utils/IncludeSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSysrootEquivalentPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSysrootEquivalentPath";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFlagPattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addIncludesFromCompilerFlags";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum IncludeFlags {
        I_FLAG("I", false),
        ISYSTEM_FLAG("isystem", false),
        SYSROOT_FLAG("sysroot", true);

        @NotNull
        final String myFlag;
        final boolean myAppendUsrInclude;

        private IncludeFlags(String flag, boolean appendUsrInclude) {
            if (flag == null) {
                IncludeFlags.$$$reportNull$$$0(0);
            }
            this.myFlag = flag;
            this.myAppendUsrInclude = appendUsrInclude;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flag", "com/android/tools/idea/navigator/nodes/ndk/includes/utils/IncludeSet$IncludeFlags", "<init>"));
        }
    }
}

