/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.IndexedRegularExpressionIncludeResolver;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NdkIncludeResolver
extends IncludeResolver {
    @Nullable
    private final IncludeResolver[] myResolvers;
    @Nullable
    private final String myNdkFolderAbsolutePath;

    NdkIncludeResolver(@Nullable File ndkFolder) {
        if (ndkFolder != null) {
            this.myNdkFolderAbsolutePath = FilenameUtils.separatorsToUnix((String)ndkFolder.getAbsolutePath());
            this.myResolvers = new IncludeResolver[]{this.leafNamed("^({NDKFOLDER})(/platforms/(android-.*?)/arch-.*?(/.*))$"), this.leafNamed("^({NDKFOLDER})(/sources/cxx-stl/(.*?)(/.*))$"), this.leafNamed("^({NDKFOLDER})(/sources/third_party/(.*?)(/.*))$"), this.leafNamed("^({NDKFOLDER})(/toolchains/(.*?)(/.*))$"), this.literalNamed("^({NDKFOLDER})(/sources/android/cpufeatures(/.*))$", "CPU Features"), this.literalNamed("^({NDKFOLDER})(/sources/android/native_app_glue(/.*))$", "Native App Glue"), this.literalNamed("^({NDKFOLDER})(/sources/android/ndk_helper(/.*))$", "NDK Helper"), this.literalNamed("^({NDKFOLDER})(/sysroot(/.*))$", "Android Sysroot")};
        } else {
            this.myNdkFolderAbsolutePath = null;
            this.myResolvers = null;
        }
    }

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        if (includeFolder == null) {
            NdkIncludeResolver.$$$reportNull$$$0(0);
        }
        if (this.myNdkFolderAbsolutePath == null || this.myResolvers == null) {
            return null;
        }
        for (IncludeResolver resolver : this.myResolvers) {
            SimpleIncludeValue classifiedIncludeExpression = resolver.resolve(includeFolder);
            if (classifiedIncludeExpression == null) continue;
            return classifiedIncludeExpression;
        }
        return null;
    }

    @NotNull
    private IncludeResolver literalNamed(@NotNull String pattern, @NotNull String name) {
        if (pattern == null) {
            NdkIncludeResolver.$$$reportNull$$$0(1);
        }
        if (name == null) {
            NdkIncludeResolver.$$$reportNull$$$0(2);
        }
        IndexedRegularExpressionIncludeResolver indexedRegularExpressionIncludeResolver = new IndexedRegularExpressionIncludeResolver(PackageType.NdkComponent, this.concreteNdkFolder(pattern), name);
        if (indexedRegularExpressionIncludeResolver == null) {
            NdkIncludeResolver.$$$reportNull$$$0(3);
        }
        return indexedRegularExpressionIncludeResolver;
    }

    @NotNull
    private IncludeResolver leafNamed(@NotNull String pattern) {
        if (pattern == null) {
            NdkIncludeResolver.$$$reportNull$$$0(4);
        }
        IndexedRegularExpressionIncludeResolver indexedRegularExpressionIncludeResolver = new IndexedRegularExpressionIncludeResolver(PackageType.NdkComponent, this.concreteNdkFolder(pattern));
        if (indexedRegularExpressionIncludeResolver == null) {
            NdkIncludeResolver.$$$reportNull$$$0(5);
        }
        return indexedRegularExpressionIncludeResolver;
    }

    @NotNull
    private String concreteNdkFolder(@NotNull String pattern) {
        if (pattern == null) {
            NdkIncludeResolver.$$$reportNull$$$0(6);
        }
        assert (this.myNdkFolderAbsolutePath != null);
        String string = pattern.replace("{NDKFOLDER}", this.myNdkFolderAbsolutePath);
        if (string == null) {
            NdkIncludeResolver.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFolder";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/resolver/NdkIncludeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/resolver/NdkIncludeResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "literalNamed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "leafNamed";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "concreteNdkFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "literalNamed";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "leafNamed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "concreteNdkFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

