/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.navigator.AndroidProjectTreeBuilder;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiDirectoryNode;
import com.android.tools.idea.navigator.nodes.android.AndroidPsiFileNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSourceTypeNode
extends ProjectViewNode<AndroidFacet>
implements FolderGroupNode {
    @NotNull
    private final AndroidSourceType mySourceType;
    @NotNull
    private final Set<VirtualFile> mySourceRoots;
    @NotNull
    protected final AndroidProjectViewPane myProjectViewPane;

    AndroidSourceTypeNode(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull ViewSettings settings, @NotNull AndroidSourceType sourceType, @NotNull Set<VirtualFile> sources, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(0);
        }
        if (androidFacet == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(2);
        }
        if (sourceType == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(3);
        }
        if (sources == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(4);
        }
        if (projectViewPane == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(5);
        }
        super(project, (Object)androidFacet, settings);
        this.mySourceType = sourceType;
        this.mySourceRoots = sources;
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        ProjectViewDirectoryHelper projectViewDirectoryHelper = ProjectViewDirectoryHelper.getInstance((Project)this.myProject);
        AndroidProjectTreeBuilder treeBuilder = (AndroidProjectTreeBuilder)this.myProjectViewPane.getTreeBuilder();
        for (PsiDirectory directory : this.getSourceFolders()) {
            Collection directoryChildren = projectViewDirectoryHelper.getDirectoryChildren(directory, this.getSettings(), true);
            children.addAll(this.annotateWithSourceProvider(directoryChildren));
            treeBuilder.createMapping(directory.getVirtualFile(), (AbstractTreeNode)this);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private Collection<AbstractTreeNode> annotateWithSourceProvider(@NotNull Collection<AbstractTreeNode> folderChildren) {
        if (folderChildren == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(7);
        }
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>(folderChildren.size());
        assert (this.myProject != null);
        for (AbstractTreeNode child : folderChildren) {
            if (child instanceof PsiDirectoryNode) {
                PsiDirectory folder = (PsiDirectory)((PsiDirectoryNode)child).getValue();
                assert (folder != null);
                children.add((AbstractTreeNode)new AndroidPsiDirectoryNode(this.myProject, folder, this.getSettings(), this.findSourceProvider(folder.getVirtualFile())));
                continue;
            }
            if (child instanceof PsiFileNode) {
                PsiFile file = (PsiFile)((PsiFileNode)child).getValue();
                assert (file != null);
                VirtualFile virtualFile = file.getVirtualFile();
                children.add((AbstractTreeNode)new AndroidPsiFileNode(this.myProject, file, this.getSettings(), this.findSourceProvider(virtualFile)));
                continue;
            }
            children.add(child);
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private IdeaSourceProvider findSourceProvider(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(9);
        }
        AndroidFacet androidFacet = (AndroidFacet)((Object)this.getValue());
        assert (androidFacet != null);
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(androidFacet)) {
            if (!provider.containsFile(virtualFile)) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    protected List<PsiDirectory> getSourceFolders() {
        assert (this.myProject != null);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiDirectory> folders = new ArrayList<PsiDirectory>(this.mySourceRoots.size());
        for (VirtualFile root : this.mySourceRoots) {
            PsiDirectory folder;
            if (!root.isValid() || (folder = psiManager.findDirectory(root)) == null) continue;
            folders.add(folder);
        }
        ArrayList<PsiDirectory> arrayList = folders;
        if (arrayList == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(11);
        }
        presentation.addText(this.mySourceType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon = this.mySourceType.getIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
        presentation.setPresentableText(this.mySourceType.getName());
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.mySourceType.getName();
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(12);
        }
        for (VirtualFile root : this.mySourceRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.mySourceType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.mySourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AndroidSourceTypeNode that = (AndroidSourceTypeNode)o;
        if (this.mySourceType != that.mySourceType) {
            return false;
        }
        return this.mySourceRoots.equals(that.mySourceRoots);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.mySourceType.hashCode();
        for (VirtualFile root : this.mySourceRoots) {
            result2 = 31 * result2 + root.hashCode();
        }
        return result2;
    }

    @Override
    @NotNull
    public PsiDirectory[] getFolders() {
        List<PsiDirectory> folders = this.getSourceFolders();
        PsiDirectory[] psiDirectoryArray = folders.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            AndroidSourceTypeNode.$$$reportNull$$$0(13);
        }
        return psiDirectoryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderChildren";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidSourceTypeNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "annotateWithSourceProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotateWithSourceProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSourceProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

