/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.structure;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.workbench.StartFilteringListener;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DestinationList
extends JPanel
implements DataProvider,
Disposable {
    static final String ROOT_NAME = "Root";
    final DefaultListModel<NlComponent> myUnderlyingModel;
    final FilteringListModel<NlComponent> myListModel;
    SelectionModel mySelectionModel;
    public final JBList<NlComponent> myList;
    private boolean mySelectionUpdating;
    private SelectionListener mySelectionModelListener;
    private ModelListener myModelListener;
    private NlModel myModel;
    private ListSelectionListener myListSelectionListener;
    private MouseListener myMouseListener;
    private NavDesignSurface myDesignSurface;
    private StartFilteringListener myStartFilteringListener;
    private Runnable myStopFilteringListener;
    private static final Map<Icon, Icon> WHITE_ICONS = ImmutableMap.of((Object)StudioIcons.NavEditor.Tree.FRAGMENT, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.FRAGMENT), (Object)StudioIcons.NavEditor.Tree.INCLUDE_GRAPH, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.INCLUDE_GRAPH), (Object)StudioIcons.NavEditor.Tree.ACTIVITY, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.ACTIVITY), (Object)StudioIcons.NavEditor.Tree.NESTED_GRAPH, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.NESTED_GRAPH), (Object)StudioIcons.NavEditor.Tree.PLACEHOLDER, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.PLACEHOLDER));

    DestinationList(@NotNull Disposable parentDisposable, @NotNull NavDesignSurface surface) {
        if (parentDisposable == null) {
            DestinationList.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            DestinationList.$$$reportNull$$$0(1);
        }
        this.myUnderlyingModel = new DefaultListModel();
        this.myListModel = new FilteringListModel(this.myUnderlyingModel);
        this.myDesignSurface = surface;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setLayout(new BorderLayout());
        this.myList = new JBList(this.myListModel);
        this.myList.getEmptyText().setText("");
        this.myList.setName("DestinationList");
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<NlComponent>(){

            protected void customizeCellRenderer(@NotNull JList<? extends NlComponent> list, NlComponent component, int index, boolean isSelected, boolean cellHasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (isSelected && !list.hasFocus()) {
                    this.setBackground(UIUtil.getListUnfocusedSelectionBackground());
                    this.mySelectionForeground = UIUtil.getListForeground();
                }
                this.append(NavComponentHelperKt.getUiName(component));
                if (NavComponentHelperKt.isStartDestination(component)) {
                    this.append(" - Start", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                Icon icon = StudioIcons.NavEditor.Tree.FRAGMENT;
                if (NavComponentHelperKt.isInclude(component)) {
                    icon = StudioIcons.NavEditor.Tree.INCLUDE_GRAPH;
                } else if (NavComponentHelperKt.isNavigation(component)) {
                    icon = StudioIcons.NavEditor.Tree.NESTED_GRAPH;
                } else if (NavComponentHelperKt.getClassName(component) == null) {
                    icon = StudioIcons.NavEditor.Tree.PLACEHOLDER;
                } else if (NavComponentHelperKt.isActivity(component)) {
                    icon = StudioIcons.NavEditor.Tree.ACTIVITY;
                }
                if (isSelected && list.hasFocus()) {
                    icon = (Icon)WHITE_ICONS.get(icon);
                }
                this.setIcon(icon);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/naveditor/structure/DestinationList$1", "customizeCellRenderer"));
            }
        });
        this.myList.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (Character.isAlphabetic(e.getKeyChar()) && DestinationList.this.myStartFilteringListener != null) {
                    DestinationList.this.myStartFilteringListener.startFiltering(e.getKeyChar());
                    e.consume();
                }
                if (e.getKeyChar() == '\u001b' && DestinationList.this.myStopFilteringListener != null) {
                    DestinationList.this.myStopFilteringListener.run();
                }
            }
        });
        InputMap inputMap = this.getInputMap(1);
        String deleteDestinationKey = "deleteDestination";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteDestination");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "deleteDestination");
        this.getActionMap().put("deleteDestination", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final List toDelete = DestinationList.this.myList.getSelectedValuesList();
                if (!toDelete.isEmpty()) {
                    new WriteCommandAction(DestinationList.this.myDesignSurface.getProject(), "Delete Destination" + (toDelete.size() > 1 ? "s" : ""), new PsiFile[]{DestinationList.this.myDesignSurface.getModel().getFile()}){

                        protected void run(@NotNull Result result2) {
                            if (result2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            DestinationList.this.myDesignSurface.getModel().delete(toDelete);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/naveditor/structure/DestinationList$3$1", "run"));
                        }
                    }.execute();
                }
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane(this.myList, (int)20, (int)30);
        pane.setBorder(null);
        this.add((Component)pane, "Center");
        this.myModel = surface.getModel();
        this.mySelectionModel = surface.getSelectionModel();
        this.mySelectionModelListener = (model, selection) -> this.updateListSelection();
        this.mySelectionModel.addListener(this.mySelectionModelListener);
        this.myListSelectionListener = e -> {
            if (this.mySelectionUpdating || e.getValueIsAdjusting()) {
                return;
            }
            try {
                this.mySelectionUpdating = true;
                this.mySelectionModel.setSelection(this.myList.getSelectedValuesList());
                this.myDesignSurface.scrollToCenter(this.myList.getSelectedValuesList());
            }
            finally {
                this.mySelectionUpdating = false;
            }
        };
        this.myList.addListSelectionListener(this.myListSelectionListener);
        this.myModelListener = new ModelListener(){

            @Override
            public void modelDerivedDataChanged(@NotNull NlModel model) {
                if (model == null) {
                    4.$$$reportNull$$$0(0);
                }
                DestinationList.this.updateComponentList();
            }

            @Override
            public void modelActivated(@NotNull NlModel model) {
                if (model == null) {
                    4.$$$reportNull$$$0(1);
                }
                DestinationList.this.updateComponentList();
            }

            @Override
            public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
                if (model == null) {
                    4.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "model";
                objectArray2[1] = "com/android/tools/idea/naveditor/structure/DestinationList$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelDerivedDataChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelActivated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelChangedOnLayout";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myMouseListener = new DestinationListMouseListener();
        this.myList.addMouseListener(this.myMouseListener);
        this.myModel.addListener(this.myModelListener);
        ColorSet colorSet = SceneContext.get(surface.getCurrentSceneView()).getColorSet();
        this.myList.setBackground(colorSet.getSubduedBackground());
        this.updateComponentList();
        this.myList.putClientProperty((Object)"DataProvider", dataId -> {
            if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
                return this.myList.indexToLocation(this.myList.getSelectedIndex());
            }
            return null;
        });
    }

    public void dispose() {
        this.mySelectionModel.removeListener(this.mySelectionModelListener);
        this.myModel.removeListener(this.myModelListener);
        this.myList.removeListSelectionListener(this.myListSelectionListener);
        this.myList.removeMouseListener(this.myMouseListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateComponentList() {
        ArrayList<NlComponent> newElements = new ArrayList<NlComponent>();
        NlComponent root = this.myDesignSurface.getCurrentNavigation();
        for (NlComponent child : root.getChildren()) {
            if (!NavComponentHelperKt.isDestination(child)) continue;
            newElements.add(child);
        }
        if (!newElements.equals(Collections.list(this.myUnderlyingModel.elements()))) {
            this.mySelectionUpdating = true;
            try {
                this.myUnderlyingModel.clear();
                newElements.forEach(this.myUnderlyingModel::addElement);
            }
            finally {
                this.mySelectionUpdating = false;
            }
        }
        this.updateListSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListSelection() {
        if (this.mySelectionUpdating) {
            return;
        }
        try {
            this.mySelectionUpdating = true;
            HashSet<NlComponent> components = new HashSet<NlComponent>((Collection<NlComponent>)this.mySelectionModel.getSelection());
            ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
            for (int i2 = 0; i2 < this.myUnderlyingModel.size(); ++i2) {
                if (!components.contains(this.myUnderlyingModel.get(i2))) continue;
                selectedIndices.add(i2);
            }
            this.myList.setSelectedIndices(ArrayUtil.toIntArray(selectedIndices));
        }
        finally {
            this.mySelectionUpdating = false;
        }
    }

    public void setFilter(@NotNull String filter2) {
        if (filter2 == null) {
            DestinationList.$$$reportNull$$$0(2);
        }
        this.myListModel.setFilter(c -> NavComponentHelperKt.getUiName(c).toLowerCase(this.getLocale()).contains(filter2.toLowerCase(this.getLocale())));
    }

    public void setStartFiltering(@NotNull StartFilteringListener listener2) {
        if (listener2 == null) {
            DestinationList.$$$reportNull$$$0(3);
        }
        this.myStartFilteringListener = listener2;
    }

    public void setStopFiltering(@NotNull Runnable stopFilteringListener) {
        if (stopFilteringListener == null) {
            DestinationList.$$$reportNull$$$0(4);
        }
        this.myStopFilteringListener = stopFilteringListener;
    }

    public Object getData(@NonNls String dataId) {
        return this.myDesignSurface == null ? null : this.myDesignSurface.getData(dataId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopFilteringListener";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/naveditor/structure/DestinationList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setStartFiltering";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setStopFiltering";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class DestinationListMouseListener
    extends MouseAdapter {
        private DestinationListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.handleDoubleClick(e);
            } else {
                this.handlePopup(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        private void handlePopup(MouseEvent e) {
            int index;
            if (e.isPopupTrigger() && (index = DestinationList.this.myList.locationToIndex(e.getPoint())) != -1) {
                NlComponent component = (NlComponent)DestinationList.this.myList.getModel().getElementAt(index);
                DestinationList.this.myDesignSurface.getActionManager().showPopup(e, component);
                e.consume();
            }
        }

        private void handleDoubleClick(@NotNull MouseEvent event) {
            int index;
            if (event == null) {
                DestinationListMouseListener.$$$reportNull$$$0(0);
            }
            if ((index = DestinationList.this.myList.locationToIndex(event.getPoint())) != -1) {
                NlComponent component = (NlComponent)DestinationList.this.myList.getModel().getElementAt(index);
                DestinationList.this.myDesignSurface.notifyComponentActivate(component);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/naveditor/structure/DestinationList$DestinationListMouseListener", "handleDoubleClick"));
        }
    }
}

