/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.decorator;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawFilledRectangle;
import com.android.tools.idea.common.scene.draw.DrawLine;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavColorSet;
import com.android.tools.idea.naveditor.scene.RefinableImage;
import com.android.tools.idea.naveditor.scene.ThumbnailManager;
import com.android.tools.idea.naveditor.scene.decorator.NavBaseDecorator;
import com.android.tools.idea.naveditor.scene.decorator.NavBaseDecoratorKt;
import com.android.tools.idea.naveditor.scene.draw.DrawNavScreen;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J2\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/naveditor/scene/decorator/NavScreenDecorator;", "Lcom/android/tools/idea/naveditor/scene/decorator/NavBaseDecorator;", "()V", "buildImage", "Lcom/android/tools/idea/naveditor/scene/RefinableImage;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "layout", "", "dimensions", "Ljava/awt/Dimension;", "buildListChildren", "", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "time", "", "drawImage", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "drawPlaceholder", "drawScreen", "intellij.android.designer"})
public abstract class NavScreenDecorator
extends NavBaseDecorator {
    @Override
    protected void buildListChildren(@NotNull DisplayList list, long time2, @NotNull SceneContext sceneContext, @NotNull SceneComponent component) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        for (SceneComponent child : component.getChildren()) {
            child.buildDisplayList(time2, list, sceneContext);
        }
    }

    protected final void drawScreen(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component, @NotNull Rectangle2D.Float rectangle) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        String layout2 = component.getNlComponent().getAttribute("http://schemas.android.com/tools", "layout");
        NlComponent nlComponent = component.getNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"component.nlComponent");
        String className = NavComponentHelperKt.getClassName(nlComponent);
        if (layout2 == null && className == null) {
            this.drawPlaceholder(list, rectangle);
        } else {
            this.drawImage(list, sceneContext, component, layout2, rectangle);
        }
    }

    private final void drawPlaceholder(DisplayList list, Rectangle2D.Float rectangle) {
        JBColor jBColor = NavColorSet.PLACEHOLDER_BACKGROUND_COLOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"PLACEHOLDER_BACKGROUND_COLOR");
        list.add(new DrawFilledRectangle(0, rectangle, (Color)jBColor));
        BasicStroke stroke = new BasicStroke(NavBaseDecoratorKt.getREGULAR_FRAME_THICKNESS());
        Point2D.Float p1 = new Point2D.Float(rectangle.x, rectangle.y);
        Point2D.Float p2 = new Point2D.Float(p1.x, p1.y + rectangle.height);
        Point2D.Float p3 = new Point2D.Float(p1.x + rectangle.width, p1.y);
        Point2D.Float p4 = new Point2D.Float(p3.x, p2.y);
        JBColor jBColor2 = NavColorSet.PLACEHOLDER_BORDER_COLOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBColor2, (String)"PLACEHOLDER_BORDER_COLOR");
        list.add(new DrawLine(5, p1, p4, (Color)jBColor2, stroke));
        JBColor jBColor3 = NavColorSet.PLACEHOLDER_BORDER_COLOR;
        Intrinsics.checkExpressionValueIsNotNull((Object)jBColor3, (String)"PLACEHOLDER_BORDER_COLOR");
        list.add(new DrawLine(5, p2, p3, (Color)jBColor3, stroke));
    }

    private final void drawImage(DisplayList list, SceneContext sceneContext, SceneComponent component, String layout2, Rectangle2D.Float rectangle) {
        RefinableImage image = this.buildImage(sceneContext, component, layout2, new Dimension((int)rectangle.width, (int)rectangle.height));
        list.add(new DrawNavScreen(rectangle, image));
    }

    private final RefinableImage buildImage(SceneContext sceneContext, SceneComponent component, String layout2, Dimension dimensions) {
        RefinableImage empty = new RefinableImage(null, null, 3, null);
        if (layout2 == null) {
            return empty;
        }
        DesignSurface designSurface = sceneContext.getSurface();
        if (designSurface == null) {
            return empty;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)designSurface), (String)"sceneContext.surface ?: return empty");
        DesignSurface surface = designSurface;
        Configuration configuration = surface.getConfiguration();
        if (configuration == null) {
            return empty;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"surface.configuration ?: return empty");
        Configuration configuration2 = configuration;
        Object object = surface.getModel();
        if (object == null || (object = object.getFacet()) == null) {
            return empty;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"surface.model?.facet ?: return empty");
        Object facet = object;
        ResourceUrl resourceUrl = ResourceUrl.parse((String)layout2);
        if (resourceUrl == null) {
            return empty;
        }
        ResourceUrl resourceUrl2 = resourceUrl;
        if (resourceUrl2.type != ResourceType.LAYOUT) {
            return empty;
        }
        ResourceResolver resourceResolver = configuration2.getResourceResolver();
        String string = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(resourceResolver, resourceUrl2, component){
            final /* synthetic */ ResourceResolver $resourceResolver;
            final /* synthetic */ ResourceUrl $resourceUrl;
            final /* synthetic */ SceneComponent $component;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final String compute() {
                ResourceResolver resourceResolver = this.$resourceResolver;
                ResourceResolver resourceResolver2 = resourceResolver;
                if (resourceResolver == null) return null;
                RenderResources renderResources = (RenderResources)resourceResolver2;
                NlComponent nlComponent = this.$component.getNlComponent();
                Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"component.nlComponent");
                XmlTag xmlTag = nlComponent.getTag();
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag, (String)"component.nlComponent.tag");
                ResourceValue resourceValue2 = ResourceHelper.resolve(renderResources, this.$resourceUrl, (XmlElement)xmlTag);
                resourceResolver2 = resourceValue2;
                if (resourceValue2 == null) return null;
                String string = resourceResolver2.getValue();
                return string;
            }
            {
                this.$resourceResolver = resourceResolver;
                this.$resourceUrl = resourceUrl;
                this.$component = sceneComponent;
            }
        });
        if (string == null) {
            return empty;
        }
        String resourceValue2 = string;
        File file = new File(resourceValue2);
        if (!file.exists()) {
            return empty;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile == null) {
            return empty;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"VfsUtil.findFileByIoFile\u2026e, false) ?: return empty");
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(surface.getProject(), virtualFile2);
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return empty;
        }
        XmlFile psiFile2 = xmlFile;
        ThumbnailManager manager = ThumbnailManager.Companion.getInstance((AndroidFacet)((Object)facet));
        return manager.getThumbnail(psiFile2, configuration2, dimensions);
    }
}

