/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDeeplinkDialog
extends DialogWrapper {
    JTextField myUriField;
    private JCheckBox myAutoVerify;
    private JPanel myContentPanel;
    @Nullable
    private final NlComponent myExistingComponent;
    @NotNull
    private final NlComponent myParent;

    public AddDeeplinkDialog(@Nullable NlComponent existing2, @NotNull NlComponent parent) {
        if (parent == null) {
            AddDeeplinkDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.$$$setupUI$$$();
        if (existing2 != null) {
            this.myUriField.setText(existing2.getAttribute("http://schemas.android.com/apk/res-auto", "uri"));
            this.myAutoVerify.setSelected(Boolean.parseBoolean(existing2.getAttribute("http://schemas.android.com/apk/res/android", "autoVerify")));
        }
        this.init();
        if (existing2 == null) {
            this.myOKAction.putValue("Name", "Add");
            this.setTitle("Add Deep Link");
        } else {
            this.myOKAction.putValue("Name", "Update");
            this.setTitle("Update Deep Link");
        }
        this.myExistingComponent = existing2;
        this.myParent = parent;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myUriField.getText().isEmpty()) {
            return new ValidationInfo("URI must be set!", (JComponent)this.myUriField);
        }
        try {
            new URI(this.myUriField.getText().replaceAll("\\{[^}]*}", "dummy"));
        }
        catch (URISyntaxException e) {
            return new ValidationInfo("Invalid URI!", (JComponent)this.myUriField);
        }
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    String getUri() {
        return this.myUriField.getText();
    }

    public boolean getAutoVerify() {
        return this.myAutoVerify.isSelected();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            AddDeeplinkDialog.$$$reportNull$$$0(1);
        }
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myUriField;
    }

    public void save() {
        WriteCommandAction.runWriteCommandAction((Project)this.myParent.getModel().getProject(), () -> {
            NlComponent realComponent = this.myExistingComponent;
            if (realComponent == null) {
                XmlTag tag = this.myParent.getTag().createChildTag("deepLink", null, null, false);
                realComponent = this.myParent.getModel().createComponent(null, tag, this.myParent, null, InsertType.CREATE);
                realComponent.ensureId();
            }
            realComponent.setAttribute("http://schemas.android.com/apk/res-auto", "uri", this.getUri());
            if (this.getAutoVerify()) {
                realComponent.setAndroidAttribute("autoVerify", "true");
            } else {
                realComponent.removeAttribute("http://schemas.android.com/apk/res/android", "autoVerify");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/property/inspector/AddDeeplinkDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/property/inspector/AddDeeplinkDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(15, 7, 0, 7), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("URI");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Auto Verify");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutoVerify = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, new Dimension(20, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUriField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(300, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

