/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.google.common.collect.Lists;
import com.intellij.CommonBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EditLogFilterDialog
extends DialogWrapper {
    static final int FILTER_HISTORY_SIZE = 5;
    private static final String NEW_FILTER_NAME_PREFIX = "Unnamed-";
    @NonNls
    private static final String EDIT_FILTER_DIALOG_DIMENSIONS_KEY = "edit.logcat.filter.dialog.dimensions";
    @NonNls
    private static final String LOG_FILTER_MESSAGE_HISTORY = "LOG_FILTER_MESSAGE_HISTORY";
    @NonNls
    private static final String LOG_FILTER_TAG_HISTORY = "LOG_FILTER_TAG_HISTORY";
    @NonNls
    private static final String LOG_FILTER_PACKAGE_NAME_HISTORY = "LOG_FILTER_PACKAGE_NAME_HISTORY";
    private final Project myProject;
    private final List<PersistentAndroidLogFilters.FilterData> myFilters;
    private final AndroidLogcatView myView;
    private final AndroidLogcatFormatter myFormatter;
    private final Splitter mySplitter;
    private JPanel myContentPanel;
    private JPanel myLeftPanel;
    private EditorTextField myFilterNameField;
    private RegexFilterComponent myLogMessageField;
    private RegexFilterComponent myTagField;
    private TextFieldWithAutoCompletion myPidField;
    private RegexFilterComponent myPackageNameField;
    private JComboBox<Log.LogLevel> myLogLevelCombo;
    private JPanel myLogMessageFieldWrapper;
    private JPanel myTagFieldWrapper;
    private JPanel myPidFieldWrapper;
    private JPanel myPackageNameFieldWrapper;
    private JBLabel myNameFieldLabel;
    private JBLabel myLogTagLabel;
    private JBLabel myLogMessageLabel;
    private JBLabel myPidLabel;
    private JBLabel myPackageNameLabel;
    private JBList<String> myFiltersList;
    private CollectionListModel<String> myFiltersListModel;
    @Nullable
    private PersistentAndroidLogFilters.FilterData myActiveFilter;
    private JPanel myFiltersToolbarPanel;
    private boolean myExistingMessagesParsed;
    private List<String> myUsedPids;

    EditLogFilterDialog(@NotNull AndroidLogcatView view, @Nullable String selectedFilter) {
        if (view == null) {
            EditLogFilterDialog.$$$reportNull$$$0(0);
        }
        super(view.getProject(), false);
        this.myExistingMessagesParsed = false;
        this.$$$setupUI$$$();
        this.myProject = view.getProject();
        this.myFilters = PersistentAndroidLogFilters.getInstance(this.myProject).getFilters();
        this.myView = view;
        this.myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), AndroidLogcatPreferences.getInstance(this.myProject));
        this.mySplitter = new Splitter(false, 0.25f);
        this.mySplitter.setFirstComponent((JComponent)this.myLeftPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myContentPanel);
        if (selectedFilter != null) {
            for (PersistentAndroidLogFilters.FilterData filter2 : this.myFilters) {
                if (!selectedFilter.equals(filter2.getName())) continue;
                this.myActiveFilter = filter2;
            }
        }
        if (this.myActiveFilter == null) {
            this.myActiveFilter = this.myFilters.isEmpty() ? this.createNewFilter() : this.myFilters.get(0);
        }
        this.createEditorFields();
        this.initFiltersToolbar();
        this.initFiltersList();
        this.updateFilters();
        this.init();
    }

    @NotNull
    @NonNls
    protected String getDimensionServiceKey() {
        if (EDIT_FILTER_DIALOG_DIMENSIONS_KEY == null) {
            EditLogFilterDialog.$$$reportNull$$$0(1);
        }
        return EDIT_FILTER_DIALOG_DIMENSIONS_KEY;
    }

    private void createEditorFields() {
        this.myNameFieldLabel.setLabelFor((Component)this.myFilterNameField);
        this.myLogMessageField = new RegexFilterComponent(LOG_FILTER_MESSAGE_HISTORY, 5);
        this.myLogMessageFieldWrapper.add((Component)((Object)this.myLogMessageField));
        this.myLogMessageLabel.setLabelFor((Component)((Object)this.myLogMessageField));
        this.myTagField = new RegexFilterComponent(LOG_FILTER_TAG_HISTORY, 5);
        this.myTagFieldWrapper.add((Component)((Object)this.myTagField));
        this.myLogTagLabel.setLabelFor((Component)((Object)this.myTagField));
        this.myPidField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                EditLogFilterDialog.this.parseExistingMessagesIfNecessary();
                this.setItems(EditLogFilterDialog.this.myUsedPids);
                Collection collection = super.getItems(prefix, cached, parameters);
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            public int compare(String item1, String item2) {
                int pid1 = Integer.parseInt(item1);
                int pid2 = Integer.parseInt(item2);
                return Comparing.compare((int)pid1, (int)pid2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/EditLogFilterDialog$1", "getItems"));
            }
        }, true, null);
        this.myPidFieldWrapper.add((Component)this.myPidField);
        this.myPidLabel.setLabelFor((Component)this.myPidField);
        this.myPackageNameField = new RegexFilterComponent(LOG_FILTER_PACKAGE_NAME_HISTORY, 5);
        this.myPackageNameFieldWrapper.add((Component)((Object)this.myPackageNameField));
        this.myPackageNameLabel.setLabelFor((Component)((Object)this.myPackageNameField));
        this.myLogLevelCombo.setModel((ComboBoxModel<Log.LogLevel>)new EnumComboBoxModel(Log.LogLevel.class));
        this.myLogLevelCombo.setRenderer((ListCellRenderer<Log.LogLevel>)SimpleListCellRenderer.create((String)"", value2 -> StringUtil.capitalize((String)StringUtil.toLowerCase((String)value2.getStringValue()))));
        this.myLogLevelCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditLogFilterDialog.this.myActiveFilter == null) {
                    return;
                }
                Log.LogLevel selectedItem = (Log.LogLevel)EditLogFilterDialog.this.myLogLevelCombo.getSelectedItem();
                assert (selectedItem != null);
                EditLogFilterDialog.this.myActiveFilter.setLogLevel(selectedItem.getStringValue());
            }
        });
        final Key componentKey = new Key("myComponent");
        this.myFilterNameField.getDocument().putUserData(componentKey, (Object)this.myFilterNameField);
        this.myPidField.getDocument().putUserData(componentKey, (Object)this.myPidField);
        DocumentListener l = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (EditLogFilterDialog.this.myActiveFilter == null) {
                    return;
                }
                String text = e.getDocument().getText().trim();
                JComponent src = (JComponent)e.getDocument().getUserData(componentKey);
                if (src == EditLogFilterDialog.this.myPidField) {
                    EditLogFilterDialog.this.myActiveFilter.setPid(text);
                } else if (src == EditLogFilterDialog.this.myFilterNameField) {
                    int index = EditLogFilterDialog.this.myFiltersList.getSelectedIndex();
                    if (index != -1) {
                        EditLogFilterDialog.this.myFiltersListModel.setElementAt((Object)text, index);
                    }
                    EditLogFilterDialog.this.myActiveFilter.setName(text);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/logcat/EditLogFilterDialog$3", "documentChanged"));
            }
        };
        this.myFilterNameField.getDocument().addDocumentListener(l);
        this.myPidField.getDocument().addDocumentListener(l);
        RegexFilterComponent.Listener rl = new RegexFilterComponent.Listener(){

            @Override
            public void filterChanged(RegexFilterComponent filter2) {
                if (EditLogFilterDialog.this.myActiveFilter == null) {
                    return;
                }
                if (filter2 == EditLogFilterDialog.this.myTagField) {
                    EditLogFilterDialog.this.myActiveFilter.setLogTagPattern(filter2.getFilter());
                    EditLogFilterDialog.this.myActiveFilter.setLogTagIsRegex(filter2.isRegex());
                } else if (filter2 == EditLogFilterDialog.this.myLogMessageField) {
                    EditLogFilterDialog.this.myActiveFilter.setLogMessagePattern(filter2.getFilter());
                    EditLogFilterDialog.this.myActiveFilter.setLogMessageIsRegex(filter2.isRegex());
                } else if (filter2 == EditLogFilterDialog.this.myPackageNameField) {
                    EditLogFilterDialog.this.myActiveFilter.setPackageNamePattern(filter2.getFilter());
                    EditLogFilterDialog.this.myActiveFilter.setPackageNameIsRegex(filter2.isRegex());
                }
            }
        };
        this.myTagField.addRegexListener(rl);
        this.myLogMessageField.addRegexListener(rl);
        this.myPackageNameField.addRegexListener(rl);
    }

    private void initFiltersList() {
        this.myFiltersList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int i2 = EditLogFilterDialog.this.myFiltersList.getSelectedIndex();
                EditLogFilterDialog.this.myActiveFilter = i2 == -1 ? null : (PersistentAndroidLogFilters.FilterData)EditLogFilterDialog.this.myFilters.get(i2);
                EditLogFilterDialog.this.resetFieldEditors();
            }
        });
        this.myFiltersListModel = new CollectionListModel((Object[])new String[0]);
        for (PersistentAndroidLogFilters.FilterData filter2 : this.myFilters) {
            this.myFiltersListModel.add((Object)filter2.getName());
        }
        this.myFiltersList.setModel(this.myFiltersListModel);
        this.myFiltersList.setEmptyText(AndroidBundle.message("android.logcat.edit.filter.dialog.no.filters", new Object[0]));
    }

    private void initFiltersToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new MyAddFilterAction());
        group.add((AnAction)new MyRemoveFilterAction());
        JComponent component = ActionManager.getInstance().createActionToolbar("AndroidEditLogFilter", (ActionGroup)group, true).getComponent();
        this.myFiltersToolbarPanel.add((Component)component, "Center");
    }

    private void parseExistingMessagesIfNecessary() {
        String[] lines;
        if (this.myExistingMessagesParsed) {
            return;
        }
        this.myExistingMessagesParsed = true;
        StringBuffer document = this.myView.getLogConsole().getOriginalDocument();
        if (document == null) {
            return;
        }
        HashSet pidSet = new HashSet();
        for (String line : lines = StringUtil.splitByLines((String)document.toString())) {
            pidSet.add(Integer.toString(this.myFormatter.parseMessage(line).getPid()));
        }
        this.myUsedPids = Lists.newArrayList((Iterable)pidSet);
    }

    private void resetFieldEditors() {
        boolean enabled = this.myActiveFilter != null;
        this.myFilterNameField.setEnabled(enabled);
        this.myTagField.setEnabled(enabled);
        this.myLogMessageField.setEnabled(enabled);
        this.myPidField.setEnabled(enabled);
        this.myPackageNameField.setEnabled(enabled);
        this.myLogLevelCombo.setEnabled(enabled);
        String name = enabled ? this.myActiveFilter.getName() : "";
        String tag = enabled ? this.myActiveFilter.getLogTagPattern() : "";
        String msg = enabled ? this.myActiveFilter.getLogMessagePattern() : "";
        String pid = enabled ? this.myActiveFilter.getPid() : "";
        String pkg = enabled ? this.myActiveFilter.getPackageNamePattern() : "";
        Log.LogLevel logLevel = enabled ? Log.LogLevel.getByString((String)this.myActiveFilter.getLogLevel()) : Log.LogLevel.VERBOSE;
        this.myFilterNameField.setText(name != null ? name : "");
        this.myFilterNameField.selectAll();
        this.myTagField.setFilter(tag != null ? tag : "");
        this.myTagField.setIsRegex(this.myActiveFilter == null || this.myActiveFilter.getLogTagIsRegex());
        this.myLogMessageField.setFilter(msg != null ? msg : "");
        this.myLogMessageField.setIsRegex(this.myActiveFilter == null || this.myActiveFilter.getLogMessageIsRegex());
        this.myPidField.setText(pid != null ? pid : "");
        this.myPackageNameField.setFilter(pkg != null ? pkg : "");
        this.myPackageNameField.setIsRegex(this.myActiveFilter == null || this.myActiveFilter.getPackageNameIsRegex());
        this.myLogLevelCombo.setSelectedItem(logLevel != null ? logLevel : Log.LogLevel.VERBOSE);
    }

    protected JComponent createCenterPanel() {
        return this.mySplitter;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFilterNameField.getText().startsWith(NEW_FILTER_NAME_PREFIX) ? this.myFilterNameField : this.myTagField;
    }

    protected void doOKAction() {
        PersistentAndroidLogFilters.getInstance(this.myProject).setFilters(this.myFilters);
        super.doOKAction();
    }

    protected ValidationInfo doValidate() {
        if (!this.myFilterNameField.isEnabled()) {
            return null;
        }
        String name = this.myFilterNameField.getText().trim();
        if (name.isEmpty()) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.name.not.specified.error", new Object[0]), (JComponent)this.myFilterNameField);
        }
        if (name.equals(AndroidLogcatView.NO_FILTERS) || name.equals(AndroidLogcatView.SELECTED_APP_FILTER) || name.equals(AndroidLogcatView.EDIT_FILTER_CONFIGURATION)) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.name.busy.error", name));
        }
        for (PersistentAndroidLogFilters.FilterData filter2 : this.myFilters) {
            if (filter2 == this.myActiveFilter || !name.equals(filter2.getName())) continue;
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.name.busy.error", name));
        }
        if (this.myTagField.getParseError() != null) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.log.tag.pattern.error", new Object[0]) + '\n' + this.myTagField.getParseError());
        }
        if (this.myLogMessageField.getParseError() != null) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.message.pattern.error", new Object[0]) + '\n' + this.myLogMessageField.getParseError());
        }
        if (this.myPackageNameField.getParseError() != null) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.application.name.pattern.error", new Object[0]) + '\n' + this.myPackageNameField.getParseError());
        }
        boolean validPid = false;
        try {
            Integer pid;
            String pidStr = this.myPidField.getText().trim();
            Integer n = pid = !pidStr.isEmpty() ? Integer.valueOf(Integer.parseInt(pidStr)) : null;
            if (pid == null || pid >= 0) {
                validPid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!validPid) {
            return new ValidationInfo(AndroidBundle.message("android.logcat.new.filter.dialog.incorrect.pid.error", new Object[0]));
        }
        return null;
    }

    @Nullable
    public PersistentAndroidLogFilters.FilterData getActiveFilter() {
        return this.myActiveFilter;
    }

    private void updateFilters() {
        this.myFiltersList.setEnabled(!this.myFilters.isEmpty());
        if (this.myActiveFilter != null) {
            this.myFiltersList.setSelectedValue((Object)this.myActiveFilter.getName(), true);
        } else if (!this.myFilters.isEmpty()) {
            this.myFiltersList.setSelectedIndex(0);
        }
        this.resetFieldEditors();
    }

    private PersistentAndroidLogFilters.FilterData createNewFilter() {
        PersistentAndroidLogFilters.FilterData filter2 = new PersistentAndroidLogFilters.FilterData();
        this.myFilters.add(filter2);
        filter2.setName(this.getUniqueName());
        return filter2;
    }

    private String getUniqueName() {
        HashSet names = new HashSet(this.myFilters.size());
        for (PersistentAndroidLogFilters.FilterData filter2 : this.myFilters) {
            names.add(filter2.getName());
        }
        int i2 = 0;
        String n;
        while (names.contains(n = NEW_FILTER_NAME_PREFIX + i2)) {
            ++i2;
        }
        return n;
    }

    private String getSelectedFilterName() {
        return (String)this.myFiltersList.getSelectedValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/EditLogFilterDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/EditLogFilterDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBList jBList;
        JPanel jPanel2;
        JPanel jPanel3;
        EditorTextField editorTextField;
        JPanel jPanel4;
        JBLabel jBLabel;
        JPanel jPanel5;
        JPanel jPanel6;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel7;
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(30);
        this.myContentPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel8, new GridConstraints(0, 0, 8, 2, 0, 3, 3, 3, null, null, null));
        this.myNameFieldLabel = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.name.label"));
        jPanel8.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLogTagLabel = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.tag.label"));
        jPanel8.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLogMessageLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.message.label"));
        jPanel8.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPidLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.pid.label"));
        jPanel8.add((Component)jBLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.log.level.label"));
        jPanel8.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myLogLevelCombo = jComboBox;
        jPanel8.add(jComboBox, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTagFieldWrapper = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel6, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPidFieldWrapper = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel5, new GridConstraints(5, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPackageNameLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.filter.dialog.package.name.label"));
        jPanel8.add((Component)jBLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPackageNameFieldWrapper = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel4, new GridConstraints(4, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.logcat.new.logcat.dialog.label"));
        jPanel8.add((Component)jBLabel6, new GridConstraints(1, 0, 1, 2, 0, 3, 0, 0, null, null, null));
        this.myFilterNameField = editorTextField = new EditorTextField();
        jPanel8.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myLogMessageFieldWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel3, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLeftPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 3), 0, 1, false, false));
        jSplitPane.setLeftComponent(jPanel2);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(100, -1), null, null));
        this.myFiltersList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        this.myFiltersToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private final class MyRemoveFilterAction
    extends AnAction {
        private MyRemoveFilterAction() {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), AndroidBundle.message("android.logcat.remove.logcat.filter.button", new Object[0]), IconUtil.getRemoveIcon());
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)EditLogFilterDialog.this.myFiltersList);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRemoveFilterAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(EditLogFilterDialog.this.getSelectedFilterName() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRemoveFilterAction.$$$reportNull$$$0(1);
            }
            int i2 = EditLogFilterDialog.this.myFiltersList.getSelectedIndex();
            EditLogFilterDialog.this.myFilters.remove(i2);
            EditLogFilterDialog.this.myFiltersListModel.remove(i2);
            EditLogFilterDialog.this.myActiveFilter = null;
            if (!EditLogFilterDialog.this.myFilters.isEmpty()) {
                if (i2 >= EditLogFilterDialog.this.myFilters.size()) {
                    i2 = EditLogFilterDialog.this.myFilters.size() - 1;
                }
                EditLogFilterDialog.this.myActiveFilter = (PersistentAndroidLogFilters.FilterData)EditLogFilterDialog.this.myFilters.get(i2);
            }
            EditLogFilterDialog.this.updateFilters();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/android/tools/idea/logcat/EditLogFilterDialog$MyRemoveFilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyAddFilterAction
    extends AnAction {
        private MyAddFilterAction() {
            super(CommonBundle.message((String)"button.add", (Object[])new Object[0]), AndroidBundle.message("android.logcat.add.logcat.filter.button", new Object[0]), IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)EditLogFilterDialog.this.myFiltersList);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyAddFilterAction.$$$reportNull$$$0(0);
            }
            EditLogFilterDialog.this.myActiveFilter = EditLogFilterDialog.this.createNewFilter();
            EditLogFilterDialog.this.myFiltersListModel.add((Object)EditLogFilterDialog.this.myActiveFilter.getName());
            EditLogFilterDialog.this.updateFilters();
            IdeFocusManager manager = IdeFocusManager.getGlobalInstance();
            manager.doWhenFocusSettlesDown(() -> manager.requestFocus((Component)EditLogFilterDialog.this.myFilterNameField, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/logcat/EditLogFilterDialog$MyAddFilterAction", "actionPerformed"));
        }
    }
}

