/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.project.AndroidNotification;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class OpenFirebaseAssistantQuickFix
implements AndroidLintQuickFix {
    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        if (startElement == null) {
            OpenFirebaseAssistantQuickFix.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            OpenFirebaseAssistantQuickFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OpenFirebaseAssistantQuickFix.$$$reportNull$$$0(2);
        }
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(dataContext -> {
            AnAction openFirebaseAssistant = ActionManager.getInstance().getAction("DeveloperServices.Firebase");
            if (openFirebaseAssistant == null) {
                ApplicationManager.getApplication().invokeLater(this::reportFirebaseNotAvailable);
                return;
            }
            AnActionEvent openFirebaseAssistantEvent = AnActionEvent.createFromAnAction((AnAction)openFirebaseAssistant, null, (String)"Android Lint QuickFix", (DataContext)dataContext);
            openFirebaseAssistant.actionPerformed(openFirebaseAssistantEvent);
        });
    }

    private void reportFirebaseNotAvailable() {
        String message = String.format("<html>Firebase Assistant is not available. The Firebase Services plugin has to be enabled in the <a href=\"plugins\">Plugins</a> dialog in %1$s.</html>", ShowSettingsUtil.getSettingsMenuName());
        NotificationListener listener2 = (notification, event) -> {
            ShowSettingsUtil.getInstance().showSettingsDialog(null, PluginManagerConfigurable.class);
            notification.expire();
        };
        Notification notification2 = AndroidNotification.BALLOON_GROUP.createNotification(this.getName(), message, NotificationType.WARNING, listener2);
        notification2.notify(null);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            OpenFirebaseAssistantQuickFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            OpenFirebaseAssistantQuickFix.$$$reportNull$$$0(4);
        }
        if (contextType == null) {
            OpenFirebaseAssistantQuickFix.$$$reportNull$$$0(5);
        }
        return startElement.getText().startsWith("'com.google.android.gms:play-services:");
    }

    @Override
    @NotNull
    public String getName() {
        String string = AndroidBundle.message("android.lint.fix.open.firebase.assistant", new Object[0]);
        if (string == null) {
            OpenFirebaseAssistantQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/OpenFirebaseAssistantQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/OpenFirebaseAssistantQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

