/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.lint.AddTargetVersionCheckQuickFix;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.lint.checks.ApiDetector;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AddTargetApiQuickFix
implements AndroidLintQuickFix {
    private final boolean myRequiresApi;
    private int myApi;
    private PsiElement myElement;

    public AddTargetApiQuickFix(int api, boolean requiresApi, PsiElement element) {
        this.myApi = api;
        this.myRequiresApi = requiresApi;
        this.myElement = element;
    }

    private String getAnnotationValue(boolean fullyQualified) {
        return AddTargetVersionCheckQuickFix.getVersionField(this.myApi, fullyQualified);
    }

    @Override
    @NotNull
    public String getName() {
        String key = this.getAnnotationValue(false);
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiFile.class);
        if (file instanceof XmlFile) {
            if ("Suppress With tools:targetApi Attribute" == null) {
                AddTargetApiQuickFix.$$$reportNull$$$0(0);
            }
            return "Suppress With tools:targetApi Attribute";
        }
        if (this.myRequiresApi) {
            String string = AndroidBundle.message("android.lint.fix.add.requires.api", key);
            if (string == null) {
                AddTargetApiQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = AndroidBundle.message("android.lint.fix.add.target.api", key);
        if (string == null) {
            AddTargetApiQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            AddTargetApiQuickFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            AddTargetApiQuickFix.$$$reportNull$$$0(4);
        }
        if (contextType == null) {
            AddTargetApiQuickFix.$$$reportNull$$$0(5);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiModifierListOwner.class, (boolean)false) != null || PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false) != null;
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiModifierListOwner container;
        if (startElement == null) {
            AddTargetApiQuickFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            AddTargetApiQuickFix.$$$reportNull$$$0(7);
        }
        if (context == null) {
            AddTargetApiQuickFix.$$$reportNull$$$0(8);
        }
        if ((container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)startElement, (Class[])new Class[]{PsiMethod.class, PsiClass.class})) == null) {
            XmlFile file;
            XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            if (element != null && (file = (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)element, XmlFile.class, (boolean)false)) != null) {
                AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
                String codeName = SdkVersionInfo.getBuildCode((int)this.myApi);
                codeName = codeName == null ? Integer.toString(this.myApi) : StringUtil.toLowerCase((String)codeName);
                element.setAttribute("targetApi", "http://schemas.android.com/tools", codeName);
            }
            return;
        }
        while (container instanceof PsiAnonymousClass) {
            container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        }
        if (container == null) {
            return;
        }
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            String annotationText;
            String fqcn;
            Project project = startElement.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            if (this.myRequiresApi) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)startElement);
                fqcn = DependencyManagementUtil.mapAndroidxName(module, ApiDetector.REQUIRES_API_ANNOTATION);
                annotationText = "@" + fqcn + "(api=" + this.getAnnotationValue(true) + ")";
            } else {
                fqcn = "android.annotation.TargetApi";
                annotationText = "@" + fqcn + "(" + this.getAnnotationValue(true) + ")";
            }
            PsiAnnotation newAnnotation = elementFactory.createAnnotationFromText(annotationText, (PsiElement)container);
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)container, (String[])new String[]{"android.annotation.TargetApi"});
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                AddAnnotationFix fix = new AddAnnotationFix(fqcn, container, attributes, new String[0]);
                fix.invoke(project, null, container.getContainingFile());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AddTargetApiQuickFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AddTargetApiQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

