/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.ng.NewGradleSync;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.android.tools.idea.gradle.project.sync.setup.module.android.AndroidVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.module.ndk.NdkVariantChangeModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildVariantUpdater {
    @NotNull
    private final ModuleSetupContext.Factory myModuleSetupContextFactory;
    @NotNull
    private final IdeModifiableModelsProviderFactory myModifiableModelsProviderFactory;
    @NotNull
    private final AndroidVariantChangeModuleSetup myAndroidModuleSetupSteps;
    @NotNull
    private final NdkVariantChangeModuleSetup myNdkModuleSetupSteps;
    @NotNull
    private final List<BuildVariantView.BuildVariantSelectionChangeListener> mySelectionChangeListeners;

    @NotNull
    public static BuildVariantUpdater getInstance(@NotNull Project project) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(0);
        }
        BuildVariantUpdater buildVariantUpdater = (BuildVariantUpdater)ServiceManager.getService((Project)project, BuildVariantUpdater.class);
        if (buildVariantUpdater == null) {
            BuildVariantUpdater.$$$reportNull$$$0(1);
        }
        return buildVariantUpdater;
    }

    BuildVariantUpdater() {
        this(new ModuleSetupContext.Factory(), new IdeModifiableModelsProviderFactory(), new AndroidVariantChangeModuleSetup(), new NdkVariantChangeModuleSetup());
    }

    @VisibleForTesting
    BuildVariantUpdater(@NotNull ModuleSetupContext.Factory moduleSetupContextFactory, @NotNull IdeModifiableModelsProviderFactory modifiableModelsProviderFactory, @NotNull AndroidVariantChangeModuleSetup androidModuleSetup, @NotNull NdkVariantChangeModuleSetup ndkModuleSetup) {
        if (moduleSetupContextFactory == null) {
            BuildVariantUpdater.$$$reportNull$$$0(2);
        }
        if (modifiableModelsProviderFactory == null) {
            BuildVariantUpdater.$$$reportNull$$$0(3);
        }
        if (androidModuleSetup == null) {
            BuildVariantUpdater.$$$reportNull$$$0(4);
        }
        if (ndkModuleSetup == null) {
            BuildVariantUpdater.$$$reportNull$$$0(5);
        }
        this.myModuleSetupContextFactory = moduleSetupContextFactory;
        this.myModifiableModelsProviderFactory = modifiableModelsProviderFactory;
        this.myAndroidModuleSetupSteps = androidModuleSetup;
        this.myNdkModuleSetupSteps = ndkModuleSetup;
        this.mySelectionChangeListeners = new ArrayList<BuildVariantView.BuildVariantSelectionChangeListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        if (listener2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(6);
        }
        List<BuildVariantView.BuildVariantSelectionChangeListener> list = this.mySelectionChangeListeners;
        synchronized (list) {
            this.mySelectionChangeListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangeListener(@NotNull BuildVariantView.BuildVariantSelectionChangeListener listener2) {
        if (listener2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(7);
        }
        List<BuildVariantView.BuildVariantSelectionChangeListener> list = this.mySelectionChangeListeners;
        synchronized (list) {
            this.mySelectionChangeListeners.remove(listener2);
        }
    }

    void updateSelectedVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(8);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(9);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(10);
        }
        ArrayList<AndroidFacet> affectedAndroidFacets = new ArrayList<AndroidFacet>();
        ArrayList<NdkFacet> affectedNdkFacets = new ArrayList<NdkFacet>();
        boolean variantToUpdateExists = BuildVariantUpdater.findAndUpdateAffectedFacets(project, moduleName, buildVariantName, affectedAndroidFacets, affectedNdkFacets);
        if (affectedAndroidFacets.isEmpty() && affectedNdkFacets.isEmpty()) {
            return;
        }
        Runnable invokeVariantSelectionChangeListeners = () -> {
            List<BuildVariantView.BuildVariantSelectionChangeListener> list = this.mySelectionChangeListeners;
            synchronized (list) {
                for (BuildVariantView.BuildVariantSelectionChangeListener listener2 : this.mySelectionChangeListeners) {
                    listener2.selectionChanged();
                }
            }
        };
        if (BuildVariantUpdater.hasBuildFilesChanged(project)) {
            BuildVariantUpdater.requestFullGradleSync(project, invokeVariantSelectionChangeListeners);
        } else if (!variantToUpdateExists) {
            BuildVariantUpdater.requestVariantOnlyGradleSync(project, moduleName, buildVariantName, invokeVariantSelectionChangeListeners);
        } else {
            GradleProjects.executeProjectChanges(project, () -> {
                this.setUpModules(buildVariantName, affectedAndroidFacets, affectedNdkFacets);
                PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
                setupRequest.generateSourcesAfterSync = false;
                setupRequest.cleanProjectAfterSync = false;
                PostSyncProjectSetup.getInstance(project).setUpProject(setupRequest, (ProgressIndicator)new EmptyProgressIndicator(), null);
                BuildVariantUpdater.generateSourcesIfNeeded(project, affectedAndroidFacets);
            });
            Application application = ApplicationManager.getApplication();
            if (application.isUnitTestMode()) {
                invokeVariantSelectionChangeListeners.run();
            } else {
                application.invokeLater(invokeVariantSelectionChangeListeners);
            }
        }
    }

    private static boolean findAndUpdateAffectedFacets(@NotNull Project project, @NotNull String moduleName, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        AndroidModuleModel androidModel;
        NdkModuleModel ndkModuleModel;
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(11);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(12);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(13);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(14);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(15);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find module '%1$s'.", moduleName));
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, msg);
        }
        boolean ndkVariantExists = true;
        boolean androidVariantExists = true;
        String variantName = variantToSelect;
        if (ndkFacet != null && (ndkModuleModel = BuildVariantUpdater.getNativeAndroidModel(ndkFacet, variantToSelect)) != null) {
            ndkVariantExists = BuildVariantUpdater.updateAffectedFacetsForNdkModule(ndkFacet, ndkModuleModel, variantToSelect, affectedNdkFacets);
            variantName = ndkModuleModel.getVariantName(variantToSelect);
        }
        if (androidFacet != null && (androidModel = BuildVariantUpdater.getAndroidModel(androidFacet, variantName)) != null) {
            androidVariantExists = BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, androidFacet, androidModel, variantName, affectedAndroidFacets);
        }
        return ndkVariantExists && androidVariantExists;
    }

    private static boolean updateAffectedFacetsForNdkModule(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull String variantToSelect, @NotNull List<NdkFacet> affectedFacets) {
        if (ndkFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(16);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(17);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(18);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(19);
        }
        if (variantToSelect.equals(ndkModuleModel.getSelectedVariant().getName())) {
            return true;
        }
        affectedFacets.add(ndkFacet);
        ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = variantToSelect;
        boolean variantToSelectExists = ndkModuleModel.variantExists(variantToSelect);
        if (variantToSelectExists) {
            ndkModuleModel.setSelectedVariantName(variantToSelect);
        }
        return variantToSelectExists;
    }

    private static boolean updateAffectedFacetsForAndroidModule(@NotNull Project project, @NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(20);
        }
        if (androidFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(21);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(22);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(23);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(24);
        }
        if (variantToSelect.equals(androidModel.getSelectedVariant().getName())) {
            return true;
        }
        affectedFacets.add(androidFacet);
        androidFacet.getProperties().SELECTED_BUILD_VARIANT = variantToSelect;
        boolean variantToSelectExists = androidModel.variantExists(variantToSelect);
        if (variantToSelectExists) {
            androidModel.setSelectedVariantName(variantToSelect);
            androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
            BuildVariantUpdater.updateSelectedVariantsForDependencyModules(project, androidModel, affectedFacets);
        }
        return variantToSelectExists;
    }

    private static void updateSelectedVariantsForDependencyModules(@NotNull Project project, @NotNull AndroidModuleModel androidModel, @NotNull List<AndroidFacet> affectedFacets) {
        Module dependencyModule;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(25);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(26);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(27);
        }
        for (Library library : androidModel.getSelectedMainCompileLevel2Dependencies().getModuleDependencies()) {
            if (!StringUtil.isNotEmpty((String)library.getVariant()) || !StringUtil.isNotEmpty((String)library.getProjectPath())) continue;
            dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleFromLibrary(library);
            BuildVariantUpdater.updateDependencyModule(project, library.getProjectPath(), dependencyModule, library.getVariant(), affectedFacets);
        }
        for (String gradlePath : androidModel.getAndroidProject().getDynamicFeatures()) {
            if (!StringUtil.isNotEmpty((String)gradlePath)) continue;
            dependencyModule = ProjectStructure.getInstance(project).getModuleFinder().findModuleByGradlePath(gradlePath);
            BuildVariantUpdater.updateDependencyModule(project, gradlePath, dependencyModule, androidModel.getSelectedVariant().getName(), affectedFacets);
        }
    }

    private static void updateDependencyModule(@NotNull Project project, @NotNull String gradlePath, @Nullable Module dependencyModule, @NotNull String projectVariant, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(28);
        }
        if (gradlePath == null) {
            BuildVariantUpdater.$$$reportNull$$$0(29);
        }
        if (projectVariant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(30);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(31);
        }
        if (dependencyModule == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(projectVariant, String.format("Cannot find module with Gradle path '%1$s'.", gradlePath));
            return;
        }
        AndroidFacet dependencyFacet = AndroidFacet.getInstance(dependencyModule);
        if (dependencyFacet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(projectVariant, String.format("Cannot find 'Android' facet in module '%1$s'.", dependencyModule.getName()));
            return;
        }
        AndroidModuleModel dependencyModel = BuildVariantUpdater.getAndroidModel(dependencyFacet, projectVariant);
        if (dependencyModel != null) {
            BuildVariantUpdater.updateAffectedFacetsForAndroidModule(project, dependencyFacet, dependencyModel, projectVariant, affectedFacets);
        }
    }

    private static boolean hasBuildFilesChanged(@NotNull Project project) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(32);
        }
        return GradleSyncState.getInstance(project).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private static void requestFullGradleSync(@NotNull Project project, @NotNull Runnable variantSelectionChangeListeners) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(33);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(34);
        }
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
    }

    @NotNull
    private static GradleSyncListener getSyncListener(final @NotNull Runnable variantSelectionChangeListeners) {
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(35);
        }
        GradleSyncListener gradleSyncListener = new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                variantSelectionChangeListeners.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$1", "syncSucceeded"));
            }
        };
        if (gradleSyncListener == null) {
            BuildVariantUpdater.$$$reportNull$$$0(36);
        }
        return gradleSyncListener;
    }

    private static void requestVariantOnlyGradleSync(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName, @NotNull Runnable variantSelectionChangeListeners) {
        GradleFacet gradleFacet;
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(37);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(38);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(39);
        }
        if (variantSelectionChangeListeners == null) {
            BuildVariantUpdater.$$$reportNull$$$0(40);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName)) != null && (gradleFacet = GradleFacet.getInstance(moduleToUpdate)) != null) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(moduleToUpdate);
            NdkModuleModel ndkModuleModel = NdkModuleModel.get(moduleToUpdate);
            GradleModuleModel gradleModel = gradleFacet.getGradleModuleModel();
            if (androidModel != null && gradleModel != null) {
                GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_VARIANT_SELECTION_CHANGED_BY_USER);
                String variantName = buildVariantName;
                String abiName = null;
                if (ndkModuleModel != null) {
                    variantName = ndkModuleModel.getVariantName(buildVariantName);
                    abiName = ndkModuleModel.getAbiName(buildVariantName);
                }
                boolean isCompoundSyncEnabled = NewGradleSync.isCompoundSync(project);
                request.variantOnlySyncOptions = new VariantOnlySyncOptions(gradleModel.getRootFolderPath(), gradleModel.getGradlePath(), variantName, abiName, isCompoundSyncEnabled);
                request.generateSourcesOnSuccess = true;
                GradleSyncInvoker.getInstance().requestProjectSync(project, request, BuildVariantUpdater.getSyncListener(variantSelectionChangeListeners));
            }
        }
    }

    private void setUpModules(@NotNull String variant, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNdkFacets) {
        if (variant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(41);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(42);
        }
        if (affectedNdkFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(43);
        }
        for (NdkFacet ndkFacet : affectedNdkFacets) {
            NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNativeAndroidModel(ndkFacet, variant);
            if (ndkModuleModel == null) continue;
            this.setUpModule(ndkFacet.getModule(), ndkModuleModel);
        }
        for (AndroidFacet androidFacet : affectedAndroidFacets) {
            AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet, variant);
            if (androidModel == null) continue;
            this.setUpModule(androidFacet.getModule(), androidModel);
        }
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(44);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(45);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private static void generateSourcesIfNeeded(@NotNull Project project, @NotNull List<AndroidFacet> affectedFacets) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(46);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(47);
        }
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            GradleProjectBuilder.getInstance(project).generateSources();
        }
    }

    private void setUpModule(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(48);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(49);
        }
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
        try {
            this.myAndroidModuleSetupSteps.setUpModule(context, androidModel);
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    private void setUpModule(@NotNull Module module, @NotNull NdkModuleModel ndkModuleModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(50);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(51);
        }
        IdeModifiableModelsProvider modelsProvider = this.myModifiableModelsProviderFactory.create(module.getProject());
        ModuleSetupContext context = this.myModuleSetupContextFactory.create(module, modelsProvider);
        try {
            this.myNdkModuleSetupSteps.setUpModule(context, ndkModuleModel);
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(52);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(53);
        }
        if ((androidModel = AndroidModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNativeAndroidModel(@NotNull NdkFacet facet, @NotNull String variantToSelect) {
        NdkModuleModel ndkModuleModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(54);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(55);
        }
        if ((ndkModuleModel = NdkModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return ndkModuleModel;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(56);
        }
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(57);
        }
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        BuildVariantUpdater.getLog().error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(BuildVariantUpdater.class);
        if (logger == null) {
            BuildVariantUpdater.$$$reportNull$$$0(58);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 36: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 36: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 36: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetupContextFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProviderFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModuleSetup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleSetup";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: 
            case 12: 
            case 38: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 10: 
            case 39: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariantName";
                break;
            }
            case 13: 
            case 18: 
            case 23: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantToSelect";
                break;
            }
            case 14: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedAndroidFacets";
                break;
            }
            case 15: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedNdkFacets";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 17: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 19: 
            case 24: 
            case 27: 
            case 31: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFacets";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 22: 
            case 26: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectVariant";
                break;
            }
            case 34: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantSelectionChangeListeners";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncListener";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 36: 
            case 58: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionChangeListener";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariant";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAndUpdateAffectedFacets";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedFacetsForNdkModule";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateAffectedFacetsForAndroidModule";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariantsForDependencyModules";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateDependencyModule";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasBuildFilesChanged";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "requestFullGradleSync";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getSyncListener";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "requestVariantOnlyGradleSync";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "setUpModules";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "generateSourcesIfNeeded";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getNativeAndroidModel";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowUpdateFailure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 36: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class IdeModifiableModelsProviderFactory {
        IdeModifiableModelsProviderFactory() {
        }

        @NotNull
        IdeModifiableModelsProvider create(@NotNull Project project) {
            if (project == null) {
                IdeModifiableModelsProviderFactory.$$$reportNull$$$0(0);
            }
            IdeModifiableModelsProviderImpl ideModifiableModelsProviderImpl = new IdeModifiableModelsProviderImpl(project);
            if (ideModifiableModelsProviderImpl == null) {
                IdeModifiableModelsProviderFactory.$$$reportNull$$$0(1);
            }
            return ideModifiableModelsProviderImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$IdeModifiableModelsProviderFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater$IdeModifiableModelsProviderFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

