/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.profiles;

import com.android.builder.model.level2.Library;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import com.intellij.util.ui.tree.TreeUtil;
import icons.AndroidArtworkIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.android.util.BooleanCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectProfileSelectionDialog
extends DialogWrapper {
    private static final SimpleTextAttributes UNRESOLVED_ATTRIBUTES = new SimpleTextAttributes(4, SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor());
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<Conflict> myConflicts;
    @NotNull
    private final JPanel myPanel;
    private CheckboxTreeView myProjectStructureTree;
    private ConflictsTable myConflictsTable;
    private CheckboxTreeView myConflictTree;
    private DetailsComponent myConflictDetails;

    public ProjectProfileSelectionDialog(@NotNull Project project, @NotNull List<Conflict> conflicts) {
        if (project == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(0);
        }
        if (conflicts == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.myProject = project;
        this.myConflicts = conflicts;
        for (Conflict conflict : conflicts) {
            conflict.refreshStatus();
        }
        this.myPanel = new JPanel(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.35f);
        splitter.setHonorComponentsMinimumSize(true);
        this.myPanel.add((Component)splitter, "Center");
        splitter.setFirstComponent(this.createProjectStructurePanel());
        splitter.setSecondComponent(this.createConflictsPanel());
        this.init();
        this.myProjectStructureTree.expandAll();
    }

    @NotNull
    private JComponent createProjectStructurePanel() {
        this.createProjectStructureTree();
        DetailsComponent details = new DetailsComponent();
        details.setText(new String[]{"Project Structure"});
        details.setContent((JComponent)ProjectProfileSelectionDialog.createTreePanel(this.myProjectStructureTree));
        ProjectProfileSelectionDialog.removeEmptyBorder(details);
        JComponent jComponent = details.getComponent();
        if (jComponent == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    private void createProjectStructureTree() {
        CheckboxTree.CheckboxTreeCellRenderer renderer = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value2 instanceof DefaultMutableTreeNode) {
                    Object data = ((DefaultMutableTreeNode)value2).getUserObject();
                    ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                    if (data instanceof ModuleTreeElement) {
                        ModuleTreeElement moduleElement = (ModuleTreeElement)data;
                        textRenderer.append(moduleElement.myModule.getName());
                        if (!moduleElement.myConflicts.isEmpty()) {
                            boolean allResolved = true;
                            for (Conflict conflict : moduleElement.myConflicts) {
                                if (conflict.isResolved()) continue;
                                allResolved = false;
                                break;
                            }
                            SimpleTextAttributes attributes = allResolved ? UNRESOLVED_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
                            textRenderer.append(" ");
                            textRenderer.append(ProjectProfileSelectionDialog.this.myConflicts.size() == 1 ? "[Conflict]" : "[Conflicts]", attributes);
                        }
                        textRenderer.setIcon(AllIcons.Actions.Module);
                    } else if (data instanceof String) {
                        textRenderer.append((String)data, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                        textRenderer.setIcon(AndroidArtworkIcons.Icons.Variant);
                    } else if (data instanceof DependencyTreeElement) {
                        DependencyTreeElement dependency = (DependencyTreeElement)data;
                        textRenderer.append(dependency.myModule.getName());
                        if (!StringUtil.isEmpty((String)dependency.myVariant)) {
                            textRenderer.append(" (" + dependency.myVariant + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                        }
                        Icon icon = dependency.myConflict != null ? AllIcons.RunConfigurations.TestFailed : AllIcons.RunConfigurations.TestPassed;
                        textRenderer.setIcon(icon);
                    }
                }
            }
        };
        FilterAwareCheckedTreeNode rootNode = new FilterAwareCheckedTreeNode(null);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = moduleManager.getModules();
        Arrays.sort(modules, ModulesAlphaComparator.INSTANCE);
        HashMap modulesByGradlePath = Maps.newHashMap();
        for (Module module : modules) {
            String gradlePath = GradleUtil.getGradlePath(module);
            if (StringUtil.isEmpty((String)gradlePath)) continue;
            modulesByGradlePath.put(gradlePath, module);
            ModuleTreeElement moduleElement = new ModuleTreeElement(module);
            FilterAwareCheckedTreeNode moduleNode = new FilterAwareCheckedTreeNode(moduleElement);
            rootNode.add((MutableTreeNode)((Object)moduleNode));
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            HashMultimap dependenciesByVariant = HashMultimap.create();
            androidModel.getAndroidProject().forEachVariant(arg_0 -> this.lambda$createProjectStructureTree$0(modulesByGradlePath, (Multimap)dependenciesByVariant, arg_0));
            ArrayList variantNames = Lists.newArrayList((Iterable)dependenciesByVariant.keySet());
            Collections.sort(variantNames);
            ArrayList consolidatedVariants = Lists.newArrayList();
            ArrayList variantsToSkip = Lists.newArrayList();
            int variantCount = variantNames.size();
            for (int i2 = 0; i2 < variantCount; ++i2) {
                String variant1 = (String)variantNames.get(i2);
                if (variantsToSkip.contains(variant1)) continue;
                Collection set1 = dependenciesByVariant.get((Object)variant1);
                for (int j = i2 + 1; j < variantCount; ++j) {
                    String variant2 = (String)variantNames.get(j);
                    Collection set2 = dependenciesByVariant.get((Object)variant2);
                    if (!set1.equals(set2)) continue;
                    variantsToSkip.add(variant2);
                    if (!consolidatedVariants.contains(variant1)) {
                        consolidatedVariants.add(variant1);
                    }
                    consolidatedVariants.add(variant2);
                }
                String variantName = variant1;
                if (!consolidatedVariants.isEmpty()) {
                    variantName = Joiner.on((String)", ").join((Iterable)consolidatedVariants);
                }
                DefaultMutableTreeNode variantNode = new DefaultMutableTreeNode(variantName);
                moduleNode.add(variantNode);
                ArrayList dependencyElements = Lists.newArrayList((Iterable)set1);
                Collections.sort(dependencyElements);
                for (DependencyTreeElement dependencyElement : dependencyElements) {
                    if (dependencyElement.myConflict != null) {
                        moduleElement.addConflict(dependencyElement.myConflict);
                    }
                    variantNode.add(new DefaultMutableTreeNode(dependencyElement));
                }
                consolidatedVariants.clear();
            }
        }
        this.myProjectStructureTree = new CheckboxTreeView(renderer, rootNode){

            protected void onNodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                Module module = null;
                Object data = node.getUserObject();
                if (data instanceof ModuleTreeElement) {
                    module = ((ModuleTreeElement)data).myModule;
                }
                if (module == null) {
                    return;
                }
                boolean updated = false;
                Enumeration variantNodes = ((ProjectProfileSelectionDialog)ProjectProfileSelectionDialog.this).myConflictTree.myRoot.children();
                while (variantNodes.hasMoreElements()) {
                    Object child = variantNodes.nextElement();
                    if (!(child instanceof CheckedTreeNode)) continue;
                    CheckedTreeNode variantNode = (CheckedTreeNode)child;
                    Enumeration moduleNodes = variantNode.children();
                    while (moduleNodes.hasMoreElements()) {
                        CheckedTreeNode moduleNode;
                        child = moduleNodes.nextElement();
                        if (!(child instanceof CheckedTreeNode) || !((data = (moduleNode = (CheckedTreeNode)child).getUserObject()) instanceof Conflict.AffectedModule)) continue;
                        Conflict.AffectedModule affected = (Conflict.AffectedModule)data;
                        boolean checked = node.isChecked();
                        if (!module.equals(affected.getTarget()) || moduleNode.isChecked() == checked) continue;
                        affected.setSelected(checked);
                        moduleNode.setChecked(checked);
                        updated = true;
                    }
                }
                if (updated) {
                    ProjectProfileSelectionDialog.this.repaintAll();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$2", "onNodeStateChanged"));
            }
        };
        this.myProjectStructureTree.getSelectionModel().setSelectionMode(1);
        this.myProjectStructureTree.setRootVisible(false);
    }

    @Nullable
    private Conflict getConflict(@NotNull Module source) {
        if (source == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(3);
        }
        for (Conflict conflict : this.myConflicts) {
            if (!source.equals(conflict.getSource())) continue;
            return conflict;
        }
        return null;
    }

    @NotNull
    private JComponent createConflictsPanel() {
        this.createConflictTree();
        this.myConflictDetails = new DetailsComponent();
        this.myConflictDetails.setText(new String[]{"Conflict Detail"});
        this.myConflictDetails.setContent((JComponent)ProjectProfileSelectionDialog.createTreePanel(this.myConflictTree));
        ProjectProfileSelectionDialog.removeEmptyBorder(this.myConflictDetails);
        this.createConflictsTable();
        this.myConflictsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.showConflictDetail();
        });
        Splitter splitter = new Splitter(true, 0.25f);
        splitter.setHonorComponentsMinimumSize(true);
        DetailsComponent details = new DetailsComponent();
        details.setText(new String[]{"Variant Selection Conflicts"});
        details.setContent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myConflictsTable)));
        ProjectProfileSelectionDialog.removeEmptyBorder(details);
        splitter.setFirstComponent(details.getComponent());
        splitter.setSecondComponent(this.myConflictDetails.getComponent());
        Splitter splitter2 = splitter;
        if (splitter2 == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(4);
        }
        return splitter2;
    }

    @NotNull
    static JPanel createTreePanel(@NotNull CheckboxTreeView tree) {
        if (tree == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(5);
        }
        JPanel treePanel = new JPanel(new BorderLayout());
        DefaultActionGroup group = new DefaultActionGroup();
        CommonActionsManager actions2 = CommonActionsManager.getInstance();
        group.addAll(new AnAction[]{actions2.createExpandAllAction((TreeExpander)tree, (JComponent)treePanel), actions2.createCollapseAllAction((TreeExpander)tree, (JComponent)treePanel)});
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar("AndroidProjectProfileSelection", (ActionGroup)group, true);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)actionToolBar.getComponent(), "Center");
        buttonsPanel.setBorder((Border)new SideBorder(JBColor.border(), 7, 1));
        treePanel.add((Component)buttonsPanel, "North");
        treePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)tree)), "Center");
        JPanel jPanel = treePanel;
        if (jPanel == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private static void removeEmptyBorder(@NotNull DetailsComponent details) {
        if (details == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(7);
        }
        JComponent gutter = details.getContentGutter();
        for (Component child : gutter.getComponents()) {
            if (!(child instanceof Wrapper)) continue;
            ((Wrapper)child).setBorder(null);
        }
    }

    private void createConflictsTable() {
        ConflictsTableModel tableModel = new ConflictsTableModel(this.myConflicts, (Function<List<ConflictTableRow>, Void>)((Function)rows -> {
            this.filterProjectStructure((List<ConflictTableRow>)rows);
            return null;
        }));
        this.myConflictsTable = new ConflictsTable(tableModel);
        if (!tableModel.myRows.isEmpty()) {
            this.showConflictDetail();
        }
    }

    private void showConflictDetail() {
        this.myConflictTree.myRoot.removeAllChildren();
        int selectedIndex = this.myConflictsTable.getSelectedRow();
        ConflictsTableModel tableModel = (ConflictsTableModel)this.myConflictsTable.getModel();
        ConflictTableRow row = tableModel.myRows.get(selectedIndex);
        Conflict conflict = row.myConflict;
        this.myConflictDetails.setText(new String[]{"Conflict Detail: " + conflict.getSource().getName()});
        ArrayList variants = Lists.newArrayList(conflict.getVariants());
        Collections.sort(variants);
        for (String variant : variants) {
            CheckedTreeNode variantNode = new CheckedTreeNode((Object)variant);
            this.myConflictTree.myRoot.add((MutableTreeNode)variantNode);
            for (Conflict.AffectedModule module : conflict.getModulesExpectingVariant(variant)) {
                CheckedTreeNode moduleNode = new CheckedTreeNode((Object)module);
                variantNode.add((MutableTreeNode)moduleNode);
            }
        }
        this.myConflictTree.reload();
        this.myConflictTree.expandAll();
    }

    private void filterProjectStructure(@NotNull List<ConflictTableRow> rows) {
        if (rows == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(8);
        }
        ArrayList selectedConflictSources = Lists.newArrayList();
        for (ConflictTableRow row : rows) {
            if (!row.myFilter) continue;
            selectedConflictSources.add(row.myConflict.getSource());
        }
        Enumeration moduleNodes = this.myProjectStructureTree.myRoot.children();
        while (moduleNodes.hasMoreElements()) {
            FilterAwareCheckedTreeNode moduleNode;
            Object data;
            boolean show = false;
            Object child = moduleNodes.nextElement();
            if (!(child instanceof FilterAwareCheckedTreeNode) || !((data = (moduleNode = (FilterAwareCheckedTreeNode)((Object)child)).getUserObject()) instanceof ModuleTreeElement)) continue;
            ModuleTreeElement moduleElement = (ModuleTreeElement)data;
            if (selectedConflictSources.isEmpty()) {
                show = true;
            } else {
                for (Conflict conflict : moduleElement.myConflicts) {
                    if (!selectedConflictSources.contains(conflict.getSource())) continue;
                    show = true;
                    break;
                }
                if (!show && selectedConflictSources.contains(moduleElement.myModule)) {
                    show = true;
                }
            }
            moduleNode.myVisible = show;
        }
        this.myProjectStructureTree.reload();
        this.myProjectStructureTree.expandAll();
    }

    private void createConflictTree() {
        CheckboxTree.CheckboxTreeCellRenderer renderer = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value2 instanceof DefaultMutableTreeNode) {
                    Object data = ((DefaultMutableTreeNode)value2).getUserObject();
                    ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                    if (data instanceof Conflict.AffectedModule) {
                        textRenderer.append(((Conflict.AffectedModule)data).getTarget().getName());
                        textRenderer.setIcon(AllIcons.Actions.Module);
                    } else if (data instanceof String) {
                        textRenderer.append((String)data, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                        textRenderer.setIcon(AndroidArtworkIcons.Icons.Variant);
                    }
                }
            }
        };
        FilterAwareCheckedTreeNode root = new FilterAwareCheckedTreeNode(null);
        this.myConflictTree = new CheckboxTreeView(renderer, root){

            protected void onNodeStateChanged(@NotNull CheckedTreeNode node) {
                Object data;
                if (node == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!((data = node.getUserObject()) instanceof Conflict.AffectedModule)) {
                    return;
                }
                Conflict.AffectedModule affected = (Conflict.AffectedModule)data;
                Module module = affected.getTarget();
                Enumeration moduleNodes = ((ProjectProfileSelectionDialog)ProjectProfileSelectionDialog.this).myProjectStructureTree.myRoot.children();
                while (moduleNodes.hasMoreElements()) {
                    CheckedTreeNode moduleNode;
                    Object child = moduleNodes.nextElement();
                    if (!(child instanceof CheckedTreeNode) || !((data = (moduleNode = (CheckedTreeNode)child).getUserObject()) instanceof ModuleTreeElement)) continue;
                    ModuleTreeElement moduleElement = (ModuleTreeElement)data;
                    boolean checked = node.isChecked();
                    if (!module.equals(moduleElement.myModule) || moduleNode.isChecked() == checked) continue;
                    moduleNode.setChecked(checked);
                    affected.setSelected(checked);
                    ProjectProfileSelectionDialog.this.repaintAll();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$4", "onNodeStateChanged"));
            }
        };
    }

    private void repaintAll() {
        this.myConflictsTable.repaint();
        this.myConflictTree.repaint();
        this.myProjectStructureTree.repaint();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ProjectProfileSelectionDialog.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    private /* synthetic */ void lambda$createProjectStructureTree$0(Map modulesByGradlePath, Multimap dependenciesByVariant, IdeVariant variant) {
        for (Library library : GradleUtil.getModuleDependencies(variant)) {
            String libraryPath = library.getProjectPath();
            if (libraryPath == null) continue;
            Module dependency = (Module)modulesByGradlePath.get(libraryPath);
            if (dependency == null) {
                dependency = GradleUtil.findModuleByGradlePath(this.myProject, libraryPath);
            }
            if (dependency == null) continue;
            Conflict conflict = this.getConflict(dependency);
            modulesByGradlePath.put(libraryPath, dependency);
            DependencyTreeElement dependencyElement = new DependencyTreeElement(dependency, libraryPath, library.getVariant(), conflict);
            dependenciesByVariant.put((Object)variant.getName(), (Object)dependencyElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectStructurePanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConflictsPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreePanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConflict";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTreePanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeEmptyBorder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterProjectStructure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DependencyTreeElement
    implements Comparable<DependencyTreeElement> {
        @NotNull
        final Module myModule;
        @NotNull
        final String myGradlePath;
        @Nullable
        final String myVariant;
        @Nullable
        final Conflict myConflict;

        DependencyTreeElement(@NotNull Module module, @NotNull String gradlePath, @Nullable String variant, @Nullable Conflict conflict) {
            if (module == null) {
                DependencyTreeElement.$$$reportNull$$$0(0);
            }
            if (gradlePath == null) {
                DependencyTreeElement.$$$reportNull$$$0(1);
            }
            this.myGradlePath = gradlePath;
            this.myVariant = variant;
            this.myModule = module;
            this.myConflict = conflict;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DependencyTreeElement that = (DependencyTreeElement)o;
            return Objects.equal((Object)this.myGradlePath, (Object)that.myGradlePath) && Objects.equal((Object)this.myVariant, (Object)that.myVariant);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.myGradlePath, this.myVariant});
        }

        @Override
        public int compareTo(@NotNull DependencyTreeElement other) {
            if (other == null) {
                DependencyTreeElement.$$$reportNull$$$0(2);
            }
            return Collator.getInstance().compare(this.myModule.getName(), other.myModule.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradlePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$DependencyTreeElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ModuleTreeElement {
        @NotNull
        final Module myModule;
        @NotNull
        final List<Conflict> myConflicts;

        ModuleTreeElement(@NotNull Module module) {
            if (module == null) {
                ModuleTreeElement.$$$reportNull$$$0(0);
            }
            this.myConflicts = Lists.newArrayList();
            this.myModule = module;
        }

        void addConflict(@NotNull Conflict conflict) {
            if (conflict == null) {
                ModuleTreeElement.$$$reportNull$$$0(1);
            }
            this.myConflicts.add(conflict);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflict";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$ModuleTreeElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addConflict";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FilterAwareCheckedTreeNode
    extends CheckedTreeNode {
        boolean myVisible = true;

        FilterAwareCheckedTreeNode(@Nullable Object userObject) {
            super(userObject);
        }

        public TreeNode getChildAt(int index) {
            if (this.children == null) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
            int realIndex = -1;
            int visibleIndex = -1;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                Object child = e.nextElement();
                if (child instanceof FilterAwareCheckedTreeNode) {
                    FilterAwareCheckedTreeNode node = (FilterAwareCheckedTreeNode)((Object)child);
                    if (node.myVisible) {
                        ++visibleIndex;
                    }
                } else {
                    ++visibleIndex;
                }
                ++realIndex;
                if (visibleIndex != index) continue;
                return (TreeNode)this.children.elementAt(realIndex);
            }
            throw new ArrayIndexOutOfBoundsException("index unmatched");
        }

        public int getChildCount() {
            if (this.children == null) {
                return 0;
            }
            int count = 0;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                Object child = e.nextElement();
                if (child instanceof FilterAwareCheckedTreeNode) {
                    FilterAwareCheckedTreeNode node = (FilterAwareCheckedTreeNode)((Object)child);
                    if (!node.myVisible) continue;
                    ++count;
                    continue;
                }
                ++count;
            }
            return count;
        }
    }

    private static abstract class CheckboxTreeView
    extends CheckboxTree
    implements TreeExpander {
        @NotNull
        final CheckedTreeNode myRoot;

        CheckboxTreeView(@NotNull CheckboxTree.CheckboxTreeCellRenderer cellRenderer2, @NotNull CheckedTreeNode root) {
            if (cellRenderer2 == null) {
                CheckboxTreeView.$$$reportNull$$$0(0);
            }
            if (root == null) {
                CheckboxTreeView.$$$reportNull$$$0(1);
            }
            super(cellRenderer2, root);
            this.myRoot = root;
        }

        public void expandAll() {
            TreeUtil.expandAll((JTree)((Object)this));
        }

        public boolean canExpand() {
            return this.canCollapse();
        }

        public void collapseAll() {
            TreeUtil.collapseAll((JTree)((Object)this), (int)1);
        }

        public boolean canCollapse() {
            return this.myRoot.getChildCount() > 0;
        }

        public DefaultTreeModel getModel() {
            return (DefaultTreeModel)super.getModel();
        }

        void reload() {
            ((DefaultTreeModel)super.getModel()).reload();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$CheckboxTreeView";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConflictTableRow
    implements Comparable<ConflictTableRow> {
        final Conflict myConflict;
        boolean myFilter;

        ConflictTableRow(Conflict conflict) {
            this.myConflict = conflict;
        }

        @Override
        public int compareTo(@NotNull ConflictTableRow other) {
            if (other == null) {
                ConflictTableRow.$$$reportNull$$$0(0);
            }
            return Collator.getInstance().compare(this.myConflict.getSource().getName(), other.myConflict.getSource().getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$ConflictTableRow", "compareTo"));
        }
    }

    private static class ConflictsTableModel
    extends DefaultTableModel {
        static final Object[] COLUMN_NAMES = new Object[]{"Filter", "Source", "Resolved"};
        static final int FILTER_COLUMN = 0;
        static final int SOURCE_COLUMN = 1;
        static final int RESOLVED_COLUMN = 2;
        final List<ConflictTableRow> myRows;
        final Function<List<ConflictTableRow>, Void> myFilterFunction;

        ConflictsTableModel(@NotNull List<Conflict> conflicts, Function<List<ConflictTableRow>, Void> filterFunction) {
            if (conflicts == null) {
                ConflictsTableModel.$$$reportNull$$$0(0);
            }
            super(COLUMN_NAMES, conflicts.size());
            this.myRows = Lists.newArrayList();
            this.myFilterFunction = filterFunction;
            for (Conflict conflict : conflicts) {
                this.myRows.add(new ConflictTableRow(conflict));
            }
            Collections.sort(this.myRows);
        }

        @Override
        public Object getValueAt(int row, int column) {
            ConflictTableRow tableRow = this.myRows.get(row);
            switch (column) {
                case 0: {
                    return tableRow.myFilter;
                }
                case 1: {
                    return tableRow.myConflict.getSource().getName();
                }
                case 2: {
                    return tableRow.myConflict.isResolved();
                }
            }
            throw new IllegalArgumentException(String.format("Column index '%d' is not valid", column));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0 && aValue instanceof Boolean) {
                ConflictTableRow conflictTableRow = this.myRows.get(row);
                conflictTableRow.myFilter = (Boolean)aValue;
                this.myFilterFunction.fun(this.myRows);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conflicts", "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$ConflictsTableModel", "<init>"));
        }
    }

    private static class ConflictsTable
    extends JBTable {
        ConflictsTable(@NotNull ConflictsTableModel model) {
            if (model == null) {
                ConflictsTable.$$$reportNull$$$0(0);
            }
            super((TableModel)model);
            this.setSelectionMode(0);
            if (!model.myRows.isEmpty()) {
                this.getSelectionModel().setSelectionInterval(0, 0);
            }
            TableColumn filterColumn = this.getColumnByIndex(0);
            filterColumn.setCellEditor((TableCellEditor)new BooleanTableCellEditor());
            ConflictsTable.setUpBooleanColumn(filterColumn, true);
            TableColumn resolvedColumn = this.getColumnByIndex(2);
            ConflictsTable.setUpBooleanColumn(resolvedColumn, false);
        }

        private static void setUpBooleanColumn(@NotNull TableColumn column, boolean editable) {
            if (column == null) {
                ConflictsTable.$$$reportNull$$$0(1);
            }
            Object renderer = editable ? new BooleanTableCellRenderer() : new BooleanCellRenderer();
            column.setCellRenderer((TableCellRenderer)renderer);
            column.setMaxWidth(50);
        }

        @NotNull
        private TableColumn getColumnByIndex(int index) {
            TableColumn tableColumn = this.getColumn(this.getColumnName(index));
            if (tableColumn == null) {
                ConflictsTable.$$$reportNull$$$0(2);
            }
            return tableColumn;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$ConflictsTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/profiles/ProjectProfileSelectionDialog$ConflictsTable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnByIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setUpBooleanColumn";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

