/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class Header
extends JPanel {
    @NotNull
    private final String myTitle;
    private JPanel myButtonPanel;
    private BufferedImage myImage;
    private BufferedImage myActiveImage;
    private final EventDispatcher<ActivationListener> myEventDispatcher;

    public Header(@NotNull String title) {
        if (title == null) {
            Header.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myEventDispatcher = EventDispatcher.create(ActivationListener.class);
        this.myTitle = title;
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(BaseLabel.getLabelFont());
        titleLabel.setForeground(JBColor.foreground());
        titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.add((Component)titleLabel, "Center");
        MouseAdapter mouseListener2 = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((ActivationListener)Header.this.myEventDispatcher.getMulticaster()).activated();
            }
        };
        titleLabel.addMouseListener(mouseListener2);
        this.addMouseListener(mouseListener2);
        this.myButtonPanel = new JPanel();
        this.myButtonPanel.setOpaque(false);
        this.myButtonPanel.setLayout(new BoxLayout(this.myButtonPanel, 0));
        this.myButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.add((Component)this.myButtonPanel, "East");
        this.setBorder((Border)JBUI.Borders.empty());
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            Header.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage image;
        Rectangle r = this.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        if (this.isActive()) {
            if (this.myActiveImage == null) {
                this.myActiveImage = Header.drawToBuffer(true, r.height);
            }
            image = this.myActiveImage;
        } else {
            if (this.myImage == null) {
                this.myImage = Header.drawToBuffer(false, r.height);
            }
            image = this.myImage;
        }
        Rectangle clipBounds = g2d.getClip().getBounds();
        for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)0, null);
        }
    }

    @NotNull
    private static BufferedImage drawToBuffer(boolean active, int height) {
        int width = 150;
        BufferedImage image = UIUtil.createImage((int)width, (int)height, (int)2);
        Graphics2D g = image.createGraphics();
        UIUtil.drawHeader((Graphics)g, (int)0, (int)width, (int)height, (boolean)active, (boolean)true, (boolean)false, (boolean)true);
        g.dispose();
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            Header.$$$reportNull$$$0(2);
        }
        return bufferedImage;
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        UISettings.setupAntialiasing((Graphics)graphics);
        super.paintChildren(graphics);
        Rectangle r = this.getBounds();
        if (!this.isActive() && !UIUtil.isUnderDarcula()) {
            graphics.setColor(new Color(255, 255, 255, 30));
            graphics.fill(r);
        }
        graphics.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        return new Dimension(size.width, TabsUtil.getTabsHeight());
    }

    public void setAdditionalActions(@NotNull List<AnAction> actions2) {
        if (actions2 == null) {
            Header.$$$reportNull$$$0(3);
        }
        this.setAdditionalActions(actions2.toArray(AnAction.EMPTY_ARRAY));
    }

    public void setAdditionalActions(AnAction ... actions2) {
        if (actions2 == null) {
            Header.$$$reportNull$$$0(4);
        }
        this.myButtonPanel.removeAll();
        this.myButtonPanel.revalidate();
        this.myButtonPanel.repaint();
        int actionCount = actions2.length;
        for (int i2 = 0; i2 < actionCount; ++i2) {
            AnAction action2 = actions2[i2];
            if (action2 == null) continue;
            this.myButtonPanel.add((Component)((Object)new ActionButton(action2)));
            if (i2 >= actionCount - 1) continue;
            this.myButtonPanel.add(Box.createHorizontalStrut(9));
        }
    }

    public void addActivationListener(@NotNull ActivationListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            Header.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            Header.$$$reportNull$$$0(6);
        }
        this.myEventDispatcher.addListener((EventListener)listener2, parent);
    }

    public boolean isActive() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/ui/Header";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/ui/Header";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "drawToBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalActions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addActivationListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ActivationListener
    extends EventListener {
        public void activated();
    }

    private static class ActionButton
    extends Wrapper
    implements ActionListener {
        private final InplaceButton myButton;
        private final AnAction myAction;

        ActionButton(@NotNull AnAction action2) {
            Icon icon;
            if (action2 == null) {
                ActionButton.$$$reportNull$$$0(0);
            }
            this.myAction = action2;
            Icon hoveredIcon = null;
            if (action2 instanceof Separator) {
                icon = AllIcons.General.Divider;
            } else {
                icon = action2.getTemplatePresentation().getIcon();
                hoveredIcon = action2.getTemplatePresentation().getHoveredIcon();
            }
            if (hoveredIcon == null) {
                hoveredIcon = icon;
            }
            String toolTip = KeymapUtil.createTooltipText((String)action2.getTemplatePresentation().getText(), (AnAction)action2);
            this.myButton = new InplaceButton(toolTip, icon, (ActionListener)this);
            this.myButton.setIcons(icon, icon, hoveredIcon);
            this.myButton.setHoveringEnabled(!SystemInfo.isMac);
            this.setContent((JComponent)this.myButton);
            this.setOpaque(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
            ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
            InputEvent inputEvent = e.getSource() instanceof InputEvent ? (InputEvent)e.getSource() : null;
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)this.myAction, (InputEvent)inputEvent, (String)"unknown", (DataContext)dataContext);
            actionManager.fireBeforeActionPerformed(this.myAction, dataContext, event);
            this.myAction.actionPerformed(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/android/tools/idea/gradle/util/ui/Header$ActionButton", "<init>"));
        }
    }
}

