/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectImportUtil;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import java.io.File;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleProjects {
    private static final Key<Boolean> SYNC_REQUESTED_DURING_BUILD = Key.create((String)"project.sync.requested.during.build");

    private GradleProjects() {
    }

    public static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (project == null) {
            GradleProjects.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            GradleProjects.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!project.isDisposed()) {
                ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
            }
        }));
    }

    public static void open(@NotNull Project project) {
        boolean fullScreen;
        IdeFocusManager instance;
        IdeFrame lastFocusedFrame;
        if (project == null) {
            GradleProjects.$$$reportNull$$$0(2);
        }
        ProjectUtil.updateLastProjectLocation((String)project.getBasePath());
        if (WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && (lastFocusedFrame = (instance = IdeFocusManager.findInstance()).getLastFocusedFrame()) instanceof IdeFrameEx && (fullScreen = ((IdeFrameEx)lastFocusedFrame).isInFullScreen())) {
            project.putUserData(IdeFrameImpl.SHOULD_OPEN_IN_FULL_SCREEN, (Object)Boolean.TRUE);
        }
        ProjectManagerEx.getInstanceEx().openProject(project);
    }

    public static boolean isOfflineBuildModeEnabled(@NotNull Project project) {
        if (project == null) {
            GradleProjects.$$$reportNull$$$0(3);
        }
        return GradleSettings.getInstance((Project)project).isOfflineWork();
    }

    @Nullable
    public static AndroidModel getAndroidModel(@NotNull Module module) {
        AndroidFacet androidFacet;
        if (module == null) {
            GradleProjects.$$$reportNull$$$0(4);
        }
        return (androidFacet = AndroidFacet.getInstance(module)) != null ? ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel() : null;
    }

    @Deprecated
    @NotNull
    public static Module[] getModulesToBuildFromSelection(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            GradleProjects.$$$reportNull$$$0(5);
        }
        Module[] moduleArray = GradleProjectInfo.getInstance(project).getModulesToBuildFromSelection(dataContext);
        if (moduleArray == null) {
            GradleProjects.$$$reportNull$$$0(6);
        }
        return moduleArray;
    }

    @Nullable
    public static File findModuleRootFolderPath(@NotNull Module module) {
        if (module == null) {
            GradleProjects.$$$reportNull$$$0(7);
        }
        File moduleFilePath = FilePaths.toSystemDependentPath((String)module.getModuleFilePath());
        return moduleFilePath.getParentFile();
    }

    @Deprecated
    public static boolean isBuildWithGradle(@NotNull Project project) {
        if (project == null) {
            GradleProjects.$$$reportNull$$$0(8);
        }
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    public static boolean isGradleProjectModule(@NotNull Module module) {
        if (module == null) {
            GradleProjects.$$$reportNull$$$0(9);
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return false;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet != null && androidFacet.requiresAndroidModel() && GradleFacet.isAppliedTo(module)) {
            File moduleFilePath = FilePaths.toSystemDependentPath((String)module.getModuleFilePath());
            File moduleRootDirPath = moduleFilePath.getParentFile();
            return FileUtil.pathsEqual((String)moduleRootDirPath.getPath(), (String)module.getProject().getBasePath());
        }
        return !GradleFacet.isAppliedTo(module);
    }

    public static boolean canImportAsGradleProject(@NotNull VirtualFile importSource) {
        VirtualFile target;
        if (importSource == null) {
            GradleProjects.$$$reportNull$$$0(10);
        }
        return (target = ProjectImportUtil.findImportTarget(importSource)) != null && "gradle".equals(target.getExtension());
    }

    public static void setSyncRequestedDuringBuild(@NotNull Project project, @Nullable Boolean value2) {
        if (project == null) {
            GradleProjects.$$$reportNull$$$0(11);
        }
        project.putUserData(SYNC_REQUESTED_DURING_BUILD, (Object)value2);
    }

    public static boolean isSyncRequestedDuringBuild(@NotNull Project project) {
        if (project == null) {
            GradleProjects.$$$reportNull$$$0(12);
        }
        return (Boolean)SYNC_REQUESTED_DURING_BUILD.get((UserDataHolder)project, (Object)false);
    }

    public static boolean isIdeaAndroidModule(@NotNull Module module) {
        if (module == null) {
            GradleProjects.$$$reportNull$$$0(13);
        }
        if (GradleFacet.getInstance(module) != null || JavaFacet.getInstance(module) != null) {
            return true;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        return androidFacet != null && androidFacet.requiresAndroidModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleProjects";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleProjects";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBuildFromSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeProjectChanges";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOfflineBuildModeEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToBuildFromSelection";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModuleRootFolderPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBuildWithGradle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isGradleProjectModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canImportAsGradleProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSyncRequestedDuringBuild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSyncRequestedDuringBuild";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isIdeaAndroidModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

