/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.builder.model.ApiVersion;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenDependencyLookupDialog
extends DialogWrapper {
    private static final String AAR_PACKAGING = "@aar";
    private static final String JAR_PACKAGING = "@jar";
    private static final int RESULT_LIMIT = 50;
    private static final String MAVEN_CENTRAL_SEARCH_URL = "https://search.maven.org/solrsearch/select?rows=%d&wt=xml&q=%%22%s%%22";
    private static final Logger LOG = Logger.getInstance(MavenDependencyLookupDialog.class);
    private static final List<Artifact> COMMON_LIBRARIES = ImmutableList.of((Object)new Artifact("com.google.code.gson", "gson", "2.2.4", "GSON"), (Object)new Artifact("joda-time", "joda-time", "2.3", "Joda-time"), (Object)new Artifact("com.squareup.picasso", "picasso", "2.3.2", "Picasso"), (Object)new Artifact("com.squareup", "otto", "1.3.5", "Otto"), (Object)new Artifact("org.slf4j", "slf4j-android", "1.7.7", "slf4j"), (Object)new Artifact("de.keyboardsurfer.android.widget", "crouton", "1.8.4", "Crouton"), (Object)new Artifact("com.nineoldandroids", "library", "2.4.0", "Nine Old Androids"), (Object)new Artifact("com.jakewharton", "butterknife", "5.1.1", "Butterknife"), (Object)new Artifact("com.google.guava", "guava", "16.0.1", "Guava"), (Object)new Artifact("com.squareup.okhttp", "okhttp", "2.0.0", "okhttp"), (Object)new Artifact("com.squareup.dagger", "dagger", "1.2.1", "Dagger"));
    private static final Map<String, String> SEARCH_OVERRIDES = ImmutableMap.builder().put((Object)"jodatime", (Object)"joda-time").put((Object)"slf4j", (Object)"org.slf4j:slf4j-android").put((Object)"slf4j-android", (Object)"org.slf4j:slf4j-android").put((Object)"animation", (Object)"com.nineoldandroids:library").put((Object)"pulltorefresh", (Object)"com.github.chrisbanes.actionbarpulltorefresh:library").put((Object)"wire", (Object)"wire-runtime").put((Object)"tape", (Object)"com.squareup:tape").put((Object)"annotations", (Object)"androidannotations").put((Object)"svg", (Object)"svg-android").put((Object)"commons", (Object)"org.apache.commons").build();
    private AsyncProcessIcon myProgressIcon;
    private TextFieldWithBrowseButton mySearchField;
    private JTextField mySearchTextField;
    private JPanel myPanel;
    private JBList myResultList;
    private final List<Artifact> myShownItems;
    private final ExecutorService mySearchWorker;
    private final boolean myAndroidModule;
    private final List<String> myAndroidSdkLibraries;

    public MavenDependencyLookupDialog(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myShownItems = Lists.newArrayList();
        this.mySearchWorker = ConcurrencyUtil.newSingleThreadExecutor((String)"Maven dependency lookup");
        this.myAndroidSdkLibraries = Lists.newArrayList();
        this.myAndroidModule = module != null && AndroidFacet.getInstance(module) != null;
        this.myProgressIcon.suspend();
        this.mySearchField.setButtonIcon(AllIcons.Actions.Find);
        this.mySearchField.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenDependencyLookupDialog.this.startSearch();
            }
        });
        this.mySearchTextField = this.mySearchField.getTextField();
        this.mySearchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StringUtil.isEmpty((String)MavenDependencyLookupDialog.this.mySearchField.getText())) {
                    return;
                }
                if (!MavenDependencyLookupDialog.this.isValidCoordinateSelected()) {
                    MavenDependencyLookupDialog.this.startSearch();
                } else {
                    MavenDependencyLookupDialog.this.close(0);
                }
            }
        });
        ImmutableList<Artifact> mavenArtifacts = MavenDependencyLookupDialog.getAvailableGoogleMavenArtifacts(module);
        for (Artifact artifact : mavenArtifacts) {
            this.myAndroidSdkLibraries.add(artifact.getCoordinates());
            this.myShownItems.add(artifact);
        }
        this.myShownItems.addAll(COMMON_LIBRARIES);
        this.myResultList.setModel((ListModel)new CollectionComboBoxModel(this.myShownItems, null));
        this.myResultList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                Artifact value2 = (Artifact)MavenDependencyLookupDialog.this.myResultList.getSelectedValue();
                if (value2 != null) {
                    MavenDependencyLookupDialog.this.mySearchTextField.setText(value2.getCoordinates());
                }
            }
        });
        this.myResultList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && MavenDependencyLookupDialog.this.isValidCoordinateSelected()) {
                    MavenDependencyLookupDialog.this.close(0);
                }
            }
        });
        this.myOKAction = new DialogWrapper.OkAction(){

            protected void doAction(ActionEvent e) {
                String text = MavenDependencyLookupDialog.this.mySearchField.getText();
                if (text != null && !MavenDependencyLookupDialog.hasVersion(text) && MavenDependencyLookupDialog.isKnownLocalArtifact(text)) {
                    MavenDependencyLookupDialog.this.mySearchField.setText(text + ':' + "+");
                }
                super.doAction(e);
            }
        };
        this.init();
    }

    @NotNull
    private static ImmutableList<Artifact> getAvailableGoogleMavenArtifacts(@Nullable Module module) {
        Predicate<GradleVersion> supportVersionFilter;
        Predicate<GoogleMavenArtifactId> useAndroidxFilter;
        ImmutableList.Builder result2 = new ImmutableList.Builder();
        boolean preview = MavenDependencyLookupDialog.isMinSdkVersionPreview(module);
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        GradleVersion highestAndroidx = manager.findHighestAndroidxSupportVersion(module);
        if (highestAndroidx != null) {
            useAndroidxFilter = id -> id.isAndroidxLibrary() || !id.hasAndroidxEquivalent();
            supportVersionFilter = manager.findExistingAndroidxSupportVersionFilter(highestAndroidx);
        } else {
            useAndroidxFilter = id -> !id.isAndroidxLibrary();
            supportVersionFilter = manager.findExistingSupportVersionFilter(module);
        }
        for (GoogleMavenArtifactId id2 : GoogleMavenArtifactId.values()) {
            Artifact artifact;
            Predicate<GradleVersion> filter2;
            String artifactCoordinate;
            if (!useAndroidxFilter.test(id2) || (artifactCoordinate = manager.getArtifactStringCoordinate(id2, filter2 = id2.isPlatformSupportLibrary() ? supportVersionFilter : null, preview)) == null || (artifact = Artifact.fromCoordinate(artifactCoordinate)) == null) continue;
            result2.add((Object)artifact);
        }
        ImmutableList immutableList = result2.build();
        if (immutableList == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    private static boolean isMinSdkVersionPreview(@Nullable Module module) {
        ApiVersion minSdkVersion2;
        AndroidModuleModel androidModel;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (androidModel = AndroidModuleModel.get(facet)) != null && (minSdkVersion2 = androidModel.getSelectedVariant().getMergedFlavor().getMinSdkVersion()) != null) {
            return new AndroidVersion(minSdkVersion2.getApiLevel(), minSdkVersion2.getCodename()).isPreview();
        }
        return false;
    }

    private static boolean isKnownLocalArtifact(@NotNull String text) {
        if (text == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(2);
        }
        String group = MavenDependencyLookupDialog.getGroup(text);
        String artifact = MavenDependencyLookupDialog.getArtifact(text);
        if (group == null || artifact == null) {
            return false;
        }
        GoogleMavenArtifactId artifactId = GoogleMavenArtifactId.Companion.find(group, artifact);
        return artifactId != null;
    }

    @Nullable
    private static String getArtifact(@NotNull String coordinate) {
        int i2;
        if (coordinate == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(3);
        }
        if ((i2 = coordinate.indexOf(58)) >= 0 && i2 + 1 < coordinate.length()) {
            if ((i2 = (coordinate = coordinate.substring(i2 + 1)).indexOf(58)) < 0) {
                i2 = coordinate.length();
            }
            return coordinate.substring(0, i2);
        }
        return null;
    }

    @Nullable
    private static String getGroup(@NotNull String coordinate) {
        int i2;
        if (coordinate == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(4);
        }
        if ((i2 = coordinate.indexOf(58)) > 0) {
            return coordinate.substring(0, i2);
        }
        return null;
    }

    @NotNull
    public String getSearchText() {
        String string = this.mySearchTextField.getText();
        if (string == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSearch() {
        if (this.myProgressIcon.isRunning()) {
            return;
        }
        this.myProgressIcon.resume();
        List<Artifact> list = this.myShownItems;
        synchronized (list) {
            this.myResultList.clearSelection();
            this.myShownItems.clear();
            ((CollectionComboBoxModel)this.myResultList.getModel()).update();
        }
        String text = this.mySearchTextField.getText();
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        String override = SEARCH_OVERRIDES.get(StringUtil.toLowerCase((String)text));
        if (override != null) {
            text = override;
        }
        final String finalText = text;
        this.mySearchWorker.submit(new Runnable(){

            @Override
            public void run() {
                MavenDependencyLookupDialog.this.searchAllRepositories(finalText);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchAllRepositories(@NotNull String text) {
        if (text == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(6);
        }
        try {
            if (!this.myProgressIcon.isRunning()) {
                return;
            }
            ArrayList results = Lists.newArrayList();
            results.addAll(MavenDependencyLookupDialog.searchMavenCentral(text));
            results.addAll(this.searchSdkRepositories(text));
            if (!this.myProgressIcon.isRunning()) {
                return;
            }
            List<Artifact> list = this.myShownItems;
            synchronized (list) {
                for (Object s : results) {
                    Artifact wrappedArtifact = Artifact.fromCoordinate((String)s);
                    if (wrappedArtifact == null || this.myShownItems.contains(wrappedArtifact)) continue;
                    this.myShownItems.add(wrappedArtifact);
                }
                Collections.sort(this.myShownItems, new ArtifactComparator(text));
                if (this.myAndroidModule) {
                    HashSet itemsToRemove = Sets.newHashSet();
                    for (Artifact art : this.myShownItems) {
                        String s = art.getCoordinates();
                        if (!s.endsWith(AAR_PACKAGING)) continue;
                        itemsToRemove.add(s.replace(AAR_PACKAGING, JAR_PACKAGING));
                    }
                    Iterator<Artifact> i2 = this.myShownItems.iterator();
                    while (i2.hasNext()) {
                        Artifact art;
                        art = i2.next();
                        if (!itemsToRemove.contains(art.getCoordinates())) continue;
                        i2.remove();
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = MavenDependencyLookupDialog.this.myShownItems;
                    synchronized (list) {
                        ((CollectionComboBoxModel)MavenDependencyLookupDialog.this.myResultList.getModel()).update();
                        if (MavenDependencyLookupDialog.this.myResultList.getSelectedIndex() == -1 && !MavenDependencyLookupDialog.this.myShownItems.isEmpty()) {
                            MavenDependencyLookupDialog.this.myResultList.setSelectedIndex(0);
                        }
                        if (!MavenDependencyLookupDialog.this.myShownItems.isEmpty()) {
                            MavenDependencyLookupDialog.this.myResultList.requestFocus();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            this.myProgressIcon.suspend();
        }
    }

    @NotNull
    private List<String> searchSdkRepositories(@NotNull String text) {
        if (text == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(7);
        }
        ArrayList results = Lists.newArrayList();
        for (String library : this.myAndroidSdkLibraries) {
            if (!library.contains(text)) continue;
            results.add(library);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> searchMavenCentral(@NotNull String text) {
        if (text == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(9);
        }
        List list = (List)HttpRequests.request((String)String.format(MAVEN_CENTRAL_SEARCH_URL, 50, text)).accept("application/xml").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<List<String>>(){

            public List<String> process(@NotNull HttpRequests.Request request) throws IOException {
                if (request == null) {
                    8.$$$reportNull$$$0(0);
                }
                try {
                    XPath idPath = XPath.newInstance((String)"str[@name='id']");
                    XPath versionPath = XPath.newInstance((String)"str[@name='latestVersion']");
                    List artifacts = XPath.newInstance((String)"/response/result/doc").selectNodes((Object)new SAXBuilder().build((Reader)request.getReader()));
                    ArrayList results = Lists.newArrayListWithExpectedSize((int)artifacts.size());
                    for (Element element : artifacts) {
                        try {
                            String id = ((Element)idPath.selectSingleNode((Object)element)).getValue();
                            results.add(id + ":" + ((Element)versionPath.selectSingleNode((Object)element)).getValue());
                        }
                        catch (NullPointerException nullPointerException) {}
                    }
                    return results;
                }
                catch (JDOMException e) {
                    LOG.error((Throwable)e);
                    return Collections.emptyList();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/android/tools/idea/gradle/structure/editors/MavenDependencyLookupDialog$8", "process"));
            }
        }, Collections.emptyList(), LOG);
        if (list == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(10);
        }
        return list;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchTextField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.isValidCoordinateSelected()) {
            return new ValidationInfo("Please enter a valid coordinate, discover it or select one from the list", this.getPreferredFocusedComponent());
        }
        return super.doValidate();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myProgressIcon);
        this.mySearchWorker.shutdown();
        super.dispose();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        String string = MavenDependencyLookupDialog.class.getName();
        if (string == null) {
            MavenDependencyLookupDialog.$$$reportNull$$$0(12);
        }
        return string;
    }

    private boolean isValidCoordinateSelected() {
        String text = this.mySearchTextField.getText();
        return GradleCoordinate.parseCoordinateString((String)text) != null;
    }

    private void createUIComponents() {
        this.myProgressIcon = new AsyncProcessIcon("Progress");
    }

    public static boolean hasVersion(String coordinateText) {
        return StringUtil.countChars((CharSequence)coordinateText, (char)':') > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/editors/MavenDependencyLookupDialog";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/editors/MavenDependencyLookupDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableGoogleMavenArtifacts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "searchSdkRepositories";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "searchMavenCentral";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isKnownLocalArtifact";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getArtifact";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "searchAllRepositories";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "searchSdkRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "searchMavenCentral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        this.mySearchField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myProgressIcon;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("<html>Enter terms for Maven Central search, or fully-qualified coordinates (e.g. <i>com.google.code.gson:gson:2.2.4</i>)</html>");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 1, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.myResultList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class ArtifactComparator
    implements Comparator<Artifact> {
        @NotNull
        private final String mySearchText;

        private ArtifactComparator(@NotNull String searchText) {
            if (searchText == null) {
                ArtifactComparator.$$$reportNull$$$0(0);
            }
            this.mySearchText = searchText;
        }

        @Override
        public int compare(@NotNull Artifact artifact1, @NotNull Artifact artifact2) {
            int score;
            if (artifact1 == null) {
                ArtifactComparator.$$$reportNull$$$0(1);
            }
            if (artifact2 == null) {
                ArtifactComparator.$$$reportNull$$$0(2);
            }
            if ((score = ArtifactComparator.calculateScore(this.mySearchText, artifact2) - ArtifactComparator.calculateScore(this.mySearchText, artifact1)) != 0) {
                return score;
            }
            return artifact2.myVersion.compareTo(artifact1.myVersion);
        }

        private static int calculateScore(@NotNull String searchText, @NotNull Artifact artifact) {
            if (searchText == null) {
                ArtifactComparator.$$$reportNull$$$0(3);
            }
            if (artifact == null) {
                ArtifactComparator.$$$reportNull$$$0(4);
            }
            int score = 0;
            if (artifact.myArtifactId.equals(searchText)) {
                ++score;
            }
            if (artifact.myArtifactId.contains(searchText)) {
                ++score;
            }
            if (artifact.myGroupId.contains(searchText)) {
                ++score;
            }
            return score;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/structure/editors/MavenDependencyLookupDialog$ArtifactComparator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateScore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Artifact {
        @NotNull
        private final String myGroupId;
        @NotNull
        private final String myArtifactId;
        @NotNull
        private final String myVersion;
        @Nullable
        private final String myDescription;

        Artifact(@NotNull String groupId, @NotNull String artifactId, @NotNull String version2, @Nullable String description) {
            if (groupId == null) {
                Artifact.$$$reportNull$$$0(0);
            }
            if (artifactId == null) {
                Artifact.$$$reportNull$$$0(1);
            }
            if (version2 == null) {
                Artifact.$$$reportNull$$$0(2);
            }
            this.myGroupId = groupId;
            this.myArtifactId = artifactId;
            this.myVersion = version2;
            this.myDescription = description;
        }

        @Nullable
        public static Artifact fromCoordinate(@NotNull String artifactCoordinate) {
            GradleCoordinate gradleCoordinate;
            if (artifactCoordinate == null) {
                Artifact.$$$reportNull$$$0(3);
            }
            if ((gradleCoordinate = GradleCoordinate.parseCoordinateString((String)artifactCoordinate)) == null) {
                return null;
            }
            String groupId = gradleCoordinate.getGroupId();
            String artifactId = gradleCoordinate.getArtifactId();
            if (groupId == null || artifactId == null) {
                return null;
            }
            return new Artifact(groupId, artifactId, gradleCoordinate.getRevision(), groupId + ":" + artifactId);
        }

        @NotNull
        public String toString() {
            if (this.myDescription != null) {
                String string = this.myDescription + " (" + this.getCoordinates() + ")";
                if (string == null) {
                    Artifact.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.getCoordinates();
            if (string == null) {
                Artifact.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getCoordinates() {
            String version2 = "+".equals(this.myVersion) ? "" : ':' + this.myVersion;
            String string = this.myGroupId + ":" + this.myArtifactId + version2;
            if (string == null) {
                Artifact.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactCoordinate";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/editors/MavenDependencyLookupDialog$Artifact";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/editors/MavenDependencyLookupDialog$Artifact";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCoordinates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromCoordinate";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

