/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.dependencies.android.Configuration;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigurationsPanel
extends JPanel {
    @NotNull
    private final List<Configuration> mySelectedConfigurations;
    @NotNull
    private final PsCheckBoxList<Configuration> myConfigurationsList;
    @NotNull
    private final SelectionChangeEventDispatcher<List<Configuration>> myEventDispatcher = new SelectionChangeEventDispatcher();

    ConfigurationsPanel() {
        super(new BorderLayout());
        ArrayList configurations = Lists.newArrayList((Object[])new Configuration[]{Configuration.MAIN, Configuration.ANDROID_TEST, Configuration.UNIT_TEST});
        this.myConfigurationsList = new PsCheckBoxList(configurations);
        this.mySelectedConfigurations = Lists.newArrayList((Object[])new Configuration[]{Configuration.MAIN});
        for (Configuration configuration : configurations) {
            this.myConfigurationsList.setItemSelected(configuration, true);
        }
        this.myConfigurationsList.addCheckBoxListListener((index, value2) -> {
            Configuration configuration = (Configuration)this.myConfigurationsList.getItemAt(index);
            if (configuration != null) {
                if (configuration == Configuration.MAIN) {
                    if (value2) {
                        this.myConfigurationsList.setItemSelected(Configuration.ANDROID_TEST, true);
                        this.myConfigurationsList.setItemSelected(Configuration.UNIT_TEST, true);
                    }
                } else if (!value2) {
                    this.myConfigurationsList.setItemSelected(Configuration.MAIN, false);
                }
            }
            this.updateSelection();
        });
        this.myConfigurationsList.setSelectionChangeListener(newSelection -> this.updateSelection());
        new ListSpeedSearch(this.myConfigurationsList);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myConfigurationsList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)13));
        this.add((Component)scrollPane, "Center");
    }

    private void updateSelection() {
        this.mySelectedConfigurations.clear();
        if (this.myConfigurationsList.isItemSelected(Configuration.MAIN)) {
            this.mySelectedConfigurations.add(Configuration.MAIN);
        } else {
            if (this.myConfigurationsList.isItemSelected(Configuration.ANDROID_TEST)) {
                this.mySelectedConfigurations.add(Configuration.ANDROID_TEST);
            }
            if (this.myConfigurationsList.isItemSelected(Configuration.UNIT_TEST)) {
                this.mySelectedConfigurations.add(Configuration.UNIT_TEST);
            }
        }
        this.myEventDispatcher.selectionChanged(this.mySelectedConfigurations);
    }

    void add(@NotNull SelectionChangeListener<List<Configuration>> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ConfigurationsPanel.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ConfigurationsPanel.$$$reportNull$$$0(1);
        }
        this.myEventDispatcher.addListener(listener2, parentDisposable);
    }

    @Nullable
    JComponent getPreferredFocusedComponent() {
        return this.myConfigurationsList;
    }

    @NotNull
    List<Configuration> getSelectedConfigurations() {
        List<Configuration> list = this.mySelectedConfigurations;
        if (list == null) {
            ConfigurationsPanel.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/dependencies/android/ConfigurationsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/dependencies/android/ConfigurationsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

