/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies;

import com.android.tools.idea.gradle.structure.model.PsModelNameComparator;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import kotlin.Unit;
import org.jdesktop.swingx.JXLabel;
import org.jetbrains.annotations.NotNull;

class ModuleDependenciesForm {
    @NotNull
    private final CheckboxTree myPossibleDependenciesTree;
    @NotNull
    private final Set<PsModule> mySelectedModules;
    private JPanel myMainPanel;
    private JBScrollPane myModulesScrollPane;
    private JXLabel myModulesLabel;

    ModuleDependenciesForm(@NotNull PsModule module) {
        if (module == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.mySelectedModules = Sets.newHashSet();
        this.myModulesLabel.setBorder((Border)BorderFactory.createCompoundBorder(UIUtil.getTextFieldBorder(), JBUI.Borders.empty((int)2)));
        this.myModulesLabel.setBackground(UIUtil.getTextFieldBackground());
        this.myModulesLabel.setText(" ");
        CheckboxTree.CheckboxTreeCellRenderer cellRenderer2 = new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object data;
                if (value2 instanceof DefaultMutableTreeNode && (data = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof PsModule) {
                    PsModule m = (PsModule)data;
                    ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                    textRenderer.setIcon(m.getIcon());
                    textRenderer.append(m.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        };
        CheckedTreeNode root = new CheckedTreeNode(null);
        List<PsModule> modules = ModuleDependenciesForm.findAvailableModules(module);
        Collections.sort(modules, new PsModelNameComparator());
        modules.forEach(m -> {
            CheckedTreeNode node = new CheckedTreeNode(m);
            node.setChecked(false);
            root.add((MutableTreeNode)node);
        });
        this.myPossibleDependenciesTree = new CheckboxTree(cellRenderer2, root);
        this.myPossibleDependenciesTree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                Object data;
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((data = node.getUserObject()) instanceof PsModule) {
                    PsModule m = (PsModule)data;
                    if (node.isChecked()) {
                        ModuleDependenciesForm.this.mySelectedModules.add(m);
                    } else {
                        ModuleDependenciesForm.this.mySelectedModules.remove(m);
                    }
                    Object[] selectedModules = (PsModule[])ModuleDependenciesForm.this.myPossibleDependenciesTree.getCheckedNodes(PsModule.class, null);
                    Arrays.sort(selectedModules, new PsModelNameComparator());
                    String names = Joiner.on((String)", ").join(selectedModules);
                    if (names.isEmpty()) {
                        names = " ";
                    }
                    ModuleDependenciesForm.this.myModulesLabel.setText(names);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/dependencies/ModuleDependenciesForm$2", "nodeStateChanged"));
            }
        });
        this.myModulesScrollPane.setViewportView((Component)this.myPossibleDependenciesTree);
    }

    @NotNull
    private static List<PsModule> findAvailableModules(@NotNull PsModule module) {
        if (module == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(1);
        }
        ArrayList modules = Lists.newArrayList();
        List<PsModule> dependencies = ModuleDependenciesForm.getModuleDependencies(module);
        module.getParent().forEachModule(m -> {
            if (module != m && !dependencies.contains(m) && module.canDependOn((PsModule)m)) {
                modules.add(m);
            }
        });
        ArrayList arrayList = modules;
        if (arrayList == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static List<PsModule> getModuleDependencies(@NotNull PsModule module) {
        if (module == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(3);
        }
        PsProject project = module.getParent();
        ArrayList dependencies = Lists.newArrayList();
        if (module instanceof PsAndroidModule) {
            ((PsAndroidModule)module).getDependencies().forEachModuleDependency(dependency -> {
                String name = dependency.getName();
                PsModule found = project.findModuleByName(name);
                if (found != null) {
                    dependencies.add(found);
                }
                return Unit.INSTANCE;
            });
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        CheckboxTree checkboxTree = this.myPossibleDependenciesTree;
        if (checkboxTree == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(5);
        }
        return checkboxTree;
    }

    @NotNull
    JPanel getPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    List<PsModule> getSelectedModules() {
        ArrayList arrayList = Lists.newArrayList(this.mySelectedModules);
        if (arrayList == null) {
            ModuleDependenciesForm.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/dependencies/ModuleDependenciesForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/dependencies/ModuleDependenciesForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableModules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findAvailableModules";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JXLabel jXLabel;
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myModulesScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Modules:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myModulesLabel = jXLabel = new JXLabel();
        jPanel.add((Component)jXLabel, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

