/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.structure.model.PsGeneralIssue;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.xml.util.XmlStringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"URL_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createIssueFrom", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "syncIssue", "Lcom/android/builder/model/SyncIssue;", "path", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "getSeverity", "Lcom/android/tools/idea/gradle/structure/model/PsIssue$Severity;", "issue", "intellij.android.core"})
public final class PsAndroidModuleAnalyzerKt {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    @VisibleForTesting
    @NotNull
    public static final PsIssue createIssueFrom(@NotNull SyncIssue syncIssue, @NotNull PsPath path) {
        Intrinsics.checkParameterIsNotNull((Object)syncIssue, (String)"syncIssue");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String message = XmlStringUtil.escapeString((String)syncIssue.getMessage());
        Matcher matcher = URL_PATTERN.matcher(message);
        boolean result2 = matcher.find();
        while (result2) {
            String url = matcher.group();
            String string = message;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
            String string2 = url;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url");
            message = StringsKt.replace$default((String)string, (String)string2, (String)("<a href='" + url + "'>" + url + "</a>"), (boolean)false, (int)4, null);
            result2 = matcher.find();
        }
        String string = message;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message");
        PsIssueType psIssueType = PsIssueType.PROJECT_ANALYSIS;
        Intrinsics.checkExpressionValueIsNotNull((Object)psIssueType, (String)"PROJECT_ANALYSIS");
        return new PsGeneralIssue(string, path, psIssueType, PsAndroidModuleAnalyzerKt.getSeverity(syncIssue), null, 16, null);
    }

    private static final PsIssue.Severity getSeverity(SyncIssue issue2) {
        int severity = issue2.getSeverity();
        switch (severity) {
            case 2: {
                return PsIssue.Severity.ERROR;
            }
            case 1: {
                return PsIssue.Severity.WARNING;
            }
        }
        return PsIssue.Severity.INFO;
    }
}

