/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.daemon.LibraryUpdateId;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AvailableLibraryUpdateStorage", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AvailableLibraryUpdateStorage
implements PersistentStateComponent<AvailableLibraryUpdates> {
    @NotNull
    public AvailableLibraryUpdates state = new AvailableLibraryUpdates();

    @NotNull
    public static AvailableLibraryUpdateStorage getInstance(Project project) {
        AvailableLibraryUpdateStorage availableLibraryUpdateStorage = (AvailableLibraryUpdateStorage)ServiceManager.getService((Project)project, AvailableLibraryUpdateStorage.class);
        if (availableLibraryUpdateStorage == null) {
            AvailableLibraryUpdateStorage.$$$reportNull$$$0(0);
        }
        return availableLibraryUpdateStorage;
    }

    @NotNull
    public AvailableLibraryUpdates getState() {
        AvailableLibraryUpdates availableLibraryUpdates = this.state;
        if (availableLibraryUpdates == null) {
            AvailableLibraryUpdateStorage.$$$reportNull$$$0(1);
        }
        return availableLibraryUpdates;
    }

    public void loadState(@NotNull AvailableLibraryUpdates state) {
        if (state == null) {
            AvailableLibraryUpdateStorage.$$$reportNull$$$0(2);
        }
        this.state = state;
        this.state.index();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="library-update")
    public static class AvailableLibraryUpdate {
        @Tag(value="group-id")
        public String groupId;
        @Tag(value="name")
        public String name;
        @Tag(value="version")
        public String version;
        @Tag(value="repository")
        public String repository;
    }

    public static class AvailableLibraryUpdates {
        @XCollection(propertyElementName="library-updates")
        @NotNull
        public List<AvailableLibraryUpdate> updates = Lists.newArrayList();
        @Tag(value="last-search-timestamp")
        public long lastSearchTimeMillis = -1L;
        @Transient
        @NotNull
        private final Map<LibraryUpdateId, AvailableLibraryUpdate> myUpdatesById = Maps.newHashMap();

        public void clear() {
            this.updates.clear();
            this.myUpdatesById.clear();
        }

        void index() {
            this.myUpdatesById.clear();
            this.updates.forEach(this::index);
        }

        public void add(@NotNull FoundArtifact artifact) {
            if (artifact == null) {
                AvailableLibraryUpdates.$$$reportNull$$$0(0);
            }
            AvailableLibraryUpdate update2 = new AvailableLibraryUpdate();
            update2.groupId = artifact.getGroupId();
            update2.name = artifact.getName();
            update2.version = artifact.getVersions().get(0).toString();
            update2.repository = String.join((CharSequence)",", artifact.getRepositoryNames());
            this.updates.add(update2);
            this.index(update2);
        }

        private void index(@NotNull AvailableLibraryUpdate update2) {
            if (update2 == null) {
                AvailableLibraryUpdates.$$$reportNull$$$0(1);
            }
            this.myUpdatesById.put(new LibraryUpdateId(update2.name, update2.groupId), update2);
        }

        @Nullable
        public AvailableLibraryUpdate findUpdateFor(@NotNull PsArtifactDependencySpec spec) {
            GradleVersion foundVersion;
            LibraryUpdateId id;
            AvailableLibraryUpdate update2;
            GradleVersion parsedVersion;
            String version2;
            if (spec == null) {
                AvailableLibraryUpdates.$$$reportNull$$$0(2);
            }
            if (StringUtil.isNotEmpty((String)(version2 = spec.getVersion())) && (parsedVersion = GradleVersion.tryParse((String)spec.getVersion())) != null && (update2 = this.myUpdatesById.get(id = new LibraryUpdateId(spec.getName(), spec.getGroup()))) != null && (foundVersion = GradleVersion.parse((String)update2.version)).compareTo(parsedVersion) > 0) {
                return update2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "update";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "spec";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage$AvailableLibraryUpdates";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "index";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findUpdateFor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

