/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.repo;

import com.android.ide.common.repository.GradleVersion;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class ExternalRepository {
    private static final String URL_TEMPLATE = "http://repo1.maven.org/maven2/%s/%s/maven-metadata.xml";
    private static final String MAVEN_METADATA_VERSIONING = "versioning";
    private static final String MAVEN_METADATA_LATEST = "latest";
    private static final Logger LOG = Logger.getInstance(ExternalRepository.class);
    private final ConcurrentMap<Pair<String, String>, GradleVersion> myLatestVersionCache = Maps.newConcurrentMap();
    private final AtomicBoolean myRequestInProgress = new AtomicBoolean();

    public GradleVersion getLatest(@NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            ExternalRepository.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            ExternalRepository.$$$reportNull$$$0(1);
        }
        return (GradleVersion)this.myLatestVersionCache.get(Pair.create((Object)groupId, (Object)artifactId));
    }

    public void refreshFor(final @NotNull String groupId, final @NotNull String artifactId) {
        if (groupId == null) {
            ExternalRepository.$$$reportNull$$$0(2);
        }
        if (artifactId == null) {
            ExternalRepository.$$$reportNull$$$0(3);
        }
        if (!this.myRequestInProgress.compareAndSet(false, true)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExternalRepository.this.doRefreshFor(groupId, artifactId);
                }
                finally {
                    ExternalRepository.this.myRequestInProgress.set(false);
                }
            }
        });
    }

    private void doRefreshFor(@NotNull String groupId, @NotNull String artifactId) {
        Element rootElement;
        if (groupId == null) {
            ExternalRepository.$$$reportNull$$$0(4);
        }
        if (artifactId == null) {
            ExternalRepository.$$$reportNull$$$0(5);
        }
        String url = String.format(URL_TEMPLATE, groupId.replaceAll("\\.", "/"), artifactId);
        try {
            rootElement = JDOMUtil.load((URL)URI.create(url).toURL());
        }
        catch (JDOMException e) {
            LOG.warn(String.format("Unexpected exception occurred on attempt to parse document from %s (checking the latest version for artifact '%s:%s')", url, groupId, artifactId));
            return;
        }
        catch (IOException e) {
            LOG.warn(String.format("Unexpected I/O exception occurred on attempt to check the latest version for artifact '%s:%s' at external repository (url %s)", groupId, artifactId, url));
            return;
        }
        Element versioning = rootElement.getChild(MAVEN_METADATA_VERSIONING);
        if (versioning == null) {
            LOG.warn(String.format("Can't check the latest version for artifact '%s:%s'. Reason: artifact metadata info downloaded from %s has unknown format - expected to find a <%s> element under a root element but it's not there", groupId, artifactId, url, MAVEN_METADATA_VERSIONING));
            return;
        }
        Element latest = versioning.getChild(MAVEN_METADATA_LATEST);
        if (latest == null) {
            LOG.warn(String.format("Can't check the latest version for artifact '%s:%s'. Reason: artifact metadata info downloaded from %s has unknown format - expected to find a <%s> element under a <%s> element but it's not there", groupId, artifactId, url, MAVEN_METADATA_LATEST, MAVEN_METADATA_VERSIONING));
            return;
        }
        try {
            GradleVersion version2 = GradleVersion.parse((String)latest.getText());
            this.myLatestVersionCache.put((Pair<String, String>)Pair.create((Object)groupId, (Object)artifactId), version2);
        }
        catch (NumberFormatException e) {
            LOG.warn(String.format("Can't check the latest version for artifact '%s:%s'. Reason: artifact metadata info downloaded from %s has unknown version format - '%s'", groupId, artifactId, url, latest.getText()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/service/repo/ExternalRepository";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLatest";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefreshFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

