/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.run;

import com.android.tools.idea.gradle.run.MakeBeforeRunTask;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MakeBeforeRunTaskProviderUtil {
    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(MakeBeforeRunTaskProviderUtil.class);
        if (logger == null) {
            MakeBeforeRunTaskProviderUtil.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public static List<RunConfiguration> getConfigurationsMissingBeforeRunTask(@NotNull Project project) {
        if (project == null) {
            MakeBeforeRunTaskProviderUtil.$$$reportNull$$$0(1);
        }
        if (project.isDisposed()) {
            return new ArrayList<RunConfiguration>();
        }
        return RunManagerEx.getInstanceEx((Project)project).getAllConfigurationsList().stream().filter(config -> MakeBeforeRunTaskProviderUtil.isBeforeRunTaskMissing(project, config)).collect(Collectors.toList());
    }

    public static List<RunConfiguration> fixConfigurationsMissingBeforeRunTask(@NotNull Project project) {
        if (project == null) {
            MakeBeforeRunTaskProviderUtil.$$$reportNull$$$0(2);
        }
        ArrayList<RunConfiguration> result2 = new ArrayList<RunConfiguration>();
        if (project.isDisposed()) {
            return result2;
        }
        MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Trying to fix run configurations of project \"%s\"", project.getName()));
        List<RunConfiguration> list = MakeBeforeRunTaskProviderUtil.getConfigurationsMissingBeforeRunTask(project);
        for (RunConfiguration config : list) {
            MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Trying to fix config \"%s\"", config.getName()));
            if (!MakeBeforeRunTaskProviderUtil.addBeforeRunTaskToConfig(project, config)) continue;
            result2.add(config);
        }
        return result2;
    }

    private static boolean isBeforeRunTaskMissing(@NotNull Project project, @NotNull RunConfiguration config) {
        BeforeRunTaskProvider taskProvider;
        if (project == null) {
            MakeBeforeRunTaskProviderUtil.$$$reportNull$$$0(3);
        }
        if (config == null) {
            MakeBeforeRunTaskProviderUtil.$$$reportNull$$$0(4);
        }
        if (!((taskProvider = BeforeRunTaskProvider.getProvider((Project)project, MakeBeforeRunTaskProvider.ID)) instanceof MakeBeforeRunTaskProvider)) {
            return false;
        }
        MakeBeforeRunTaskProvider beforeRunTaskProvider = (MakeBeforeRunTaskProvider)taskProvider;
        if (!beforeRunTaskProvider.configurationTypeIsSupported(config)) {
            return false;
        }
        if (!beforeRunTaskProvider.configurationTypeIsEnabledByDefault(config)) {
            return false;
        }
        List tasks = RunManagerEx.getInstanceEx((Project)project).getBeforeRunTasks(config, MakeBeforeRunTaskProvider.ID);
        return !tasks.stream().anyMatch(task -> task.isEnabled());
    }

    private static boolean addBeforeRunTaskToConfig(@NotNull Project project, @NotNull RunConfiguration config) {
        if (project == null) {
            MakeBeforeRunTaskProviderUtil.$$$reportNull$$$0(5);
        }
        if (config == null) {
            MakeBeforeRunTaskProviderUtil.$$$reportNull$$$0(6);
        }
        RunManagerEx runManagerEx = RunManagerEx.getInstanceEx((Project)project);
        MakeBeforeRunTaskProvider provider = (MakeBeforeRunTaskProvider)BeforeRunTaskProvider.getProvider((Project)project, MakeBeforeRunTaskProvider.ID);
        if (provider == null) {
            MakeBeforeRunTaskProviderUtil.getLogger().warn(String.format("Skipping config \"%s\" because task provider is not found", config.getName()));
            return false;
        }
        MakeBeforeRunTask newTask = provider.createTask(config);
        if (newTask == null) {
            MakeBeforeRunTaskProviderUtil.getLogger().warn(String.format("Skipping config \"%s\" because provider returned a null task", config.getName()));
            return false;
        }
        List tasks = runManagerEx.getBeforeRunTasks(config);
        tasks.add(newTask);
        runManagerEx.setBeforeRunTasks(config, tasks);
        MakeBeforeRunTaskProviderUtil.getLogger().info(String.format("Added missing task to config \"%s\"", config.getName()));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProviderUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/run/MakeBeforeRunTaskProviderUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationsMissingBeforeRunTask";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fixConfigurationsMissingBeforeRunTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isBeforeRunTaskMissing";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeRunTaskToConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

